#include <linux/config.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/netdevice.h>
#include <linux/init.h>
//#include <linux/moduleparam.h>
#include <asm/uaccess.h>
#include <asm/ioctls.h>
#include <asm/io.h>
#include "arch/arch.h"
int errno=0;
#include <asm/signal.h>
#include <linux/proc_fs.h>

//#define  __KERNEL_SYSCALLS__
#include <asm/unistd.h>
#define DEBUG_MAJOR 62
#ifndef __NR_signal
#define __NR_signal __NR_O32_signal
#define __NR_waitpid __NR_O32_waitpid 
#define __NR_time __NR_O32_time
#endif

static inline _syscall0(int,pause)
static inline _syscall0(int,sync)
static inline _syscall0(pid_t,setsid)
static inline _syscall3(int,write,int,fd,const char *,buf,off_t,count)
static inline _syscall3(int,read,int,fd,char *,buf,off_t,count)
static inline _syscall3(off_t,lseek,int,fd,off_t,offset,int,count)
static inline _syscall1(int,dup,int,fd)
static inline _syscall3(int,execve,const char *,file,char **,argv,char **,envp)
static inline _syscall3(int,open,const char *,file,int,flag,int,mode)
static inline _syscall1(int,close,int,fd)
static inline _syscall1(void,exit,int,exitcode)
static inline _syscall3(pid_t,waitpid,pid_t,pid,int *,wait_stat,int,options)
static inline _syscall1(int,delete_module,const char *,name)
static inline pid_t wait(int * wait_stat)
{
	return waitpid(-1,wait_stat,0);
}

struct __myenv_s;
static char  *getenv(char *name,struct __myenv_s **env);
static void do_cmd(char *p);

#include "malloc.c"
#include "ctype.h"
#include "ctype.c"
#if 0
static void sleep(unsigned howlong)
{
	current->state=TASK_INTERRUPTIBLE;
	schedule_timeout(howlong);
}
#endif

#define nr_strtol simple_strtol
#define nr_strsep strsep

static int X0=0;


static inline _syscall2(unsigned long,signal,int ,sig,void *,handler)
	
//#define nr_printf printk

static char * nr_gets(char *s);
static int nr_printf(char *fmt,...);
static int myargc=0;
static char *myargv[10];


static void chfs(int save)
{
static mm_segment_t old_fs[10];
static int idx=0;
	if(save)
	{
	old_fs[idx++]=get_fs();
	set_fs(KERNEL_DS);
	}
	else set_fs(old_fs[--idx]);
}

static char * nr_gets(char *s)
{
mm_segment_t old_fs;
old_fs=get_fs();
set_fs(KERNEL_DS);
read(0,s,80);
set_fs(old_fs);
	return s;
}

static int nr_printf(char *fmt,...)
{
static char buf[0x200];
mm_segment_t old_fs;
  va_list ap;
  va_start(ap,fmt);
  vsprintf(buf,fmt,ap);
  va_end(ap);
old_fs=get_fs();
set_fs(KERNEL_DS);
write(1,buf,strlen(buf));
set_fs(old_fs);
return 0;
}


#include "cmdparser.c"
void debug(void)
{
char str[100];
quitnow=0;
 while(!quitnow)
 {
    nr_printf("\n-");	
  memset(str,0,100);
	nr_gets(str);
	str[strlen(str)-1]=0;
	do_cmd(str);
 }
}
static int debug_open(struct inode *inode, struct file *filp)
{
debug();
return -1;
}
struct file_operations debug_fops = {
    open:       debug_open,
};

static int proc_read_debug(char *page, char **start,
			     off_t off, int count,
			     int *eof, void *data)
{
	int len;

	debug();
	
	//len = sprintf(page, "jiffies = %ld\n", jiffies);


	return 0;
}
static struct proc_dir_entry *debug_proc_entry=0;
static int rcdevrv=0;
static int dummy_init_module(void)
{
#ifdef MODULE 
	debug();
	nr_printf("quit\n");
	return -1;
#else
	 debug_proc_entry=create_proc_entry("debug",0444,0);
	if (debug_proc_entry) {
		debug_proc_entry->read_proc=proc_read_debug;
		debug_proc_entry->data=0;
	printk("<0>create proc file debug succeed\n");
	}
	else printk("<0>create proc file debug fail\n");

rcdevrv=register_chrdev(DEBUG_MAJOR, "debug", &debug_fops);
if(rcdevrv<0)
	printk("<0>register_chrdev DEBUGMAJOR 62 fail\n");
else 
	printk("<0>register_chrdev DEBUGMAJOR 62 succeed\n");
return 0;
#endif
	
}
static void dummy_cleanup_module(void)
{
if(debug_proc_entry)remove_proc_entry("debug",0);
if(rcdevrv>=0)unregister_chrdev(DEBUG_MAJOR, "debug");
}
module_init(dummy_init_module);
module_exit(dummy_cleanup_module);

#include "env.c"
#include "mem.c"
#include "arch/ls.c"
#include "arch/pwd.c"
#include "arch/cd.c"
#include "arch/mount.c"
#include "arch/pci.c"
#include "arch/exec.c"
#include "arch/writefile.c"
#include "arch/test.c"
#include "arch/pcibus.c"
#include "arch/pager.c"
#include "arch/io.c"
mycmd_init(nocmd,nocmd,"","");
