#include <linux/pci.h>
static int __syscall1(int type,unsigned addr,union commondata *mydata);
static int __syscall2(int type,unsigned addr,union commondata *mydata);
extern int (*syscall1)(int type,unsigned addr,union commondata *mydata);
extern int (*syscall2)(int type,unsigned addr,union commondata *mydata);

static struct _mypciinfo{
	int bus;
	int device;
	int function;
} mpi;


static struct pci_dev *pcidev;
static int __pcisyscall1(int type,unsigned addr,union commondata *mydata)
{
int readdata=0;
switch(type)
{
case 1:pci_read_config_byte(pcidev,addr,(void *)&readdata);mydata->data1=readdata;break;
case 2:pci_read_config_word(pcidev,addr,(void *)&readdata);mydata->data2=readdata;break;
case 4:pci_read_config_dword(pcidev,addr,&readdata);mydata->data4=readdata;break;
case 8:pci_read_config_dword(pcidev,addr,&readdata);mydata->data8[0]=readdata;
	pci_read_config_dword(pcidev,addr+4,&readdata);mydata->data8[1]=readdata;break;
}
return 0;
}

static int __pcisyscall2(int type,unsigned addr,union commondata *mydata)
{
switch(type)
{
case 1:return pci_write_config_byte(pcidev,addr,mydata->data1);
case 2:return pci_write_config_word(pcidev,addr,mydata->data2);
case 4:return pci_write_config_dword(pcidev,addr,mydata->data4);
case 8:break;
}
return -1;
}
struct pci_dev *
pci_find_slot(unsigned int bus, unsigned int devfn);
static int PciConfSel(int argc,char **argv)
{

		if(argc<2||argc>4){return -1;}
		if(argc>=2)mpi.bus=nr_strtol(argv[1],0,10);
		if(argc>=3)mpi.device=nr_strtol(argv[2],0,10);
		if(argc>=4)mpi.function=nr_strtol(argv[3],0,10);
		pcidev=(void *)-1;
		pcidev=(void *)pci_find_slot(mpi.bus,(mpi.device<<3)|mpi.function);
	    if(pcidev)
		{
    	nr_printf("select pci configure space bus:%d dev:%d func:%d\n",mpi.bus,mpi.device,mpi.function);
    	syscall1=__pcisyscall1;
    	syscall2=__pcisyscall2;
		}
		else {
		
    	syscall1=__syscall1;
    	syscall2=__syscall2;
    	nr_printf("can find the device,select normal memory space\n");
		}
		return 0;
}


mycmd_init(pcs,PciConfSel,"pcs bus [dev] [func]","Pci Configure sel,bus==-1 for normal memory access");
