/*******************************************************************************
 *
 * Copyright (c) 2004-2008 by Vivante Corp.  All rights reserved.
 *
 * The material in this file is confidential and contains trade secrets of
 * Vivante Corporation.  This is proprietary information owned by Vivante
 * Corporation.  No part of this work may be disclosed, reproduced, copied,
 * transmitted, or used in any way for any purpose, without the express
 * written permission of Vivante Corporation.
 *
 ******************************************************************************/

/*******************************************************************************
 *
 * This file is automatically generated on Mon Apr 13 01:22:32 2009
 *
 * Any changes made to this file are lost at the next compile run!
 * So better make sure you update the source .r files instead!
 *
 ******************************************************************************/

////////////////////////////////////////////////////////////////////////////////
//                            ~~~~~~~~~~~~~~~~~~~~                            //
//                            Module DrawingEngine                            //
//                            ~~~~~~~~~~~~~~~~~~~~                            //
////////////////////////////////////////////////////////////////////////////////

// Register AQDESrcAddress.
// ~~~~~~~~~~~~~~~~~~~~~~~

// 32-bit aligned base address of the source surface.

#define AQDESrcAddressRegAddrs                                            0x0480
#define AQDE_SRC_ADDRESS_Address                                         0x01200
#define AQDE_SRC_ADDRESS_MSB                                                  15
#define AQDE_SRC_ADDRESS_LSB                                                   0
#define AQDE_SRC_ADDRESS_Count                                                 1
#define AQDE_SRC_ADDRESS_FieldMask                                    0xFFFFFFFF
#define AQDE_SRC_ADDRESS_ReadMask                                     0xFFFFFFFC
#define AQDE_SRC_ADDRESS_WriteMask                                    0xFFFFFFFC
#define AQDE_SRC_ADDRESS_ResetValue                                   0x00000000

#define AQDE_SRC_ADDRESS_TYPE                                              31:31
#define AQDE_SRC_ADDRESS_TYPE_End                                             31
#define AQDE_SRC_ADDRESS_TYPE_Start                                           31
#define   AQDE_SRC_ADDRESS_TYPE_SYSTEM                                       0x0
#define   AQDE_SRC_ADDRESS_TYPE_VIRTUAL_SYSTEM                               0x1

#define AQDE_SRC_ADDRESS_ADDRESS                                            30:0
#define AQDE_SRC_ADDRESS_ADDRESS_End                                          30
#define AQDE_SRC_ADDRESS_ADDRESS_Start                                         0

// Register AQDESrcStride.
// ~~~~~~~~~~~~~~~~~~~~~~

// Stride of the source surface in bytes. To calculate the
// stride multiply the surface width in pixels (8-pixel aligned)
// by the number of bytes per pixel.

#define AQDESrcStrideRegAddrs                                             0x0481
#define AQDE_SRC_STRIDE_Address                                          0x01204
#define AQDE_SRC_STRIDE_MSB                                                   15
#define AQDE_SRC_STRIDE_LSB                                                    0
#define AQDE_SRC_STRIDE_Count                                                  1
#define AQDE_SRC_STRIDE_FieldMask                                     0x0003FFFF
#define AQDE_SRC_STRIDE_ReadMask                                      0x0003FFFC
#define AQDE_SRC_STRIDE_WriteMask                                     0x0003FFFC
#define AQDE_SRC_STRIDE_ResetValue                                    0x00000000

#define AQDE_SRC_STRIDE_STRIDE                                              17:0
#define AQDE_SRC_STRIDE_STRIDE_End                                            17
#define AQDE_SRC_STRIDE_STRIDE_Start                                           0

// Register AQDESrcRotationConfig.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// 90 degree rotation configuration for the source surface.
// Width field specifies the width of the surface in pixels.

#define AQDESrcRotationConfigRegAddrs                                     0x0482
#define AQDE_SRC_ROTATION_CONFIG_Address                                 0x01208
#define AQDE_SRC_ROTATION_CONFIG_MSB                                          15
#define AQDE_SRC_ROTATION_CONFIG_LSB                                           0
#define AQDE_SRC_ROTATION_CONFIG_Count                                         1
#define AQDE_SRC_ROTATION_CONFIG_FieldMask                            0x0001FFFF
#define AQDE_SRC_ROTATION_CONFIG_ReadMask                             0x0001FFFF
#define AQDE_SRC_ROTATION_CONFIG_WriteMask                            0x0001FFFF
#define AQDE_SRC_ROTATION_CONFIG_ResetValue                           0x00000000

#define AQDE_SRC_ROTATION_CONFIG_WIDTH                                      15:0
#define AQDE_SRC_ROTATION_CONFIG_WIDTH_End                                    15
#define AQDE_SRC_ROTATION_CONFIG_WIDTH_Start                                   0

#define AQDE_SRC_ROTATION_CONFIG_ROTATION                                  16:16
#define AQDE_SRC_ROTATION_CONFIG_ROTATION_End                                 16
#define AQDE_SRC_ROTATION_CONFIG_ROTATION_Start                               16
#define   AQDE_SRC_ROTATION_CONFIG_ROTATION_NORMAL                           0x0
#define   AQDE_SRC_ROTATION_CONFIG_ROTATION_ROTATED                          0x1

// Register AQDESrcConfig.
// ~~~~~~~~~~~~~~~~~~~~~~

// Source surface configuration register.

#define AQDESrcConfigRegAddrs                                             0x0483
#define AQDE_SRC_CONFIG_Address                                          0x0120C
#define AQDE_SRC_CONFIG_MSB                                                   15
#define AQDE_SRC_CONFIG_LSB                                                    0
#define AQDE_SRC_CONFIG_Count                                                  1
#define AQDE_SRC_CONFIG_FieldMask                                     0x0001B1FF
#define AQDE_SRC_CONFIG_ReadMask                                      0x0001B1FF
#define AQDE_SRC_CONFIG_WriteMask                                     0x0001B1FF
#define AQDE_SRC_CONFIG_ResetValue                                    0x00000000

// Mono expansion: if not set, the source color will be
// decided by the values straight from AQDESrcColorFg and
// AQDESrcColorBg registers. If set, the values will first be
// converted to the destination format.
#define AQDE_SRC_CONFIG_COLOR_CONVERT                                      16:16
#define AQDE_SRC_CONFIG_COLOR_CONVERT_End                                     16
#define AQDE_SRC_CONFIG_COLOR_CONVERT_Start                                   16
#define   AQDE_SRC_CONFIG_COLOR_CONVERT_OFF                                  0x0
#define   AQDE_SRC_CONFIG_COLOR_CONVERT_ON                                   0x1

// Mono expansion: if 0, transparency color will be 0,
// otherwise transparency color will be 1.
#define AQDE_SRC_CONFIG_MONO_TRANSPARENCY                                  15:15
#define AQDE_SRC_CONFIG_MONO_TRANSPARENCY_End                                 15
#define AQDE_SRC_CONFIG_MONO_TRANSPARENCY_Start                               15
#define   AQDE_SRC_CONFIG_MONO_TRANSPARENCY_BACKGROUND                       0x0
#define   AQDE_SRC_CONFIG_MONO_TRANSPARENCY_FOREGROUND                       0x1

// Mono expansion or masked blit: stream packing in pixels.
// Determines how many horizontal pixels are there per each
// 32-bit chunk. For example, if set to Packed8, each 32-bit
// chunk is 8-pixel wide, which also means that it defines 4
// vertical lines of pixels.
#define AQDE_SRC_CONFIG_PACK                                               13:12
#define AQDE_SRC_CONFIG_PACK_End                                              13
#define AQDE_SRC_CONFIG_PACK_Start                                            12
#define   AQDE_SRC_CONFIG_PACK_PACKED8                                       0x0
#define   AQDE_SRC_CONFIG_PACK_PACKED16                                      0x1
#define   AQDE_SRC_CONFIG_PACK_PACKED32                                      0x2
#define   AQDE_SRC_CONFIG_PACK_UNPACKED                                      0x3

// Source data location: set to STREAM for mono expansion
// blits or masked blits. For mono expansion blits the
// complete bitmap comes from the command stream. For masked
// blits the source data comes from the memory and the mask
// from the command stream.
#define AQDE_SRC_CONFIG_LOCATION                                             8:8
#define AQDE_SRC_CONFIG_LOCATION_End                                           8
#define AQDE_SRC_CONFIG_LOCATION_Start                                         8
#define   AQDE_SRC_CONFIG_LOCATION_MEMORY                                    0x0
#define   AQDE_SRC_CONFIG_LOCATION_STREAM                                    0x1

// Source linear/tiled address computation control.
#define AQDE_SRC_CONFIG_TILED                                                7:7
#define AQDE_SRC_CONFIG_TILED_End                                              7
#define AQDE_SRC_CONFIG_TILED_Start                                            7
#define   AQDE_SRC_CONFIG_TILED_DISABLED                                     0x0
#define   AQDE_SRC_CONFIG_TILED_ENABLED                                      0x1

// If set to ABSOLUTE, the source coordinates are treated as
// absolute coordinates inside the source surface. If set to
// RELATIVE, the source coordinates are treated as the
// offsets from the destination coordinates with the source
// size equal to the size of the destination.
#define AQDE_SRC_CONFIG_SRC_RELATIVE                                         6:6
#define AQDE_SRC_CONFIG_SRC_RELATIVE_End                                       6
#define AQDE_SRC_CONFIG_SRC_RELATIVE_Start                                     6
#define   AQDE_SRC_CONFIG_SRC_RELATIVE_ABSOLUTE                              0x0
#define   AQDE_SRC_CONFIG_SRC_RELATIVE_RELATIVE                              0x1

// Source transparency configuration. If set to OPAQUE, the
// transparency will be decided by the pattern mask if
// pattern is being used. If set to TRANSPARENT, each source
// pixel will be compared against AQDESrcColorBg register for
// color blits or MONO_TRANSPARENCY field of this register
// for mono expansion blits to determine whether the pixel is
// transparent or not. If set to MASKED_MASK, the
// transparency is determined based on the mask bits for
// masked blits. If set to MASKED_PATTERN, the transparency
// will be decided by the pattern mask; this setting is
// functionally identical to OPAQUE. Once the transarency is
// decided, the value (0 for opaque, 1 for transparent) it is
// used to select foreground or background ROP code.
#define AQDE_SRC_CONFIG_TRANSPARENCY                                         5:4
#define AQDE_SRC_CONFIG_TRANSPARENCY_End                                       5
#define AQDE_SRC_CONFIG_TRANSPARENCY_Start                                     4
#define   AQDE_SRC_CONFIG_TRANSPARENCY_OPAQUE                                0x0
#define   AQDE_SRC_CONFIG_TRANSPARENCY_TRANSPARENT                           0x1
#define   AQDE_SRC_CONFIG_TRANSPARENCY_MASKED_MASK                           0x2
#define   AQDE_SRC_CONFIG_TRANSPARENCY_MASKED_PATTERN                        0x3

// Defines the pixel format of the source surface.
#define AQDE_SRC_CONFIG_FORMAT                                               3:0
#define AQDE_SRC_CONFIG_FORMAT_End                                             3
#define AQDE_SRC_CONFIG_FORMAT_Start                                           0
#define   AQDE_SRC_CONFIG_FORMAT_X4R4G4B4                                    0x0
#define   AQDE_SRC_CONFIG_FORMAT_A4R4G4B4                                    0x1
#define   AQDE_SRC_CONFIG_FORMAT_X1R5G5B5                                    0x2
#define   AQDE_SRC_CONFIG_FORMAT_A1R5G5B5                                    0x3
#define   AQDE_SRC_CONFIG_FORMAT_R5G6B5                                      0x4
#define   AQDE_SRC_CONFIG_FORMAT_X8R8G8B8                                    0x5
#define   AQDE_SRC_CONFIG_FORMAT_A8R8G8B8                                    0x6
#define   AQDE_SRC_CONFIG_FORMAT_YUY2                                        0x7
#define   AQDE_SRC_CONFIG_FORMAT_UYVY                                        0x8
#define   AQDE_SRC_CONFIG_FORMAT_INDEX8                                      0x9
#define   AQDE_SRC_CONFIG_FORMAT_MONOCHROME                                  0xA
#define   AQDE_SRC_CONFIG_FORMAT_HDR7E3                                      0xB
#define   AQDE_SRC_CONFIG_FORMAT_HDR6E4                                      0xC
#define   AQDE_SRC_CONFIG_FORMAT_HDR5E5                                      0xD
#define   AQDE_SRC_CONFIG_FORMAT_HDR6E5                                      0xE
#define   AQDE_SRC_CONFIG_FORMAT_YV12                                        0xF

// Register AQDESrcOrigin.
// ~~~~~~~~~~~~~~~~~~~~~~

// Absolute or relative (see SRC_RELATIVE field of AQDESrcConfig
// register) X and Y coordinates in pixels of the top left corner
// of the source rectangle within the source surface.

#define AQDESrcOriginRegAddrs                                             0x0484
#define AQDE_SRC_ORIGIN_Address                                          0x01210
#define AQDE_SRC_ORIGIN_MSB                                                   15
#define AQDE_SRC_ORIGIN_LSB                                                    0
#define AQDE_SRC_ORIGIN_Count                                                  1
#define AQDE_SRC_ORIGIN_FieldMask                                     0xFFFFFFFF
#define AQDE_SRC_ORIGIN_ReadMask                                      0xFFFFFFFF
#define AQDE_SRC_ORIGIN_WriteMask                                     0xFFFFFFFF
#define AQDE_SRC_ORIGIN_ResetValue                                    0x00000000

#define AQDE_SRC_ORIGIN_Y                                                  31:16
#define AQDE_SRC_ORIGIN_Y_End                                                 31
#define AQDE_SRC_ORIGIN_Y_Start                                               16

#define AQDE_SRC_ORIGIN_X                                                   15:0
#define AQDE_SRC_ORIGIN_X_End                                                 15
#define AQDE_SRC_ORIGIN_X_Start                                                0

// Register AQDESrcSize.
// ~~~~~~~~~~~~~~~~~~~~

// Width and height of the source rectangle in pixels. If the
// source is relative (see SRC_RELATIVE field of AQDESrcConfig
// register) or a regular bitblt is being performed without
// stretching, this register is ignored and the source size is
// assumed to be the same as the destination.

#define AQDESrcSizeRegAddrs                                               0x0485
#define AQDE_SRC_SIZE_Address                                            0x01214
#define AQDE_SRC_SIZE_MSB                                                     15
#define AQDE_SRC_SIZE_LSB                                                      0
#define AQDE_SRC_SIZE_Count                                                    1
#define AQDE_SRC_SIZE_FieldMask                                       0xFFFFFFFF
#define AQDE_SRC_SIZE_ReadMask                                        0xFFFFFFFF
#define AQDE_SRC_SIZE_WriteMask                                       0xFFFFFFFF
#define AQDE_SRC_SIZE_ResetValue                                      0x00000000

#define AQDE_SRC_SIZE_Y                                                    31:16
#define AQDE_SRC_SIZE_Y_End                                                   31
#define AQDE_SRC_SIZE_Y_Start                                                 16

#define AQDE_SRC_SIZE_X                                                     15:0
#define AQDE_SRC_SIZE_X_End                                                   15
#define AQDE_SRC_SIZE_X_Start                                                  0

// Register AQDESrcColorBg.
// ~~~~~~~~~~~~~~~~~~~~~~~

// In mono expansion defines the source color if the mono pixel
// is 0. In color blits defines the transparency color and is
// assumed to be on the same format as the source.

#define AQDESrcColorBgRegAddrs                                            0x0486
#define AQDE_SRC_COLOR_BG_Address                                        0x01218
#define AQDE_SRC_COLOR_BG_MSB                                                 15
#define AQDE_SRC_COLOR_BG_LSB                                                  0
#define AQDE_SRC_COLOR_BG_Count                                                1
#define AQDE_SRC_COLOR_BG_FieldMask                                   0xFFFFFFFF
#define AQDE_SRC_COLOR_BG_ReadMask                                    0xFFFFFFFF
#define AQDE_SRC_COLOR_BG_WriteMask                                   0xFFFFFFFF
#define AQDE_SRC_COLOR_BG_ResetValue                                  0x00000000

#define AQDE_SRC_COLOR_BG_ALPHA                                            31:24
#define AQDE_SRC_COLOR_BG_ALPHA_End                                           31
#define AQDE_SRC_COLOR_BG_ALPHA_Start                                         24

#define AQDE_SRC_COLOR_BG_RED                                              23:16
#define AQDE_SRC_COLOR_BG_RED_End                                             23
#define AQDE_SRC_COLOR_BG_RED_Start                                           16

#define AQDE_SRC_COLOR_BG_GREEN                                             15:8
#define AQDE_SRC_COLOR_BG_GREEN_End                                           15
#define AQDE_SRC_COLOR_BG_GREEN_Start                                          8

#define AQDE_SRC_COLOR_BG_BLUE                                               7:0
#define AQDE_SRC_COLOR_BG_BLUE_End                                             7
#define AQDE_SRC_COLOR_BG_BLUE_Start                                           0

// Register AQDESrcColorFg.
// ~~~~~~~~~~~~~~~~~~~~~~~

// In mono expansion defines the source color if the mono pixel
// is 1.

#define AQDESrcColorFgRegAddrs                                            0x0487
#define AQDE_SRC_COLOR_FG_Address                                        0x0121C
#define AQDE_SRC_COLOR_FG_MSB                                                 15
#define AQDE_SRC_COLOR_FG_LSB                                                  0
#define AQDE_SRC_COLOR_FG_Count                                                1
#define AQDE_SRC_COLOR_FG_FieldMask                                   0xFFFFFFFF
#define AQDE_SRC_COLOR_FG_ReadMask                                    0xFFFFFFFF
#define AQDE_SRC_COLOR_FG_WriteMask                                   0xFFFFFFFF
#define AQDE_SRC_COLOR_FG_ResetValue                                  0x00000000

#define AQDE_SRC_COLOR_FG_ALPHA                                            31:24
#define AQDE_SRC_COLOR_FG_ALPHA_End                                           31
#define AQDE_SRC_COLOR_FG_ALPHA_Start                                         24

#define AQDE_SRC_COLOR_FG_RED                                              23:16
#define AQDE_SRC_COLOR_FG_RED_End                                             23
#define AQDE_SRC_COLOR_FG_RED_Start                                           16

#define AQDE_SRC_COLOR_FG_GREEN                                             15:8
#define AQDE_SRC_COLOR_FG_GREEN_End                                           15
#define AQDE_SRC_COLOR_FG_GREEN_Start                                          8

#define AQDE_SRC_COLOR_FG_BLUE                                               7:0
#define AQDE_SRC_COLOR_FG_BLUE_End                                             7
#define AQDE_SRC_COLOR_FG_BLUE_Start                                           0

// Register AQDEStretchFactorLow.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQDEStretchFactorLowRegAddrs                                      0x0488
#define AQDE_STRETCH_FACTOR_LOW_Address                                  0x01220
#define AQDE_STRETCH_FACTOR_LOW_MSB                                           15
#define AQDE_STRETCH_FACTOR_LOW_LSB                                            0
#define AQDE_STRETCH_FACTOR_LOW_Count                                          1
#define AQDE_STRETCH_FACTOR_LOW_FieldMask                             0x7FFFFFFF
#define AQDE_STRETCH_FACTOR_LOW_ReadMask                              0x7FFFFFFF
#define AQDE_STRETCH_FACTOR_LOW_WriteMask                             0x7FFFFFFF
#define AQDE_STRETCH_FACTOR_LOW_ResetValue                            0x00000000

// Horizontal stretch factor in 15.16 fixed point format. The
// value is calculated using the following formula: factor =
// ((srcWidth - 1) << 16) / (dstWidth - 1). Stretch blit uses
// only the integer part of the value, while Filter blit uses
// all 31 bits.
#define AQDE_STRETCH_FACTOR_LOW_X                                           30:0
#define AQDE_STRETCH_FACTOR_LOW_X_End                                         30
#define AQDE_STRETCH_FACTOR_LOW_X_Start                                        0

// Register AQDEStretchFactorHigh.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQDEStretchFactorHighRegAddrs                                     0x0489
#define AQDE_STRETCH_FACTOR_HIGH_Address                                 0x01224
#define AQDE_STRETCH_FACTOR_HIGH_MSB                                          15
#define AQDE_STRETCH_FACTOR_HIGH_LSB                                           0
#define AQDE_STRETCH_FACTOR_HIGH_Count                                         1
#define AQDE_STRETCH_FACTOR_HIGH_FieldMask                            0x7FFFFFFF
#define AQDE_STRETCH_FACTOR_HIGH_ReadMask                             0x7FFFFFFF
#define AQDE_STRETCH_FACTOR_HIGH_WriteMask                            0x7FFFFFFF
#define AQDE_STRETCH_FACTOR_HIGH_ResetValue                           0x00000000

// Vertical stretch factor in 15.16 fixed point format. The
// value is calculated using the following formula: factor =
// ((srcHeight - 1) << 16) / (dstHeight - 1). Stretch blit
// uses only the integer part of the value, while Filter blit
// uses all 31 bits.
#define AQDE_STRETCH_FACTOR_HIGH_Y                                          30:0
#define AQDE_STRETCH_FACTOR_HIGH_Y_End                                        30
#define AQDE_STRETCH_FACTOR_HIGH_Y_Start                                       0

// Register AQDEDestAddress.
// ~~~~~~~~~~~~~~~~~~~~~~~~

// 32-bit aligned base address of the destination surface.

#define AQDEDestAddressRegAddrs                                           0x048A
#define AQDE_DEST_ADDRESS_Address                                        0x01228
#define AQDE_DEST_ADDRESS_MSB                                                 15
#define AQDE_DEST_ADDRESS_LSB                                                  0
#define AQDE_DEST_ADDRESS_Count                                                1
#define AQDE_DEST_ADDRESS_FieldMask                                   0xFFFFFFFF
#define AQDE_DEST_ADDRESS_ReadMask                                    0xFFFFFFFC
#define AQDE_DEST_ADDRESS_WriteMask                                   0xFFFFFFFC
#define AQDE_DEST_ADDRESS_ResetValue                                  0x00000000

#define AQDE_DEST_ADDRESS_TYPE                                             31:31
#define AQDE_DEST_ADDRESS_TYPE_End                                            31
#define AQDE_DEST_ADDRESS_TYPE_Start                                          31
#define   AQDE_DEST_ADDRESS_TYPE_SYSTEM                                      0x0
#define   AQDE_DEST_ADDRESS_TYPE_VIRTUAL_SYSTEM                              0x1

#define AQDE_DEST_ADDRESS_ADDRESS                                           30:0
#define AQDE_DEST_ADDRESS_ADDRESS_End                                         30
#define AQDE_DEST_ADDRESS_ADDRESS_Start                                        0

// Register AQDEDestStride.
// ~~~~~~~~~~~~~~~~~~~~~~~

// Stride of the destination surface in bytes. To calculate the
// stride multiply the surface width in pixels (8-pixel aligned)
// by the number of bytes per pixel.

#define AQDEDestStrideRegAddrs                                            0x048B
#define AQDE_DEST_STRIDE_Address                                         0x0122C
#define AQDE_DEST_STRIDE_MSB                                                  15
#define AQDE_DEST_STRIDE_LSB                                                   0
#define AQDE_DEST_STRIDE_Count                                                 1
#define AQDE_DEST_STRIDE_FieldMask                                    0x0003FFFF
#define AQDE_DEST_STRIDE_ReadMask                                     0x0003FFFC
#define AQDE_DEST_STRIDE_WriteMask                                    0x0003FFFC
#define AQDE_DEST_STRIDE_ResetValue                                   0x00000000

#define AQDE_DEST_STRIDE_STRIDE                                             17:0
#define AQDE_DEST_STRIDE_STRIDE_End                                           17
#define AQDE_DEST_STRIDE_STRIDE_Start                                          0

// Register AQDEDestRotationConfig.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// 90 degree rotation configuration for the destination surface.
// Width field specifies the width of the surface in pixels.

#define AQDEDestRotationConfigRegAddrs                                    0x048C
#define AQDE_DEST_ROTATION_CONFIG_Address                                0x01230
#define AQDE_DEST_ROTATION_CONFIG_MSB                                         15
#define AQDE_DEST_ROTATION_CONFIG_LSB                                          0
#define AQDE_DEST_ROTATION_CONFIG_Count                                        1
#define AQDE_DEST_ROTATION_CONFIG_FieldMask                           0x0001FFFF
#define AQDE_DEST_ROTATION_CONFIG_ReadMask                            0x0001FFFF
#define AQDE_DEST_ROTATION_CONFIG_WriteMask                           0x0001FFFF
#define AQDE_DEST_ROTATION_CONFIG_ResetValue                          0x00000000

#define AQDE_DEST_ROTATION_CONFIG_WIDTH                                     15:0
#define AQDE_DEST_ROTATION_CONFIG_WIDTH_End                                   15
#define AQDE_DEST_ROTATION_CONFIG_WIDTH_Start                                  0

#define AQDE_DEST_ROTATION_CONFIG_ROTATION                                 16:16
#define AQDE_DEST_ROTATION_CONFIG_ROTATION_End                                16
#define AQDE_DEST_ROTATION_CONFIG_ROTATION_Start                              16
#define   AQDE_DEST_ROTATION_CONFIG_ROTATION_NORMAL                          0x0
#define   AQDE_DEST_ROTATION_CONFIG_ROTATION_ROTATED                         0x1

// Register AQDEDestConfig.
// ~~~~~~~~~~~~~~~~~~~~~~~

// Destination surface configuration register.

#define AQDEDestConfigRegAddrs                                            0x048D
#define AQDE_DEST_CONFIG_Address                                         0x01234
#define AQDE_DEST_CONFIG_MSB                                                  15
#define AQDE_DEST_CONFIG_LSB                                                   0
#define AQDE_DEST_CONFIG_Count                                                 1
#define AQDE_DEST_CONFIG_FieldMask                                    0x0000710F
#define AQDE_DEST_CONFIG_ReadMask                                     0x0000710F
#define AQDE_DEST_CONFIG_WriteMask                                    0x0000710F
#define AQDE_DEST_CONFIG_ResetValue                                   0x00000000

// Determines the type of primitive to be rendered.
// BIT_BLT_REVERSED and INVALID_COMMAND values are defined
// for internal use and should not be used.
#define AQDE_DEST_CONFIG_COMMAND                                           14:12
#define AQDE_DEST_CONFIG_COMMAND_End                                          14
#define AQDE_DEST_CONFIG_COMMAND_Start                                        12
#define   AQDE_DEST_CONFIG_COMMAND_CLEAR                                     0x0
#define   AQDE_DEST_CONFIG_COMMAND_LINE                                      0x1
#define   AQDE_DEST_CONFIG_COMMAND_BIT_BLT                                   0x2
#define   AQDE_DEST_CONFIG_COMMAND_BIT_BLT_REVERSED                          0x3
#define   AQDE_DEST_CONFIG_COMMAND_STRETCH_BLT                               0x4
#define   AQDE_DEST_CONFIG_COMMAND_HOR_FILTER_BLT                            0x5
#define   AQDE_DEST_CONFIG_COMMAND_VER_FILTER_BLT                            0x6
#define   AQDE_DEST_CONFIG_COMMAND_INVALID_COMMAND                           0x7

// Destination linear/tiled address computation control.
#define AQDE_DEST_CONFIG_TILED                                               8:8
#define AQDE_DEST_CONFIG_TILED_End                                             8
#define AQDE_DEST_CONFIG_TILED_Start                                           8
#define   AQDE_DEST_CONFIG_TILED_DISABLED                                    0x0
#define   AQDE_DEST_CONFIG_TILED_ENABLED                                     0x1

// Defines the pixel format of the destination surface.
#define AQDE_DEST_CONFIG_FORMAT                                              3:0
#define AQDE_DEST_CONFIG_FORMAT_End                                            3
#define AQDE_DEST_CONFIG_FORMAT_Start                                          0
#define   AQDE_DEST_CONFIG_FORMAT_X4R4G4B4                                   0x0
#define   AQDE_DEST_CONFIG_FORMAT_A4R4G4B4                                   0x1
#define   AQDE_DEST_CONFIG_FORMAT_X1R5G5B5                                   0x2
#define   AQDE_DEST_CONFIG_FORMAT_A1R5G5B5                                   0x3
#define   AQDE_DEST_CONFIG_FORMAT_R5G6B5                                     0x4
#define   AQDE_DEST_CONFIG_FORMAT_X8R8G8B8                                   0x5
#define   AQDE_DEST_CONFIG_FORMAT_A8R8G8B8                                   0x6
#define   AQDE_DEST_CONFIG_FORMAT_YUY2                                       0x7
#define   AQDE_DEST_CONFIG_FORMAT_UYVY                                       0x8
#define   AQDE_DEST_CONFIG_FORMAT_INDEX8                                     0x9
#define   AQDE_DEST_CONFIG_FORMAT_MONOCHROME                                 0xA
#define   AQDE_DEST_CONFIG_FORMAT_HDR7E3                                     0xB
#define   AQDE_DEST_CONFIG_FORMAT_HDR6E4                                     0xC
#define   AQDE_DEST_CONFIG_FORMAT_HDR5E5                                     0xD
#define   AQDE_DEST_CONFIG_FORMAT_HDR6E5                                     0xE
#define   AQDE_DEST_CONFIG_FORMAT_YV12                                       0xF

// Register AQDEPatternAddress.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~

// 32-bit aligned base address of 8x8 pattern for SOLID_COLOR
// patterns (see TYPE field in AQDEPatternConfig register).

#define AQDEPatternAddressRegAddrs                                        0x048E
#define AQDE_PATTERN_ADDRESS_Address                                     0x01238
#define AQDE_PATTERN_ADDRESS_MSB                                              15
#define AQDE_PATTERN_ADDRESS_LSB                                               0
#define AQDE_PATTERN_ADDRESS_Count                                             1
#define AQDE_PATTERN_ADDRESS_FieldMask                                0xFFFFFFFF
#define AQDE_PATTERN_ADDRESS_ReadMask                                 0xFFFFFFFC
#define AQDE_PATTERN_ADDRESS_WriteMask                                0xFFFFFFFC
#define AQDE_PATTERN_ADDRESS_ResetValue                               0x00000000

#define AQDE_PATTERN_ADDRESS_TYPE                                          31:31
#define AQDE_PATTERN_ADDRESS_TYPE_End                                         31
#define AQDE_PATTERN_ADDRESS_TYPE_Start                                       31
#define   AQDE_PATTERN_ADDRESS_TYPE_SYSTEM                                   0x0
#define   AQDE_PATTERN_ADDRESS_TYPE_VIRTUAL_SYSTEM                           0x1

#define AQDE_PATTERN_ADDRESS_ADDRESS                                        30:0
#define AQDE_PATTERN_ADDRESS_ADDRESS_End                                      30
#define AQDE_PATTERN_ADDRESS_ADDRESS_Start                                     0

// Register AQDEPatternConfig.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~

// Pattern configuration register.

#define AQDEPatternConfigRegAddrs                                         0x048F
#define AQDE_PATTERN_CONFIG_Address                                      0x0123C
#define AQDE_PATTERN_CONFIG_MSB                                               15
#define AQDE_PATTERN_CONFIG_LSB                                                0
#define AQDE_PATTERN_CONFIG_Count                                              1
#define AQDE_PATTERN_CONFIG_FieldMask                                 0x007700FF
#define AQDE_PATTERN_CONFIG_ReadMask                                  0x007700FF
#define AQDE_PATTERN_CONFIG_WriteMask                                 0x007700FF
#define AQDE_PATTERN_CONFIG_ResetValue                                0x00000000

// Defines the vertical coordinate in pixels of the top left
// corner of 8x8 pattern within 8x8 block.
#define AQDE_PATTERN_CONFIG_ORIGIN_Y                                       22:20
#define AQDE_PATTERN_CONFIG_ORIGIN_Y_End                                      22
#define AQDE_PATTERN_CONFIG_ORIGIN_Y_Start                                    20

// Defines the horizontal coordinate in pixels of the top
// left corner of 8x8 pattern within 8x8 block.
#define AQDE_PATTERN_CONFIG_ORIGIN_X                                       18:16
#define AQDE_PATTERN_CONFIG_ORIGIN_X_End                                      18
#define AQDE_PATTERN_CONFIG_ORIGIN_X_Start                                    16

// Defines what should be initialized. If DEFAULT or
// INIT_CONFIG are set, only pattern configuration will be
// modified. If INIT_PATTERN is set, the pattern cache will
// be reloaded using the current configuration. If INIT_ALL
// is set, first the configuration will be updated, then the
// pattern cache will be reloaded based on the updated
// configuration.
#define AQDE_PATTERN_CONFIG_INIT_TRIGGER                                     7:6
#define AQDE_PATTERN_CONFIG_INIT_TRIGGER_End                                   7
#define AQDE_PATTERN_CONFIG_INIT_TRIGGER_Start                                 6
#define   AQDE_PATTERN_CONFIG_INIT_TRIGGER_DEFAULT                           0x0
#define   AQDE_PATTERN_CONFIG_INIT_TRIGGER_INIT_CONFIG                       0x1
#define   AQDE_PATTERN_CONFIG_INIT_TRIGGER_INIT_PATTERN                      0x2
#define   AQDE_PATTERN_CONFIG_INIT_TRIGGER_INIT_ALL                          0x3

// If disabled, then the pattern color for monochrome and
// solid color patterns will be directly defined with no
// color conversion by the AQDEPatternFgColor and
// AQDEPatternBgColor register pair. If enabled, the color
// values in the register pair are assumed to be in ARGB8
// format and converted to the destination format before they
// are used.
#define AQDE_PATTERN_CONFIG_COLOR_CONVERT                                    5:5
#define AQDE_PATTERN_CONFIG_COLOR_CONVERT_End                                  5
#define AQDE_PATTERN_CONFIG_COLOR_CONVERT_Start                                5
#define   AQDE_PATTERN_CONFIG_COLOR_CONVERT_OFF                              0x0
#define   AQDE_PATTERN_CONFIG_COLOR_CONVERT_ON                               0x1

// If set to SOLID_COLOR, the pattern color is defined by the
// AQDEPatternFgColor register, the value of which could used
// straight or converted to destination format (see
// COLOR_CONVERT field of this register). If set to PATTERN
// and the pattern format is monochrome, the pattern colors
// are determined by the AQDEPatternFgColor and
// AQDEPatternBgColor register pair based on the pattern
// values from AQDEPatternLow and AQDEPatternHigh registers.
// If set to PATTERN and the pattern format is not
// monochrome, the pattern is loaded from memory starting
// from the address specified in AQDEPatternAddress register.
#define AQDE_PATTERN_CONFIG_TYPE                                             4:4
#define AQDE_PATTERN_CONFIG_TYPE_End                                           4
#define AQDE_PATTERN_CONFIG_TYPE_Start                                         4
#define   AQDE_PATTERN_CONFIG_TYPE_SOLID_COLOR                               0x0
#define   AQDE_PATTERN_CONFIG_TYPE_PATTERN                                   0x1

// Defines the pixel format of the pattern and is used for
// PATTERN patterns (see TYPE field of this register).
#define AQDE_PATTERN_CONFIG_FORMAT                                           3:0
#define AQDE_PATTERN_CONFIG_FORMAT_End                                         3
#define AQDE_PATTERN_CONFIG_FORMAT_Start                                       0
#define   AQDE_PATTERN_CONFIG_FORMAT_X4R4G4B4                                0x0
#define   AQDE_PATTERN_CONFIG_FORMAT_A4R4G4B4                                0x1
#define   AQDE_PATTERN_CONFIG_FORMAT_X1R5G5B5                                0x2
#define   AQDE_PATTERN_CONFIG_FORMAT_A1R5G5B5                                0x3
#define   AQDE_PATTERN_CONFIG_FORMAT_R5G6B5                                  0x4
#define   AQDE_PATTERN_CONFIG_FORMAT_X8R8G8B8                                0x5
#define   AQDE_PATTERN_CONFIG_FORMAT_A8R8G8B8                                0x6
#define   AQDE_PATTERN_CONFIG_FORMAT_YUY2                                    0x7
#define   AQDE_PATTERN_CONFIG_FORMAT_UYVY                                    0x8
#define   AQDE_PATTERN_CONFIG_FORMAT_INDEX8                                  0x9
#define   AQDE_PATTERN_CONFIG_FORMAT_MONOCHROME                              0xA
#define   AQDE_PATTERN_CONFIG_FORMAT_HDR7E3                                  0xB
#define   AQDE_PATTERN_CONFIG_FORMAT_HDR6E4                                  0xC
#define   AQDE_PATTERN_CONFIG_FORMAT_HDR5E5                                  0xD
#define   AQDE_PATTERN_CONFIG_FORMAT_HDR6E5                                  0xE
#define   AQDE_PATTERN_CONFIG_FORMAT_YV12                                    0xF

// Register AQDEPatternLow.
// ~~~~~~~~~~~~~~~~~~~~~~~

// This register defines the pattern value for monochrome
// patterns. Color values from the AQDEPatternFgColor and
// AQDEPatternBgColor register pair are used in conjunction with
// the value of this register to determine the final color. The
// pattern is 8x8 pixels and is defined row by row.

#define AQDEPatternLowRegAddrs                                            0x0490
#define AQDE_PATTERN_LOW_Address                                         0x01240
#define AQDE_PATTERN_LOW_MSB                                                  15
#define AQDE_PATTERN_LOW_LSB                                                   0
#define AQDE_PATTERN_LOW_Count                                                 1
#define AQDE_PATTERN_LOW_FieldMask                                    0xFFFFFFFF
#define AQDE_PATTERN_LOW_ReadMask                                     0xFFFFFFFF
#define AQDE_PATTERN_LOW_WriteMask                                    0xFFFFFFFF
#define AQDE_PATTERN_LOW_ResetValue                                   0x00000000

#define AQDE_PATTERN_LOW_ROW0                                                7:0
#define AQDE_PATTERN_LOW_ROW0_End                                              7
#define AQDE_PATTERN_LOW_ROW0_Start                                            0

#define AQDE_PATTERN_LOW_ROW1                                               15:8
#define AQDE_PATTERN_LOW_ROW1_End                                             15
#define AQDE_PATTERN_LOW_ROW1_Start                                            8

#define AQDE_PATTERN_LOW_ROW2                                              23:16
#define AQDE_PATTERN_LOW_ROW2_End                                             23
#define AQDE_PATTERN_LOW_ROW2_Start                                           16

#define AQDE_PATTERN_LOW_ROW3                                              31:24
#define AQDE_PATTERN_LOW_ROW3_End                                             31
#define AQDE_PATTERN_LOW_ROW3_Start                                           24

// Register AQDEPatternHigh.
// ~~~~~~~~~~~~~~~~~~~~~~~~
#define AQDEPatternHighRegAddrs                                           0x0491
#define AQDE_PATTERN_HIGH_Address                                        0x01244
#define AQDE_PATTERN_HIGH_MSB                                                 15
#define AQDE_PATTERN_HIGH_LSB                                                  0
#define AQDE_PATTERN_HIGH_Count                                                1
#define AQDE_PATTERN_HIGH_FieldMask                                   0xFFFFFFFF
#define AQDE_PATTERN_HIGH_ReadMask                                    0xFFFFFFFF
#define AQDE_PATTERN_HIGH_WriteMask                                   0xFFFFFFFF
#define AQDE_PATTERN_HIGH_ResetValue                                  0x00000000

#define AQDE_PATTERN_HIGH_ROW4                                               7:0
#define AQDE_PATTERN_HIGH_ROW4_End                                             7
#define AQDE_PATTERN_HIGH_ROW4_Start                                           0

#define AQDE_PATTERN_HIGH_ROW5                                              15:8
#define AQDE_PATTERN_HIGH_ROW5_End                                            15
#define AQDE_PATTERN_HIGH_ROW5_Start                                           8

#define AQDE_PATTERN_HIGH_ROW6                                             23:16
#define AQDE_PATTERN_HIGH_ROW6_End                                            23
#define AQDE_PATTERN_HIGH_ROW6_Start                                          16

#define AQDE_PATTERN_HIGH_ROW7                                             31:24
#define AQDE_PATTERN_HIGH_ROW7_End                                            31
#define AQDE_PATTERN_HIGH_ROW7_Start                                          24

// Register AQDEPatternMaskLow.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Pattern mask is used only when the transparency is defined by
// pattern. Pattern mask is defined in rows, one bit per pixel.
// Each mask bit is used to select the ROP code to use for this
// particular pixel. If mask bit is 0, the pixel is called
// transparent and background ROP is used, if the bit is 1, the
// pixel is called opaque and foreground ROP is used on it.

#define AQDEPatternMaskLowRegAddrs                                        0x0492
#define AQDE_PATTERN_MASK_LOW_Address                                    0x01248
#define AQDE_PATTERN_MASK_LOW_MSB                                             15
#define AQDE_PATTERN_MASK_LOW_LSB                                              0
#define AQDE_PATTERN_MASK_LOW_Count                                            1
#define AQDE_PATTERN_MASK_LOW_FieldMask                               0xFFFFFFFF
#define AQDE_PATTERN_MASK_LOW_ReadMask                                0xFFFFFFFF
#define AQDE_PATTERN_MASK_LOW_WriteMask                               0xFFFFFFFF
#define AQDE_PATTERN_MASK_LOW_ResetValue                              0xFFFFFFFF

#define AQDE_PATTERN_MASK_LOW_ROW0                                           7:0
#define AQDE_PATTERN_MASK_LOW_ROW0_End                                         7
#define AQDE_PATTERN_MASK_LOW_ROW0_Start                                       0

#define AQDE_PATTERN_MASK_LOW_ROW1                                          15:8
#define AQDE_PATTERN_MASK_LOW_ROW1_End                                        15
#define AQDE_PATTERN_MASK_LOW_ROW1_Start                                       8

#define AQDE_PATTERN_MASK_LOW_ROW2                                         23:16
#define AQDE_PATTERN_MASK_LOW_ROW2_End                                        23
#define AQDE_PATTERN_MASK_LOW_ROW2_Start                                      16

#define AQDE_PATTERN_MASK_LOW_ROW3                                         31:24
#define AQDE_PATTERN_MASK_LOW_ROW3_End                                        31
#define AQDE_PATTERN_MASK_LOW_ROW3_Start                                      24

// Register AQDEPatternMaskHigh.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQDEPatternMaskHighRegAddrs                                       0x0493
#define AQDE_PATTERN_MASK_HIGH_Address                                   0x0124C
#define AQDE_PATTERN_MASK_HIGH_MSB                                            15
#define AQDE_PATTERN_MASK_HIGH_LSB                                             0
#define AQDE_PATTERN_MASK_HIGH_Count                                           1
#define AQDE_PATTERN_MASK_HIGH_FieldMask                              0xFFFFFFFF
#define AQDE_PATTERN_MASK_HIGH_ReadMask                               0xFFFFFFFF
#define AQDE_PATTERN_MASK_HIGH_WriteMask                              0xFFFFFFFF
#define AQDE_PATTERN_MASK_HIGH_ResetValue                             0xFFFFFFFF

#define AQDE_PATTERN_MASK_HIGH_ROW4                                          7:0
#define AQDE_PATTERN_MASK_HIGH_ROW4_End                                        7
#define AQDE_PATTERN_MASK_HIGH_ROW4_Start                                      0

#define AQDE_PATTERN_MASK_HIGH_ROW5                                         15:8
#define AQDE_PATTERN_MASK_HIGH_ROW5_End                                       15
#define AQDE_PATTERN_MASK_HIGH_ROW5_Start                                      8

#define AQDE_PATTERN_MASK_HIGH_ROW6                                        23:16
#define AQDE_PATTERN_MASK_HIGH_ROW6_End                                       23
#define AQDE_PATTERN_MASK_HIGH_ROW6_Start                                     16

#define AQDE_PATTERN_MASK_HIGH_ROW7                                        31:24
#define AQDE_PATTERN_MASK_HIGH_ROW7_End                                       31
#define AQDE_PATTERN_MASK_HIGH_ROW7_Start                                     24

// Register AQDEPatternBgColor.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Defines the background color for monochrome patterns. It can
// be used straight from the register or converted to the
// destination before use (see COLOR_CONVERT field of
// AQDEPatternConfig register).

#define AQDEPatternBgColorRegAddrs                                        0x0494
#define AQDE_PATTERN_BG_COLOR_Address                                    0x01250
#define AQDE_PATTERN_BG_COLOR_MSB                                             15
#define AQDE_PATTERN_BG_COLOR_LSB                                              0
#define AQDE_PATTERN_BG_COLOR_Count                                            1
#define AQDE_PATTERN_BG_COLOR_FieldMask                               0xFFFFFFFF
#define AQDE_PATTERN_BG_COLOR_ReadMask                                0xFFFFFFFF
#define AQDE_PATTERN_BG_COLOR_WriteMask                               0xFFFFFFFF
#define AQDE_PATTERN_BG_COLOR_ResetValue                              0x00000000

#define AQDE_PATTERN_BG_COLOR_ALPHA                                        31:24
#define AQDE_PATTERN_BG_COLOR_ALPHA_End                                       31
#define AQDE_PATTERN_BG_COLOR_ALPHA_Start                                     24

#define AQDE_PATTERN_BG_COLOR_RED                                          23:16
#define AQDE_PATTERN_BG_COLOR_RED_End                                         23
#define AQDE_PATTERN_BG_COLOR_RED_Start                                       16

#define AQDE_PATTERN_BG_COLOR_GREEN                                         15:8
#define AQDE_PATTERN_BG_COLOR_GREEN_End                                       15
#define AQDE_PATTERN_BG_COLOR_GREEN_Start                                      8

#define AQDE_PATTERN_BG_COLOR_BLUE                                           7:0
#define AQDE_PATTERN_BG_COLOR_BLUE_End                                         7
#define AQDE_PATTERN_BG_COLOR_BLUE_Start                                       0

// Register AQDEPatternFgColor.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Defines the foreground color for monochrome patterns, also
// defines the color of SOLID_COLOR patterns. It can be used
// straight from the register or converted to the destination
// before use (see COLOR_CONVERT field of AQDEPatternConfig
// register).

#define AQDEPatternFgColorRegAddrs                                        0x0495
#define AQDE_PATTERN_FG_COLOR_Address                                    0x01254
#define AQDE_PATTERN_FG_COLOR_MSB                                             15
#define AQDE_PATTERN_FG_COLOR_LSB                                              0
#define AQDE_PATTERN_FG_COLOR_Count                                            1
#define AQDE_PATTERN_FG_COLOR_FieldMask                               0xFFFFFFFF
#define AQDE_PATTERN_FG_COLOR_ReadMask                                0xFFFFFFFF
#define AQDE_PATTERN_FG_COLOR_WriteMask                               0xFFFFFFFF
#define AQDE_PATTERN_FG_COLOR_ResetValue                              0x00000000

#define AQDE_PATTERN_FG_COLOR_ALPHA                                        31:24
#define AQDE_PATTERN_FG_COLOR_ALPHA_End                                       31
#define AQDE_PATTERN_FG_COLOR_ALPHA_Start                                     24

#define AQDE_PATTERN_FG_COLOR_RED                                          23:16
#define AQDE_PATTERN_FG_COLOR_RED_End                                         23
#define AQDE_PATTERN_FG_COLOR_RED_Start                                       16

#define AQDE_PATTERN_FG_COLOR_GREEN                                         15:8
#define AQDE_PATTERN_FG_COLOR_GREEN_End                                       15
#define AQDE_PATTERN_FG_COLOR_GREEN_Start                                      8

#define AQDE_PATTERN_FG_COLOR_BLUE                                           7:0
#define AQDE_PATTERN_FG_COLOR_BLUE_End                                         7
#define AQDE_PATTERN_FG_COLOR_BLUE_Start                                       0

// Register AQDEFilterBlit.
// ~~~~~~~~~~~~~~~~~~~~~~~

// Filter blit configuration regisrter. This register MUST be programmed before AQDEFilterKernel.

#define AQDEFilterBlitRegAddrs                                            0x0496
#define AQDE_FILTER_BLIT_Address                                         0x01258
#define AQDE_FILTER_BLIT_MSB                                                  15
#define AQDE_FILTER_BLIT_LSB                                                   0
#define AQDE_FILTER_BLIT_Count                                                 1
#define AQDE_FILTER_BLIT_FieldMask                                    0x000000FF
#define AQDE_FILTER_BLIT_ReadMask                                     0x000000FF
#define AQDE_FILTER_BLIT_WriteMask                                    0x000000FF
#define AQDE_FILTER_BLIT_ResetValue                                   0x00000000

// If set, the horizontal blit will walk all the way to the
// left edge allowing to sample pixels to the left of the
// center which could be beyond the source edge. This assumes
// that there are enough valid pixels beyond the left edge to
// cover the size of the kernel. For example if the kernel
// size is 9, there should be at least 4 valid pixels beyond
// the edge. This mode is used for split frame rendering to
// prevent seams between the subframes.
#define AQDE_FILTER_BLIT_IGNORE_LEFT_EDGE                                    7:7
#define AQDE_FILTER_BLIT_IGNORE_LEFT_EDGE_End                                  7
#define AQDE_FILTER_BLIT_IGNORE_LEFT_EDGE_Start                                7

// The same as IGNORE_LEFT_EDGE field, but for the top edge
// in vertical blit.
#define AQDE_FILTER_BLIT_IGNORE_TOP_EDGE                                     6:6
#define AQDE_FILTER_BLIT_IGNORE_TOP_EDGE_End                                   6
#define AQDE_FILTER_BLIT_IGNORE_TOP_EDGE_Start                                 6

// The same as IGNORE_LEFT_EDGE field, but for the right
// edge.
#define AQDE_FILTER_BLIT_IGNORE_RIGHT_EDGE                                   5:5
#define AQDE_FILTER_BLIT_IGNORE_RIGHT_EDGE_End                                 5
#define AQDE_FILTER_BLIT_IGNORE_RIGHT_EDGE_Start                               5

// The same as IGNORE_LEFT_EDGE field, but for the bottom
// edge in vertical blit.
#define AQDE_FILTER_BLIT_IGNORE_BOTTOM_EDGE                                  4:4
#define AQDE_FILTER_BLIT_IGNORE_BOTTOM_EDGE_End                                4
#define AQDE_FILTER_BLIT_IGNORE_BOTTOM_EDGE_Start                              4

// The size of the kernel; determines number of source
// samples to be taken to determine each destination pixel.
// Valid values are 1, 3, 5, 7, 9.
#define AQDE_FILTER_BLIT_KERNEL_SIZE                                         3:0
#define AQDE_FILTER_BLIT_KERNEL_SIZE_End                                       3
#define AQDE_FILTER_BLIT_KERNEL_SIZE_Start                                     0

// Register AQDEFilterKernel (128 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~~~

// Filter blit coefficient table.

#define AQDEFilterKernelRegAddrs                                          0x0600
#define AQDE_FILTER_KERNEL_Address                                       0x01800
#define AQDE_FILTER_KERNEL_MSB                                                15
#define AQDE_FILTER_KERNEL_LSB                                                 7
#define AQDE_FILTER_KERNEL_Count                                             128
#define AQDE_FILTER_KERNEL_FieldMask                                  0xFFFFFFFF
#define AQDE_FILTER_KERNEL_ReadMask                                   0xFFFFFFFF
#define AQDE_FILTER_KERNEL_WriteMask                                  0xFFFFFFFF
#define AQDE_FILTER_KERNEL_ResetValue                                 0x00000000

#define AQDE_FILTER_KERNEL_COEFFICIENT0                                     15:0
#define AQDE_FILTER_KERNEL_COEFFICIENT0_End                                   15
#define AQDE_FILTER_KERNEL_COEFFICIENT0_Start                                  0

#define AQDE_FILTER_KERNEL_COEFFICIENT1                                    31:16
#define AQDE_FILTER_KERNEL_COEFFICIENT1_End                                   31
#define AQDE_FILTER_KERNEL_COEFFICIENT1_Start                                 16

// Register AQDEIndexColorTable (256 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// 256 color entries for the indexed color mode. Colors are
// assumed to be in the destination format and no color
// conversion is done on the values.

#define AQDEIndexColorTableRegAddrs                                       0x0700
#define AQDE_INDEX_COLOR_TABLE_Address                                   0x01C00
#define AQDE_INDEX_COLOR_TABLE_MSB                                            15
#define AQDE_INDEX_COLOR_TABLE_LSB                                             8
#define AQDE_INDEX_COLOR_TABLE_Count                                         256
#define AQDE_INDEX_COLOR_TABLE_FieldMask                              0xFFFFFFFF
#define AQDE_INDEX_COLOR_TABLE_ReadMask                               0xFFFFFFFF
#define AQDE_INDEX_COLOR_TABLE_WriteMask                              0xFFFFFFFF
#define AQDE_INDEX_COLOR_TABLE_ResetValue                             0x00000000

#define AQDE_INDEX_COLOR_TABLE_ALPHA                                       31:24
#define AQDE_INDEX_COLOR_TABLE_ALPHA_End                                      31
#define AQDE_INDEX_COLOR_TABLE_ALPHA_Start                                    24

#define AQDE_INDEX_COLOR_TABLE_RED                                         23:16
#define AQDE_INDEX_COLOR_TABLE_RED_End                                        23
#define AQDE_INDEX_COLOR_TABLE_RED_Start                                      16

#define AQDE_INDEX_COLOR_TABLE_GREEN                                        15:8
#define AQDE_INDEX_COLOR_TABLE_GREEN_End                                      15
#define AQDE_INDEX_COLOR_TABLE_GREEN_Start                                     8

#define AQDE_INDEX_COLOR_TABLE_BLUE                                          7:0
#define AQDE_INDEX_COLOR_TABLE_BLUE_End                                        7
#define AQDE_INDEX_COLOR_TABLE_BLUE_Start                                      0

// Register AQDERop.
// ~~~~~~~~~~~~~~~~

// Raster operation foreground and background codes. Even though
// ROP is not used in CLEAR, HOR_FILTER_BLT, VER_FILTER_BLT and
// alpha-eanbled BIT_BLTs, ROP code still has to be programmed,
// because the engine makes the decision whether source,
// destination and pattern are involved in the current operation
// and the correct decision is essential for the engine to
// complete the operation as expected.

#define AQDERopRegAddrs                                                   0x0497
#define AQDE_ROP_Address                                                 0x0125C
#define AQDE_ROP_MSB                                                          15
#define AQDE_ROP_LSB                                                           0
#define AQDE_ROP_Count                                                         1
#define AQDE_ROP_FieldMask                                            0x0030FFFF
#define AQDE_ROP_ReadMask                                             0x0030FFFF
#define AQDE_ROP_WriteMask                                            0x0030FFFF
#define AQDE_ROP_ResetValue                                           0x00000000

// ROP type: ROP2, ROP3 or ROP4
#define AQDE_ROP_TYPE                                                      21:20
#define AQDE_ROP_TYPE_End                                                     21
#define AQDE_ROP_TYPE_Start                                                   20
#define   AQDE_ROP_TYPE_ROP2_PATTERN                                         0x0
#define   AQDE_ROP_TYPE_ROP2_SOURCE                                          0x1
#define   AQDE_ROP_TYPE_ROP3                                                 0x2
#define   AQDE_ROP_TYPE_ROP4                                                 0x3

// Background ROP code is used for transparent pixels.
#define AQDE_ROP_ROP_BG                                                     15:8
#define AQDE_ROP_ROP_BG_End                                                   15
#define AQDE_ROP_ROP_BG_Start                                                  8

// Background ROP code is used for opaque pixels.
#define AQDE_ROP_ROP_FG                                                      7:0
#define AQDE_ROP_ROP_FG_End                                                    7
#define AQDE_ROP_ROP_FG_Start                                                  0

// Register AQDEClipTopLeft.
// ~~~~~~~~~~~~~~~~~~~~~~~~

// Top left corner of the clipping rectangle defined in pixels.
// Clipping is always on and everything beyond the clipping
// rectangle will be clipped out. Clipping is not used with
// filter blits.

#define AQDEClipTopLeftRegAddrs                                           0x0498
#define AQDE_CLIP_TOP_LEFT_Address                                       0x01260
#define AQDE_CLIP_TOP_LEFT_MSB                                                15
#define AQDE_CLIP_TOP_LEFT_LSB                                                 0
#define AQDE_CLIP_TOP_LEFT_Count                                               1
#define AQDE_CLIP_TOP_LEFT_FieldMask                                  0x7FFF7FFF
#define AQDE_CLIP_TOP_LEFT_ReadMask                                   0x7FFF7FFF
#define AQDE_CLIP_TOP_LEFT_WriteMask                                  0x7FFF7FFF
#define AQDE_CLIP_TOP_LEFT_ResetValue                                 0x00000000

#define AQDE_CLIP_TOP_LEFT_Y                                               30:16
#define AQDE_CLIP_TOP_LEFT_Y_End                                              30
#define AQDE_CLIP_TOP_LEFT_Y_Start                                            16

#define AQDE_CLIP_TOP_LEFT_X                                                14:0
#define AQDE_CLIP_TOP_LEFT_X_End                                              14
#define AQDE_CLIP_TOP_LEFT_X_Start                                             0

// Register AQDEClipBottomRight.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Bottom right corner of the clipping rectangle defined in
// pixels. Clipping is always on and everything beyond the
// clipping rectangle will be clipped out. Clipping is not used
// with filter blits.

#define AQDEClipBottomRightRegAddrs                                       0x0499
#define AQDE_CLIP_BOTTOM_RIGHT_Address                                   0x01264
#define AQDE_CLIP_BOTTOM_RIGHT_MSB                                            15
#define AQDE_CLIP_BOTTOM_RIGHT_LSB                                             0
#define AQDE_CLIP_BOTTOM_RIGHT_Count                                           1
#define AQDE_CLIP_BOTTOM_RIGHT_FieldMask                              0x7FFF7FFF
#define AQDE_CLIP_BOTTOM_RIGHT_ReadMask                               0x7FFF7FFF
#define AQDE_CLIP_BOTTOM_RIGHT_WriteMask                              0x7FFF7FFF
#define AQDE_CLIP_BOTTOM_RIGHT_ResetValue                             0x00000000

#define AQDE_CLIP_BOTTOM_RIGHT_Y                                           30:16
#define AQDE_CLIP_BOTTOM_RIGHT_Y_End                                          30
#define AQDE_CLIP_BOTTOM_RIGHT_Y_Start                                        16

#define AQDE_CLIP_BOTTOM_RIGHT_X                                            14:0
#define AQDE_CLIP_BOTTOM_RIGHT_X_End                                          14
#define AQDE_CLIP_BOTTOM_RIGHT_X_Start                                         0

// Register AQDEClearByteMask.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQDEClearByteMaskRegAddrs                                         0x049A
#define AQDE_CLEAR_BYTE_MASK_Address                                     0x01268
#define AQDE_CLEAR_BYTE_MASK_MSB                                              15
#define AQDE_CLEAR_BYTE_MASK_LSB                                               0
#define AQDE_CLEAR_BYTE_MASK_Count                                             1
#define AQDE_CLEAR_BYTE_MASK_FieldMask                                0x000000FF
#define AQDE_CLEAR_BYTE_MASK_ReadMask                                 0x000000FF
#define AQDE_CLEAR_BYTE_MASK_WriteMask                                0x000000FF
#define AQDE_CLEAR_BYTE_MASK_ResetValue                               0x00000000

// Byte mask for the clear command; defines which bytes to
// clear with value specified in AQDEClearPixelValueLow and
// AQDEClearPixelValueHigh registers.
#define AQDE_CLEAR_BYTE_MASK_VALUE                                           7:0
#define AQDE_CLEAR_BYTE_MASK_VALUE_End                                         7
#define AQDE_CLEAR_BYTE_MASK_VALUE_Start                                       0

// Register AQDEClearPixelValueLow.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQDEClearPixelValueLowRegAddrs                                    0x049C
#define AQDE_CLEAR_PIXEL_VALUE_LOW_Address                               0x01270
#define AQDE_CLEAR_PIXEL_VALUE_LOW_MSB                                        15
#define AQDE_CLEAR_PIXEL_VALUE_LOW_LSB                                         0
#define AQDE_CLEAR_PIXEL_VALUE_LOW_Count                                       1
#define AQDE_CLEAR_PIXEL_VALUE_LOW_FieldMask                          0xFFFFFFFF
#define AQDE_CLEAR_PIXEL_VALUE_LOW_ReadMask                           0xFFFFFFFF
#define AQDE_CLEAR_PIXEL_VALUE_LOW_WriteMask                          0xFFFFFFFF
#define AQDE_CLEAR_PIXEL_VALUE_LOW_ResetValue                         0x00000000

// Clear value for the clear command. The value is applied
// based on the mask defined in AQDEClearByteMask register.
#define AQDE_CLEAR_PIXEL_VALUE_LOW_VALUE                                    31:0
#define AQDE_CLEAR_PIXEL_VALUE_LOW_VALUE_End                                  31
#define AQDE_CLEAR_PIXEL_VALUE_LOW_VALUE_Start                                 0

// Register AQDEClearPixelValueHigh.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQDEClearPixelValueHighRegAddrs                                   0x049D
#define AQDE_CLEAR_PIXEL_VALUE_HIGH_Address                              0x01274
#define AQDE_CLEAR_PIXEL_VALUE_HIGH_MSB                                       15
#define AQDE_CLEAR_PIXEL_VALUE_HIGH_LSB                                        0
#define AQDE_CLEAR_PIXEL_VALUE_HIGH_Count                                      1
#define AQDE_CLEAR_PIXEL_VALUE_HIGH_FieldMask                         0xFFFFFFFF
#define AQDE_CLEAR_PIXEL_VALUE_HIGH_ReadMask                          0xFFFFFFFF
#define AQDE_CLEAR_PIXEL_VALUE_HIGH_WriteMask                         0xFFFFFFFF
#define AQDE_CLEAR_PIXEL_VALUE_HIGH_ResetValue                        0x00000000

// Clear value for the clear command. The value is applied
// based on the mask defined in AQDEClearByteMask register.
#define AQDE_CLEAR_PIXEL_VALUE_HIGH_VALUE                                   31:0
#define AQDE_CLEAR_PIXEL_VALUE_HIGH_VALUE_End                                 31
#define AQDE_CLEAR_PIXEL_VALUE_HIGH_VALUE_Start                                0

// Register AQDEConfig.
// ~~~~~~~~~~~~~~~~~~~
#define AQDEConfigRegAddrs                                                0x049B
#define AQDE_CONFIG_Address                                              0x0126C
#define AQDE_CONFIG_MSB                                                       15
#define AQDE_CONFIG_LSB                                                        0
#define AQDE_CONFIG_Count                                                      1
#define AQDE_CONFIG_FieldMask                                         0x00000031
#define AQDE_CONFIG_ReadMask                                          0x00000031
#define AQDE_CONFIG_WriteMask                                         0x00000031
#define AQDE_CONFIG_ResetValue                                        0x00000000

#define AQDE_CONFIG_MIRROR_BLT_MODE                                          5:4
#define AQDE_CONFIG_MIRROR_BLT_MODE_End                                        5
#define AQDE_CONFIG_MIRROR_BLT_MODE_Start                                      4
#define   AQDE_CONFIG_MIRROR_BLT_MODE_NORMAL                                 0x0
#define   AQDE_CONFIG_MIRROR_BLT_MODE_HMIRROR                                0x1
#define   AQDE_CONFIG_MIRROR_BLT_MODE_VMIRROR                                0x2
#define   AQDE_CONFIG_MIRROR_BLT_MODE_FULL_MIRROR                            0x3

#define AQDE_CONFIG_MIRROR_BLT_ENABLE                                        0:0
#define AQDE_CONFIG_MIRROR_BLT_ENABLE_End                                      0
#define AQDE_CONFIG_MIRROR_BLT_ENABLE_Start                                    0
#define   AQDE_CONFIG_MIRROR_BLT_ENABLE_OFF                                  0x0
#define   AQDE_CONFIG_MIRROR_BLT_ENABLE_ON                                   0x1

// Register AQDESrcOriginFraction.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Fraction for the source origin. Together with values in
// AQDESrcOrigin these values form signed 16.16 fixed point
// origin for the source rectangle. Fractions are only used in
// filter blit in split frame mode.

#define AQDESrcOriginFractionRegAddrs                                     0x049E
#define AQDE_SRC_ORIGIN_FRACTION_Address                                 0x01278
#define AQDE_SRC_ORIGIN_FRACTION_MSB                                          15
#define AQDE_SRC_ORIGIN_FRACTION_LSB                                           0
#define AQDE_SRC_ORIGIN_FRACTION_Count                                         1
#define AQDE_SRC_ORIGIN_FRACTION_FieldMask                            0xFFFFFFFF
#define AQDE_SRC_ORIGIN_FRACTION_ReadMask                             0xFFFFFFFF
#define AQDE_SRC_ORIGIN_FRACTION_WriteMask                            0xFFFFFFFF
#define AQDE_SRC_ORIGIN_FRACTION_ResetValue                           0x00000000

#define AQDE_SRC_ORIGIN_FRACTION_Y                                         31:16
#define AQDE_SRC_ORIGIN_FRACTION_Y_End                                        31
#define AQDE_SRC_ORIGIN_FRACTION_Y_Start                                      16

#define AQDE_SRC_ORIGIN_FRACTION_X                                          15:0
#define AQDE_SRC_ORIGIN_FRACTION_X_End                                        15
#define AQDE_SRC_ORIGIN_FRACTION_X_Start                                       0

// Register AQDEAlphaControl.
// ~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQDEAlphaControlRegAddrs                                          0x049F
#define AQDE_ALPHA_CONTROL_Address                                       0x0127C
#define AQDE_ALPHA_CONTROL_MSB                                                15
#define AQDE_ALPHA_CONTROL_LSB                                                 0
#define AQDE_ALPHA_CONTROL_Count                                               1
#define AQDE_ALPHA_CONTROL_FieldMask                                  0xFFFF0001
#define AQDE_ALPHA_CONTROL_ReadMask                                   0xFFFF0001
#define AQDE_ALPHA_CONTROL_WriteMask                                  0xFFFF0001
#define AQDE_ALPHA_CONTROL_ResetValue                                 0x00000000

#define AQDE_ALPHA_CONTROL_ENABLE                                            0:0
#define AQDE_ALPHA_CONTROL_ENABLE_End                                          0
#define AQDE_ALPHA_CONTROL_ENABLE_Start                                        0
#define   AQDE_ALPHA_CONTROL_ENABLE_OFF                                      0x0
#define   AQDE_ALPHA_CONTROL_ENABLE_ON                                       0x1

#define AQDE_ALPHA_CONTROL_SRC_VALUE                                       23:16
#define AQDE_ALPHA_CONTROL_SRC_VALUE_End                                      23
#define AQDE_ALPHA_CONTROL_SRC_VALUE_Start                                    16

#define AQDE_ALPHA_CONTROL_DST_VALUE                                       31:24
#define AQDE_ALPHA_CONTROL_DST_VALUE_End                                      31
#define AQDE_ALPHA_CONTROL_DST_VALUE_Start                                    24

// Register AQDEAlphaModes.
// ~~~~~~~~~~~~~~~~~~~~~~~
#define AQDEAlphaModesRegAddrs                                            0x04A0
#define AQDE_ALPHA_MODES_Address                                         0x01280
#define AQDE_ALPHA_MODES_MSB                                                  15
#define AQDE_ALPHA_MODES_LSB                                                   0
#define AQDE_ALPHA_MODES_Count                                                 1
#define AQDE_ALPHA_MODES_FieldMask                                    0x33113311
#define AQDE_ALPHA_MODES_ReadMask                                     0x33113311
#define AQDE_ALPHA_MODES_WriteMask                                    0x33113311
#define AQDE_ALPHA_MODES_ResetValue                                   0x00000000

#define AQDE_ALPHA_MODES_SRC_ALPHA_MODE                                      0:0
#define AQDE_ALPHA_MODES_SRC_ALPHA_MODE_End                                    0
#define AQDE_ALPHA_MODES_SRC_ALPHA_MODE_Start                                  0
#define   AQDE_ALPHA_MODES_SRC_ALPHA_MODE_NORMAL                             0x0
#define   AQDE_ALPHA_MODES_SRC_ALPHA_MODE_INVERSED                           0x1

#define AQDE_ALPHA_MODES_DST_ALPHA_MODE                                      4:4
#define AQDE_ALPHA_MODES_DST_ALPHA_MODE_End                                    4
#define AQDE_ALPHA_MODES_DST_ALPHA_MODE_Start                                  4
#define   AQDE_ALPHA_MODES_DST_ALPHA_MODE_NORMAL                             0x0
#define   AQDE_ALPHA_MODES_DST_ALPHA_MODE_INVERSED                           0x1

#define AQDE_ALPHA_MODES_GLOBAL_SRC_ALPHA_MODE                               9:8
#define AQDE_ALPHA_MODES_GLOBAL_SRC_ALPHA_MODE_End                             9
#define AQDE_ALPHA_MODES_GLOBAL_SRC_ALPHA_MODE_Start                           8
#define   AQDE_ALPHA_MODES_GLOBAL_SRC_ALPHA_MODE_NORMAL                      0x0
#define   AQDE_ALPHA_MODES_GLOBAL_SRC_ALPHA_MODE_GLOBAL                      0x1
#define   AQDE_ALPHA_MODES_GLOBAL_SRC_ALPHA_MODE_SCALED                      0x2

#define AQDE_ALPHA_MODES_GLOBAL_DST_ALPHA_MODE                             13:12
#define AQDE_ALPHA_MODES_GLOBAL_DST_ALPHA_MODE_End                            13
#define AQDE_ALPHA_MODES_GLOBAL_DST_ALPHA_MODE_Start                          12
#define   AQDE_ALPHA_MODES_GLOBAL_DST_ALPHA_MODE_NORMAL                      0x0
#define   AQDE_ALPHA_MODES_GLOBAL_DST_ALPHA_MODE_GLOBAL                      0x1
#define   AQDE_ALPHA_MODES_GLOBAL_DST_ALPHA_MODE_SCALED                      0x2

#define AQDE_ALPHA_MODES_SRC_COLOR_MODE                                    16:16
#define AQDE_ALPHA_MODES_SRC_COLOR_MODE_End                                   16
#define AQDE_ALPHA_MODES_SRC_COLOR_MODE_Start                                 16
#define   AQDE_ALPHA_MODES_SRC_COLOR_MODE_NORMAL                             0x0
#define   AQDE_ALPHA_MODES_SRC_COLOR_MODE_MULTIPLY                           0x1

#define AQDE_ALPHA_MODES_DST_COLOR_MODE                                    20:20
#define AQDE_ALPHA_MODES_DST_COLOR_MODE_End                                   20
#define AQDE_ALPHA_MODES_DST_COLOR_MODE_Start                                 20
#define   AQDE_ALPHA_MODES_DST_COLOR_MODE_NORMAL                             0x0
#define   AQDE_ALPHA_MODES_DST_COLOR_MODE_MULTIPLY                           0x1

#define AQDE_ALPHA_MODES_SRC_BLENDING_MODE                                 25:24
#define AQDE_ALPHA_MODES_SRC_BLENDING_MODE_End                                25
#define AQDE_ALPHA_MODES_SRC_BLENDING_MODE_Start                              24
#define   AQDE_ALPHA_MODES_SRC_BLENDING_MODE_ZERO                            0x0
#define   AQDE_ALPHA_MODES_SRC_BLENDING_MODE_ONE                             0x1
#define   AQDE_ALPHA_MODES_SRC_BLENDING_MODE_NORMAL                          0x2
#define   AQDE_ALPHA_MODES_SRC_BLENDING_MODE_INVERSED                        0x3

#define AQDE_ALPHA_MODES_DST_BLENDING_MODE                                 29:28
#define AQDE_ALPHA_MODES_DST_BLENDING_MODE_End                                29
#define AQDE_ALPHA_MODES_DST_BLENDING_MODE_Start                              28
#define   AQDE_ALPHA_MODES_DST_BLENDING_MODE_ZERO                            0x0
#define   AQDE_ALPHA_MODES_DST_BLENDING_MODE_ONE                             0x1
#define   AQDE_ALPHA_MODES_DST_BLENDING_MODE_NORMAL                          0x2
#define   AQDE_ALPHA_MODES_DST_BLENDING_MODE_INVERSED                        0x3

// Register UPlaneAddress.
// ~~~~~~~~~~~~~~~~~~~~~~

// 32-bit aligned base address of the source U plane.

#define UPlaneAddressRegAddrs                                             0x04A1
#define UPLANE_ADDRESS_Address                                           0x01284
#define UPLANE_ADDRESS_MSB                                                    15
#define UPLANE_ADDRESS_LSB                                                     0
#define UPLANE_ADDRESS_Count                                                   1
#define UPLANE_ADDRESS_FieldMask                                      0xFFFFFFFF
#define UPLANE_ADDRESS_ReadMask                                       0xFFFFFFFC
#define UPLANE_ADDRESS_WriteMask                                      0xFFFFFFFC
#define UPLANE_ADDRESS_ResetValue                                     0x00000000

#define UPLANE_ADDRESS_TYPE                                                31:31
#define UPLANE_ADDRESS_TYPE_End                                               31
#define UPLANE_ADDRESS_TYPE_Start                                             31
#define   UPLANE_ADDRESS_TYPE_SYSTEM                                         0x0
#define   UPLANE_ADDRESS_TYPE_VIRTUAL_SYSTEM                                 0x1

#define UPLANE_ADDRESS_ADDRESS                                              30:0
#define UPLANE_ADDRESS_ADDRESS_End                                            30
#define UPLANE_ADDRESS_ADDRESS_Start                                           0

// Register UPlaneStride.
// ~~~~~~~~~~~~~~~~~~~~~

// Stride of the source U plane in bytes.

#define UPlaneStrideRegAddrs                                              0x04A2
#define UPLANE_STRIDE_Address                                            0x01288
#define UPLANE_STRIDE_MSB                                                     15
#define UPLANE_STRIDE_LSB                                                      0
#define UPLANE_STRIDE_Count                                                    1
#define UPLANE_STRIDE_FieldMask                                       0x0003FFFF
#define UPLANE_STRIDE_ReadMask                                        0x0003FFFC
#define UPLANE_STRIDE_WriteMask                                       0x0003FFFC
#define UPLANE_STRIDE_ResetValue                                      0x00000000

#define UPLANE_STRIDE_STRIDE                                                17:0
#define UPLANE_STRIDE_STRIDE_End                                              17
#define UPLANE_STRIDE_STRIDE_Start                                             0

// Register VPlaneAddress.
// ~~~~~~~~~~~~~~~~~~~~~~

// 32-bit aligned base address of the source V plane.

#define VPlaneAddressRegAddrs                                             0x04A3
#define VPLANE_ADDRESS_Address                                           0x0128C
#define VPLANE_ADDRESS_MSB                                                    15
#define VPLANE_ADDRESS_LSB                                                     0
#define VPLANE_ADDRESS_Count                                                   1
#define VPLANE_ADDRESS_FieldMask                                      0xFFFFFFFF
#define VPLANE_ADDRESS_ReadMask                                       0xFFFFFFFC
#define VPLANE_ADDRESS_WriteMask                                      0xFFFFFFFC
#define VPLANE_ADDRESS_ResetValue                                     0x00000000

#define VPLANE_ADDRESS_TYPE                                                31:31
#define VPLANE_ADDRESS_TYPE_End                                               31
#define VPLANE_ADDRESS_TYPE_Start                                             31
#define   VPLANE_ADDRESS_TYPE_SYSTEM                                         0x0
#define   VPLANE_ADDRESS_TYPE_VIRTUAL_SYSTEM                                 0x1

#define VPLANE_ADDRESS_ADDRESS                                              30:0
#define VPLANE_ADDRESS_ADDRESS_End                                            30
#define VPLANE_ADDRESS_ADDRESS_Start                                           0

// Register VPlaneStride.
// ~~~~~~~~~~~~~~~~~~~~~

// Stride of the source V plane in bytes.

#define VPlaneStrideRegAddrs                                              0x04A4
#define VPLANE_STRIDE_Address                                            0x01290
#define VPLANE_STRIDE_MSB                                                     15
#define VPLANE_STRIDE_LSB                                                      0
#define VPLANE_STRIDE_Count                                                    1
#define VPLANE_STRIDE_FieldMask                                       0x0003FFFF
#define VPLANE_STRIDE_ReadMask                                        0x0003FFFC
#define VPLANE_STRIDE_WriteMask                                       0x0003FFFC
#define VPLANE_STRIDE_ResetValue                                      0x00000000

#define VPLANE_STRIDE_STRIDE                                                17:0
#define VPLANE_STRIDE_STRIDE_End                                              17
#define VPLANE_STRIDE_STRIDE_Start                                             0

// Register AQVRSourceImageLow.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Bounding box of the source image.

#define AQVRSourceImageLowRegAddrs                                        0x04A6
#define AQVR_SOURCE_IMAGE_LOW_Address                                    0x01298
#define AQVR_SOURCE_IMAGE_LOW_MSB                                             15
#define AQVR_SOURCE_IMAGE_LOW_LSB                                              0
#define AQVR_SOURCE_IMAGE_LOW_Count                                            1
#define AQVR_SOURCE_IMAGE_LOW_FieldMask                               0xFFFFFFFF
#define AQVR_SOURCE_IMAGE_LOW_ReadMask                                0xFFFFFFFF
#define AQVR_SOURCE_IMAGE_LOW_WriteMask                               0xFFFFFFFF
#define AQVR_SOURCE_IMAGE_LOW_ResetValue                              0x00000000

#define AQVR_SOURCE_IMAGE_LOW_LEFT                                          15:0
#define AQVR_SOURCE_IMAGE_LOW_LEFT_End                                        15
#define AQVR_SOURCE_IMAGE_LOW_LEFT_Start                                       0

#define AQVR_SOURCE_IMAGE_LOW_TOP                                          31:16
#define AQVR_SOURCE_IMAGE_LOW_TOP_End                                         31
#define AQVR_SOURCE_IMAGE_LOW_TOP_Start                                       16

// Register AQVRSourceImageHigh.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQVRSourceImageHighRegAddrs                                       0x04A7
#define AQVR_SOURCE_IMAGE_HIGH_Address                                   0x0129C
#define AQVR_SOURCE_IMAGE_HIGH_MSB                                            15
#define AQVR_SOURCE_IMAGE_HIGH_LSB                                             0
#define AQVR_SOURCE_IMAGE_HIGH_Count                                           1
#define AQVR_SOURCE_IMAGE_HIGH_FieldMask                              0xFFFFFFFF
#define AQVR_SOURCE_IMAGE_HIGH_ReadMask                               0xFFFFFFFF
#define AQVR_SOURCE_IMAGE_HIGH_WriteMask                              0xFFFFFFFF
#define AQVR_SOURCE_IMAGE_HIGH_ResetValue                             0x00000000

#define AQVR_SOURCE_IMAGE_HIGH_RIGHT                                        15:0
#define AQVR_SOURCE_IMAGE_HIGH_RIGHT_End                                      15
#define AQVR_SOURCE_IMAGE_HIGH_RIGHT_Start                                     0

#define AQVR_SOURCE_IMAGE_HIGH_BOTTOM                                      31:16
#define AQVR_SOURCE_IMAGE_HIGH_BOTTOM_End                                     31
#define AQVR_SOURCE_IMAGE_HIGH_BOTTOM_Start                                   16

// Register AQVRSourceOriginLow.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Fractional origin of the source window to be rendered within
// the source image.

#define AQVRSourceOriginLowRegAddrs                                       0x04A8
#define AQVR_SOURCE_ORIGIN_LOW_Address                                   0x012A0
#define AQVR_SOURCE_ORIGIN_LOW_MSB                                            15
#define AQVR_SOURCE_ORIGIN_LOW_LSB                                             0
#define AQVR_SOURCE_ORIGIN_LOW_Count                                           1
#define AQVR_SOURCE_ORIGIN_LOW_FieldMask                              0xFFFFFFFF
#define AQVR_SOURCE_ORIGIN_LOW_ReadMask                               0xFFFFFFFF
#define AQVR_SOURCE_ORIGIN_LOW_WriteMask                              0xFFFFFFFF
#define AQVR_SOURCE_ORIGIN_LOW_ResetValue                             0x00000000

#define AQVR_SOURCE_ORIGIN_LOW_X                                            31:0
#define AQVR_SOURCE_ORIGIN_LOW_X_End                                          31
#define AQVR_SOURCE_ORIGIN_LOW_X_Start                                         0

// Register AQVRSourceOriginHigh.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQVRSourceOriginHighRegAddrs                                      0x04A9
#define AQVR_SOURCE_ORIGIN_HIGH_Address                                  0x012A4
#define AQVR_SOURCE_ORIGIN_HIGH_MSB                                           15
#define AQVR_SOURCE_ORIGIN_HIGH_LSB                                            0
#define AQVR_SOURCE_ORIGIN_HIGH_Count                                          1
#define AQVR_SOURCE_ORIGIN_HIGH_FieldMask                             0xFFFFFFFF
#define AQVR_SOURCE_ORIGIN_HIGH_ReadMask                              0xFFFFFFFF
#define AQVR_SOURCE_ORIGIN_HIGH_WriteMask                             0xFFFFFFFF
#define AQVR_SOURCE_ORIGIN_HIGH_ResetValue                            0x00000000

#define AQVR_SOURCE_ORIGIN_HIGH_Y                                           31:0
#define AQVR_SOURCE_ORIGIN_HIGH_Y_End                                         31
#define AQVR_SOURCE_ORIGIN_HIGH_Y_Start                                        0

// Register AQVRTargetWindowLow.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Bounding box of the destination window to be rendered within
// the destinnaation image.

#define AQVRTargetWindowLowRegAddrs                                       0x04AA
#define AQVR_TARGET_WINDOW_LOW_Address                                   0x012A8
#define AQVR_TARGET_WINDOW_LOW_MSB                                            15
#define AQVR_TARGET_WINDOW_LOW_LSB                                             0
#define AQVR_TARGET_WINDOW_LOW_Count                                           1
#define AQVR_TARGET_WINDOW_LOW_FieldMask                              0xFFFFFFFF
#define AQVR_TARGET_WINDOW_LOW_ReadMask                               0xFFFFFFFF
#define AQVR_TARGET_WINDOW_LOW_WriteMask                              0xFFFFFFFF
#define AQVR_TARGET_WINDOW_LOW_ResetValue                             0x00000000

#define AQVR_TARGET_WINDOW_LOW_LEFT                                         15:0
#define AQVR_TARGET_WINDOW_LOW_LEFT_End                                       15
#define AQVR_TARGET_WINDOW_LOW_LEFT_Start                                      0

#define AQVR_TARGET_WINDOW_LOW_TOP                                         31:16
#define AQVR_TARGET_WINDOW_LOW_TOP_End                                        31
#define AQVR_TARGET_WINDOW_LOW_TOP_Start                                      16

// Register AQVRTargetWindowHigh.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQVRTargetWindowHighRegAddrs                                      0x04AB
#define AQVR_TARGET_WINDOW_HIGH_Address                                  0x012AC
#define AQVR_TARGET_WINDOW_HIGH_MSB                                           15
#define AQVR_TARGET_WINDOW_HIGH_LSB                                            0
#define AQVR_TARGET_WINDOW_HIGH_Count                                          1
#define AQVR_TARGET_WINDOW_HIGH_FieldMask                             0xFFFFFFFF
#define AQVR_TARGET_WINDOW_HIGH_ReadMask                              0xFFFFFFFF
#define AQVR_TARGET_WINDOW_HIGH_WriteMask                             0xFFFFFFFF
#define AQVR_TARGET_WINDOW_HIGH_ResetValue                            0x00000000

#define AQVR_TARGET_WINDOW_HIGH_RIGHT                                       15:0
#define AQVR_TARGET_WINDOW_HIGH_RIGHT_End                                     15
#define AQVR_TARGET_WINDOW_HIGH_RIGHT_Start                                    0

#define AQVR_TARGET_WINDOW_HIGH_BOTTOM                                     31:16
#define AQVR_TARGET_WINDOW_HIGH_BOTTOM_End                                    31
#define AQVR_TARGET_WINDOW_HIGH_BOTTOM_Start                                  16

// Register AQVRConfig.
// ~~~~~~~~~~~~~~~~~~~

// Video Rasterizer configuration and kick-off register.

#define AQVRConfigRegAddrs                                                0x04A5
#define AQVR_CONFIG_Address                                              0x01294
#define AQVR_CONFIG_MSB                                                       15
#define AQVR_CONFIG_LSB                                                        0
#define AQVR_CONFIG_Count                                                      1
#define AQVR_CONFIG_FieldMask                                         0x00000009
#define AQVR_CONFIG_ReadMask                                          0x00000009
#define AQVR_CONFIG_WriteMask                                         0x00000009
#define AQVR_CONFIG_ResetValue                                        0x00000000

// Kick-off command.
#define AQVR_CONFIG_START                                                    0:0
#define AQVR_CONFIG_START_End                                                  0
#define AQVR_CONFIG_START_Start                                                0
#define   AQVR_CONFIG_START_HORIZONTAL_BLIT                                  0x0
#define   AQVR_CONFIG_START_VERTICAL_BLIT                                    0x1

#define AQVR_CONFIG_MASK_START                                               3:3
#define AQVR_CONFIG_MASK_START_End                                             3
#define AQVR_CONFIG_MASK_START_Start                                           3
#define   AQVR_CONFIG_MASK_START_ENABLED                                     0x0
#define   AQVR_CONFIG_MASK_START_MASKED                                      0x1

// Register AQPEConfig.
// ~~~~~~~~~~~~~~~~~~~

// PE configuration.

#define AQPEConfigRegAddrs                                                0x04AC
#define AQPE_CONFIG_Address                                              0x012B0
#define AQPE_CONFIG_MSB                                                       15
#define AQPE_CONFIG_LSB                                                        0
#define AQPE_CONFIG_Count                                                      1
#define AQPE_CONFIG_FieldMask                                         0x0000000B
#define AQPE_CONFIG_ReadMask                                          0x0000000B
#define AQPE_CONFIG_WriteMask                                         0x0000000B
#define AQPE_CONFIG_ResetValue                                        0x00000000

// Destination fetch override.
#define AQPE_CONFIG_DESTINATION_FETCH                                        1:0
#define AQPE_CONFIG_DESTINATION_FETCH_End                                      1
#define AQPE_CONFIG_DESTINATION_FETCH_Start                                    0
#define   AQPE_CONFIG_DESTINATION_FETCH_DISABLE                              0x0
#define   AQPE_CONFIG_DESTINATION_FETCH_DEFAULT                              0x1
#define   AQPE_CONFIG_DESTINATION_FETCH_ALWAYS                               0x2

// Destination fetch override mask field.
#define AQPE_CONFIG_MASK_DESTINATION_FETCH                                   3:3
#define AQPE_CONFIG_MASK_DESTINATION_FETCH_End                                 3
#define AQPE_CONFIG_MASK_DESTINATION_FETCH_Start                               3
#define   AQPE_CONFIG_MASK_DESTINATION_FETCH_ENABLED                         0x0
#define   AQPE_CONFIG_MASK_DESTINATION_FETCH_MASKED                          0x1

// Register AQDEDstRotationHeight.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// 180/270 degree rotation configuration for the destination surface.
// Height field specifies the height of the surface in pixels.

#define AQDEDstRotationHeightRegAddrs                                     0x04AD
#define AQDE_DST_ROTATION_HEIGHT_Address                                 0x012B4
#define AQDE_DST_ROTATION_HEIGHT_MSB                                          15
#define AQDE_DST_ROTATION_HEIGHT_LSB                                           0
#define AQDE_DST_ROTATION_HEIGHT_Count                                         1
#define AQDE_DST_ROTATION_HEIGHT_FieldMask                            0x0000FFFF
#define AQDE_DST_ROTATION_HEIGHT_ReadMask                             0x0000FFFF
#define AQDE_DST_ROTATION_HEIGHT_WriteMask                            0x0000FFFF
#define AQDE_DST_ROTATION_HEIGHT_ResetValue                           0x00000000

#define AQDE_DST_ROTATION_HEIGHT_HEIGHT                                     15:0
#define AQDE_DST_ROTATION_HEIGHT_HEIGHT_End                                   15
#define AQDE_DST_ROTATION_HEIGHT_HEIGHT_Start                                  0

// Register AQDESrcRotationHeight.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// 180/270 degree rotation configuration for the Source surface.
// Height field specifies the height of the surface in pixels.

#define AQDESrcRotationHeightRegAddrs                                     0x04AE
#define AQDE_SRC_ROTATION_HEIGHT_Address                                 0x012B8
#define AQDE_SRC_ROTATION_HEIGHT_MSB                                          15
#define AQDE_SRC_ROTATION_HEIGHT_LSB                                           0
#define AQDE_SRC_ROTATION_HEIGHT_Count                                         1
#define AQDE_SRC_ROTATION_HEIGHT_FieldMask                            0x0000FFFF
#define AQDE_SRC_ROTATION_HEIGHT_ReadMask                             0x0000FFFF
#define AQDE_SRC_ROTATION_HEIGHT_WriteMask                            0x0000FFFF
#define AQDE_SRC_ROTATION_HEIGHT_ResetValue                           0x00000000

#define AQDE_SRC_ROTATION_HEIGHT_HEIGHT                                     15:0
#define AQDE_SRC_ROTATION_HEIGHT_HEIGHT_End                                   15
#define AQDE_SRC_ROTATION_HEIGHT_HEIGHT_Start                                  0

// Register AQDERotAngle.
// ~~~~~~~~~~~~~~~~~~~~~

// 90/180/270 degree rotation configuration for the Source surface.
// Height field specifies the height of the surface in pixels.

#define AQDERotAngleRegAddrs                                              0x04AF
#define AQDE_ROT_ANGLE_Address                                           0x012BC
#define AQDE_ROT_ANGLE_MSB                                                    15
#define AQDE_ROT_ANGLE_LSB                                                     0
#define AQDE_ROT_ANGLE_Count                                                   1
#define AQDE_ROT_ANGLE_FieldMask                                      0x0000003F
#define AQDE_ROT_ANGLE_ReadMask                                       0x0000003F
#define AQDE_ROT_ANGLE_WriteMask                                      0x0000003F
#define AQDE_ROT_ANGLE_ResetValue                                     0x00000000

#define AQDE_ROT_ANGLE_SRC                                                   2:0
#define AQDE_ROT_ANGLE_SRC_End                                                 2
#define AQDE_ROT_ANGLE_SRC_Start                                               0
#define   AQDE_ROT_ANGLE_SRC_ROT90                                           0x4
#define   AQDE_ROT_ANGLE_SRC_ROT180                                          0x5
#define   AQDE_ROT_ANGLE_SRC_ROT270                                          0x6

#define AQDE_ROT_ANGLE_DST                                                   5:3
#define AQDE_ROT_ANGLE_DST_End                                                 5
#define AQDE_ROT_ANGLE_DST_Start                                               3
#define   AQDE_ROT_ANGLE_DST_ROT90                                           0x4
#define   AQDE_ROT_ANGLE_DST_ROT180                                          0x5
#define   AQDE_ROT_ANGLE_DST_ROT270                                          0x6

////////////////////////////////////////////////////////////////////////////////
//                                ~~~~~~~~~~~~~                               //
//                                Command DE2PE                               //
//                                ~~~~~~~~~~~~~                               //
////////////////////////////////////////////////////////////////////////////////

// Offset Command.
// ~~~~~~~~~~~~~~

#define DE2PE_COMMAND_PIXEL                                                  0:0
#define DE2PE_COMMAND_PIXEL_End                                                0
#define DE2PE_COMMAND_PIXEL_Start                                              0
#define   DE2PE_COMMAND_PIXEL_INVALID                                        0x0
#define   DE2PE_COMMAND_PIXEL_VALID                                          0x1
#define   DE2PE_COMMAND_PIXEL_OPAQUE                                         0x0
#define   DE2PE_COMMAND_PIXEL_TRANSPARENT                                    0x1

////////////////////////////////////////////////////////////////////////////////
//                           ~~~~~~~~~~~~~~~~~~~~~~~                          //
//                           Command AQDrawingEngine                          //
//                           ~~~~~~~~~~~~~~~~~~~~~~~                          //
////////////////////////////////////////////////////////////////////////////////

// Offset Format.
// ~~~~~~~~~~~~~

#define AQ_DRAWING_ENGINE_FORMAT_FORMAT                                      3:0
#define AQ_DRAWING_ENGINE_FORMAT_FORMAT_End                                    3
#define AQ_DRAWING_ENGINE_FORMAT_FORMAT_Start                                  0
#define   AQ_DRAWING_ENGINE_FORMAT_FORMAT_X4R4G4B4                           0x0
#define   AQ_DRAWING_ENGINE_FORMAT_FORMAT_A4R4G4B4                           0x1
#define   AQ_DRAWING_ENGINE_FORMAT_FORMAT_X1R5G5B5                           0x2
#define   AQ_DRAWING_ENGINE_FORMAT_FORMAT_A1R5G5B5                           0x3
#define   AQ_DRAWING_ENGINE_FORMAT_FORMAT_R5G6B5                             0x4
#define   AQ_DRAWING_ENGINE_FORMAT_FORMAT_X8R8G8B8                           0x5
#define   AQ_DRAWING_ENGINE_FORMAT_FORMAT_A8R8G8B8                           0x6
#define   AQ_DRAWING_ENGINE_FORMAT_FORMAT_YUY2                               0x7
#define   AQ_DRAWING_ENGINE_FORMAT_FORMAT_UYVY                               0x8
#define   AQ_DRAWING_ENGINE_FORMAT_FORMAT_INDEX8                             0x9
#define   AQ_DRAWING_ENGINE_FORMAT_FORMAT_MONOCHROME                         0xA
#define   AQ_DRAWING_ENGINE_FORMAT_FORMAT_HDR7E3                             0xB
#define   AQ_DRAWING_ENGINE_FORMAT_FORMAT_HDR6E4                             0xC
#define   AQ_DRAWING_ENGINE_FORMAT_FORMAT_HDR5E5                             0xD
#define   AQ_DRAWING_ENGINE_FORMAT_FORMAT_HDR6E5                             0xE
#define   AQ_DRAWING_ENGINE_FORMAT_FORMAT_YV12                               0xF

// Offset AlphaBlending.
// ~~~~~~~~~~~~~~~~~~~~

#define AQ_DRAWING_ENGINE_ALPHA_BLENDING_ALPHA_MODE                          0:0
#define AQ_DRAWING_ENGINE_ALPHA_BLENDING_ALPHA_MODE_End                        0
#define AQ_DRAWING_ENGINE_ALPHA_BLENDING_ALPHA_MODE_Start                      0
#define   AQ_DRAWING_ENGINE_ALPHA_BLENDING_ALPHA_MODE_NORMAL                 0x0
#define   AQ_DRAWING_ENGINE_ALPHA_BLENDING_ALPHA_MODE_INVERSED               0x1

#define AQ_DRAWING_ENGINE_ALPHA_BLENDING_GLOBAL_ALPHA_MODE                   9:8
#define AQ_DRAWING_ENGINE_ALPHA_BLENDING_GLOBAL_ALPHA_MODE_End                 9
#define AQ_DRAWING_ENGINE_ALPHA_BLENDING_GLOBAL_ALPHA_MODE_Start               8
#define   AQ_DRAWING_ENGINE_ALPHA_BLENDING_GLOBAL_ALPHA_MODE_NORMAL          0x0
#define   AQ_DRAWING_ENGINE_ALPHA_BLENDING_GLOBAL_ALPHA_MODE_GLOBAL          0x1
#define   AQ_DRAWING_ENGINE_ALPHA_BLENDING_GLOBAL_ALPHA_MODE_SCALED          0x2

#define AQ_DRAWING_ENGINE_ALPHA_BLENDING_COLOR_MODE                        16:16
#define AQ_DRAWING_ENGINE_ALPHA_BLENDING_COLOR_MODE_End                       16
#define AQ_DRAWING_ENGINE_ALPHA_BLENDING_COLOR_MODE_Start                     16
#define   AQ_DRAWING_ENGINE_ALPHA_BLENDING_COLOR_MODE_NORMAL                 0x0
#define   AQ_DRAWING_ENGINE_ALPHA_BLENDING_COLOR_MODE_MULTIPLY               0x1

#define AQ_DRAWING_ENGINE_ALPHA_BLENDING_BLENDING_MODE                     25:24
#define AQ_DRAWING_ENGINE_ALPHA_BLENDING_BLENDING_MODE_End                    25
#define AQ_DRAWING_ENGINE_ALPHA_BLENDING_BLENDING_MODE_Start                  24
#define   AQ_DRAWING_ENGINE_ALPHA_BLENDING_BLENDING_MODE_ZERO                0x0
#define   AQ_DRAWING_ENGINE_ALPHA_BLENDING_BLENDING_MODE_ONE                 0x1
#define   AQ_DRAWING_ENGINE_ALPHA_BLENDING_BLENDING_MODE_NORMAL              0x2
#define   AQ_DRAWING_ENGINE_ALPHA_BLENDING_BLENDING_MODE_INVERSED            0x3

