/*******************************************************************************
 *
 * Copyright (c) 2004-2008 by Vivante Corp.  All rights reserved.
 *
 * The material in this file is confidential and contains trade secrets of
 * Vivante Corporation.  This is proprietary information owned by Vivante
 * Corporation.  No part of this work may be disclosed, reproduced, copied,
 * transmitted, or used in any way for any purpose, without the express
 * written permission of Vivante Corporation.
 *
 ******************************************************************************/

/*******************************************************************************
 *
 * This file is automatically generated on Mon Apr 13 01:22:32 2009
 *
 * Any changes made to this file are lost at the next compile run!
 * So better make sure you update the source .r files instead!
 *
 ******************************************************************************/

////////////////////////////////////////////////////////////////////////////////
//                           ~~~~~~~~~~~~~~~~~~~~~~~                          //
//                           Module MemoryController                          //
//                           ~~~~~~~~~~~~~~~~~~~~~~~                          //
////////////////////////////////////////////////////////////////////////////////

// Register AQMemoryFePageTable.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQMemoryFePageTableRegAddrs                                       0x0100
#define AQ_MEMORY_FE_PAGE_TABLE_Address                                  0x00400
#define AQ_MEMORY_FE_PAGE_TABLE_MSB                                           15
#define AQ_MEMORY_FE_PAGE_TABLE_LSB                                            0
#define AQ_MEMORY_FE_PAGE_TABLE_Count                                          1
#define AQ_MEMORY_FE_PAGE_TABLE_FieldMask                             0xFFFFF000
#define AQ_MEMORY_FE_PAGE_TABLE_ReadMask                              0xFFFFF000
#define AQ_MEMORY_FE_PAGE_TABLE_WriteMask                             0xFFFFF000
#define AQ_MEMORY_FE_PAGE_TABLE_ResetValue                            0x00000000

// Base address for FE virtual address lookup table.
#define AQ_MEMORY_FE_PAGE_TABLE_BASE_ADDRESS                               31:12
#define AQ_MEMORY_FE_PAGE_TABLE_BASE_ADDRESS_End                              31
#define AQ_MEMORY_FE_PAGE_TABLE_BASE_ADDRESS_Start                            12

// Register AQMemoryTxPageTable.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQMemoryTxPageTableRegAddrs                                       0x0101
#define AQ_MEMORY_TX_PAGE_TABLE_Address                                  0x00404
#define AQ_MEMORY_TX_PAGE_TABLE_MSB                                           15
#define AQ_MEMORY_TX_PAGE_TABLE_LSB                                            0
#define AQ_MEMORY_TX_PAGE_TABLE_Count                                          1
#define AQ_MEMORY_TX_PAGE_TABLE_FieldMask                             0xFFFFF000
#define AQ_MEMORY_TX_PAGE_TABLE_ReadMask                              0xFFFFF000
#define AQ_MEMORY_TX_PAGE_TABLE_WriteMask                             0xFFFFF000
#define AQ_MEMORY_TX_PAGE_TABLE_ResetValue                            0x00000000

// Base address for TX virtual address lookup table.
#define AQ_MEMORY_TX_PAGE_TABLE_BASE_ADDRESS                               31:12
#define AQ_MEMORY_TX_PAGE_TABLE_BASE_ADDRESS_End                              31
#define AQ_MEMORY_TX_PAGE_TABLE_BASE_ADDRESS_Start                            12

// Register AQMemoryPePageTable.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQMemoryPePageTableRegAddrs                                       0x0102
#define AQ_MEMORY_PE_PAGE_TABLE_Address                                  0x00408
#define AQ_MEMORY_PE_PAGE_TABLE_MSB                                           15
#define AQ_MEMORY_PE_PAGE_TABLE_LSB                                            0
#define AQ_MEMORY_PE_PAGE_TABLE_Count                                          1
#define AQ_MEMORY_PE_PAGE_TABLE_FieldMask                             0xFFFFF000
#define AQ_MEMORY_PE_PAGE_TABLE_ReadMask                              0xFFFFF000
#define AQ_MEMORY_PE_PAGE_TABLE_WriteMask                             0xFFFFF000
#define AQ_MEMORY_PE_PAGE_TABLE_ResetValue                            0x00000000

// Base address for color buffer virtual address lookup table.
#define AQ_MEMORY_PE_PAGE_TABLE_BASE_ADDRESS                               31:12
#define AQ_MEMORY_PE_PAGE_TABLE_BASE_ADDRESS_End                              31
#define AQ_MEMORY_PE_PAGE_TABLE_BASE_ADDRESS_Start                            12

// Register AQMemoryPezPageTable.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQMemoryPezPageTableRegAddrs                                      0x0103
#define AQ_MEMORY_PEZ_PAGE_TABLE_Address                                 0x0040C
#define AQ_MEMORY_PEZ_PAGE_TABLE_MSB                                          15
#define AQ_MEMORY_PEZ_PAGE_TABLE_LSB                                           0
#define AQ_MEMORY_PEZ_PAGE_TABLE_Count                                         1
#define AQ_MEMORY_PEZ_PAGE_TABLE_FieldMask                            0xFFFFF000
#define AQ_MEMORY_PEZ_PAGE_TABLE_ReadMask                             0xFFFFF000
#define AQ_MEMORY_PEZ_PAGE_TABLE_WriteMask                            0xFFFFF000
#define AQ_MEMORY_PEZ_PAGE_TABLE_ResetValue                           0x00000000

// Base address for depth buffer virtual address lookup table.
#define AQ_MEMORY_PEZ_PAGE_TABLE_BASE_ADDRESS                              31:12
#define AQ_MEMORY_PEZ_PAGE_TABLE_BASE_ADDRESS_End                             31
#define AQ_MEMORY_PEZ_PAGE_TABLE_BASE_ADDRESS_Start                           12

// Register AQMemoryRaPageTable.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQMemoryRaPageTableRegAddrs                                       0x0104
#define AQ_MEMORY_RA_PAGE_TABLE_Address                                  0x00410
#define AQ_MEMORY_RA_PAGE_TABLE_MSB                                           15
#define AQ_MEMORY_RA_PAGE_TABLE_LSB                                            0
#define AQ_MEMORY_RA_PAGE_TABLE_Count                                          1
#define AQ_MEMORY_RA_PAGE_TABLE_FieldMask                             0xFFFFF000
#define AQ_MEMORY_RA_PAGE_TABLE_ReadMask                              0xFFFFF000
#define AQ_MEMORY_RA_PAGE_TABLE_WriteMask                             0xFFFFF000
#define AQ_MEMORY_RA_PAGE_TABLE_ResetValue                            0x00000000

// Base address for early-z virtual address lookup table.
#define AQ_MEMORY_RA_PAGE_TABLE_BASE_ADDRESS                               31:12
#define AQ_MEMORY_RA_PAGE_TABLE_BASE_ADDRESS_End                              31
#define AQ_MEMORY_RA_PAGE_TABLE_BASE_ADDRESS_Start                            12

// Register AQMemoryDebug.
// ~~~~~~~~~~~~~~~~~~~~~~
#define AQMemoryDebugRegAddrs                                             0x0105
#define AQ_MEMORY_DEBUG_Address                                          0x00414
#define AQ_MEMORY_DEBUG_MSB                                                   15
#define AQ_MEMORY_DEBUG_LSB                                                    0
#define AQ_MEMORY_DEBUG_Count                                                  1
#define AQ_MEMORY_DEBUG_FieldMask                                     0x00F800FF
#define AQ_MEMORY_DEBUG_ReadMask                                      0x00F800FF
#define AQ_MEMORY_DEBUG_WriteMask                                     0x00F800FF
#define AQ_MEMORY_DEBUG_ResetValue                                    0x00000000

// Limits the total number of outstanding read requests.
// 0 -> no limit.
#define AQ_MEMORY_DEBUG_MAX_OUTSTANDING_READS                                7:0
#define AQ_MEMORY_DEBUG_MAX_OUTSTANDING_READS_End                              7
#define AQ_MEMORY_DEBUG_MAX_OUTSTANDING_READS_Start                            0

// There is an option to limit outstanding read requests vs. limit 
// the requested data in terms of multiples of 64 bits.
#define AQ_MEMORY_DEBUG_LIMIT_CONTROL                                      19:19
#define AQ_MEMORY_DEBUG_LIMIT_CONTROL_End                                     19
#define AQ_MEMORY_DEBUG_LIMIT_CONTROL_Start                                   19
#define   AQ_MEMORY_DEBUG_LIMIT_CONTROL_REQUESTS                             0x0
#define   AQ_MEMORY_DEBUG_LIMIT_CONTROL_DATA                                 0x1

// Reserved.
#define AQ_MEMORY_DEBUG_DISABLE_FAST_CLEAR                                 20:20
#define AQ_MEMORY_DEBUG_DISABLE_FAST_CLEAR_End                                20
#define AQ_MEMORY_DEBUG_DISABLE_FAST_CLEAR_Start                              20

// Reserved.
#define AQ_MEMORY_DEBUG_DISABLE_ZCOMPRESSION                               21:21
#define AQ_MEMORY_DEBUG_DISABLE_ZCOMPRESSION_End                              21
#define AQ_MEMORY_DEBUG_DISABLE_ZCOMPRESSION_Start                            21

// If you can stall AXI bus then you should not stall reads from each client.
#define AQ_MEMORY_DEBUG_DISABLE_STALL_READS                                22:22
#define AQ_MEMORY_DEBUG_DISABLE_STALL_READS_End                               22
#define AQ_MEMORY_DEBUG_DISABLE_STALL_READS_Start                             22

// Disables the optimization for letting the write data go in parallel to the 
// requests in FC logic.
#define AQ_MEMORY_DEBUG_DISABLE_WRITE_DATA_SPEEDUP                         23:23
#define AQ_MEMORY_DEBUG_DISABLE_WRITE_DATA_SPEEDUP_End                        23
#define AQ_MEMORY_DEBUG_DISABLE_WRITE_DATA_SPEEDUP_Start                      23

// Register AQMemoryRa.
// ~~~~~~~~~~~~~~~~~~~
#define AQMemoryRaRegAddrs                                                0x0106
#define AQ_MEMORY_RA_Address                                             0x00418
#define AQ_MEMORY_RA_MSB                                                      15
#define AQ_MEMORY_RA_LSB                                                       0
#define AQ_MEMORY_RA_Count                                                     1
#define AQ_MEMORY_RA_FieldMask                                        0xFFFFFFFF
#define AQ_MEMORY_RA_ReadMask                                         0xFFFFFFFF
#define AQ_MEMORY_RA_WriteMask                                        0xFFFFFFFF
#define AQ_MEMORY_RA_ResetValue                                       0x00000000

// Base address for all RA memory requests (all addresses
// are added with this before going out of the chip)
#define AQ_MEMORY_RA_BASE_ADDRESS                                           31:0
#define AQ_MEMORY_RA_BASE_ADDRESS_End                                         31
#define AQ_MEMORY_RA_BASE_ADDRESS_Start                                        0

// Register AQMemoryFe.
// ~~~~~~~~~~~~~~~~~~~
#define AQMemoryFeRegAddrs                                                0x0107
#define AQ_MEMORY_FE_Address                                             0x0041C
#define AQ_MEMORY_FE_MSB                                                      15
#define AQ_MEMORY_FE_LSB                                                       0
#define AQ_MEMORY_FE_Count                                                     1
#define AQ_MEMORY_FE_FieldMask                                        0xFFFFFFFF
#define AQ_MEMORY_FE_ReadMask                                         0xFFFFFFFF
#define AQ_MEMORY_FE_WriteMask                                        0xFFFFFFFF
#define AQ_MEMORY_FE_ResetValue                                       0x00000000

// Base address for all FE memory requests (all addresses
// are added with this before going out of the chip)
#define AQ_MEMORY_FE_BASE_ADDRESS                                           31:0
#define AQ_MEMORY_FE_BASE_ADDRESS_End                                         31
#define AQ_MEMORY_FE_BASE_ADDRESS_Start                                        0

// Register AQMemoryTx.
// ~~~~~~~~~~~~~~~~~~~
#define AQMemoryTxRegAddrs                                                0x0108
#define AQ_MEMORY_TX_Address                                             0x00420
#define AQ_MEMORY_TX_MSB                                                      15
#define AQ_MEMORY_TX_LSB                                                       0
#define AQ_MEMORY_TX_Count                                                     1
#define AQ_MEMORY_TX_FieldMask                                        0xFFFFFFFF
#define AQ_MEMORY_TX_ReadMask                                         0xFFFFFFFF
#define AQ_MEMORY_TX_WriteMask                                        0xFFFFFFFF
#define AQ_MEMORY_TX_ResetValue                                       0x00000000

// Base address for all TX memory requests (all addresses
// are added with this before going out of the chip)
#define AQ_MEMORY_TX_BASE_ADDRESS                                           31:0
#define AQ_MEMORY_TX_BASE_ADDRESS_End                                         31
#define AQ_MEMORY_TX_BASE_ADDRESS_Start                                        0

// Register AQMemoryPez.
// ~~~~~~~~~~~~~~~~~~~~
#define AQMemoryPezRegAddrs                                               0x0109
#define AQ_MEMORY_PEZ_Address                                            0x00424
#define AQ_MEMORY_PEZ_MSB                                                     15
#define AQ_MEMORY_PEZ_LSB                                                      0
#define AQ_MEMORY_PEZ_Count                                                    1
#define AQ_MEMORY_PEZ_FieldMask                                       0xFFFFFFFF
#define AQ_MEMORY_PEZ_ReadMask                                        0xFFFFFFFF
#define AQ_MEMORY_PEZ_WriteMask                                       0xFFFFFFFF
#define AQ_MEMORY_PEZ_ResetValue                                      0x00000000

// Base address for all PE-Depth memory requests (all addresses
// are added with this before going out of the chip)
#define AQ_MEMORY_PEZ_BASE_ADDRESS                                          31:0
#define AQ_MEMORY_PEZ_BASE_ADDRESS_End                                        31
#define AQ_MEMORY_PEZ_BASE_ADDRESS_Start                                       0

// Register AQMemoryPec.
// ~~~~~~~~~~~~~~~~~~~~
#define AQMemoryPecRegAddrs                                               0x010A
#define AQ_MEMORY_PEC_Address                                            0x00428
#define AQ_MEMORY_PEC_MSB                                                     15
#define AQ_MEMORY_PEC_LSB                                                      0
#define AQ_MEMORY_PEC_Count                                                    1
#define AQ_MEMORY_PEC_FieldMask                                       0xFFFFFFFF
#define AQ_MEMORY_PEC_ReadMask                                        0xFFFFFFFF
#define AQ_MEMORY_PEC_WriteMask                                       0xFFFFFFFF
#define AQ_MEMORY_PEC_ResetValue                                      0x00000000

// Base address for all PE-Color memory requests (all addresses
// are added with this before going out of the chip)
#define AQ_MEMORY_PEC_BASE_ADDRESS                                          31:0
#define AQ_MEMORY_PEC_BASE_ADDRESS_End                                        31
#define AQ_MEMORY_PEC_BASE_ADDRESS_Start                                       0

// Register AQRegisterTimingControl.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQRegisterTimingControlRegAddrs                                   0x010B
#define AQ_REGISTER_TIMING_CONTROL_Address                               0x0042C
#define AQ_REGISTER_TIMING_CONTROL_MSB                                        15
#define AQ_REGISTER_TIMING_CONTROL_LSB                                         0
#define AQ_REGISTER_TIMING_CONTROL_Count                                       1
#define AQ_REGISTER_TIMING_CONTROL_FieldMask                          0x001FFFFF
#define AQ_REGISTER_TIMING_CONTROL_ReadMask                           0x001FFFFF
#define AQ_REGISTER_TIMING_CONTROL_WriteMask                          0x001FFFFF
#define AQ_REGISTER_TIMING_CONTROL_ResetValue                         0x00000000

// Bit 20: Powerdown memory.
#define AQ_REGISTER_TIMING_CONTROL_CONFIG                                   20:0
#define AQ_REGISTER_TIMING_CONTROL_CONFIG_End                                 20
#define AQ_REGISTER_TIMING_CONTROL_CONFIG_Start                                0

// Register gcMemoryFlush.
// ~~~~~~~~~~~~~~~~~~~~~~

// Flush the different caches inside the memory controller.

#define gcMemoryFlushRegAddrs                                             0x010C
#define GC_MEMORY_FLUSH_Address                                          0x00430
#define GC_MEMORY_FLUSH_MSB                                                   15
#define GC_MEMORY_FLUSH_LSB                                                    0
#define GC_MEMORY_FLUSH_Count                                                  1
#define GC_MEMORY_FLUSH_FieldMask                                     0x00000001
#define GC_MEMORY_FLUSH_ReadMask                                      0x00000001
#define GC_MEMORY_FLUSH_WriteMask                                     0x00000001
#define GC_MEMORY_FLUSH_ResetValue                                    0x00000000

// Flush the page table cache.
#define GC_MEMORY_FLUSH_PAGE_TABLE                                           0:0
#define GC_MEMORY_FLUSH_PAGE_TABLE_End                                         0
#define GC_MEMORY_FLUSH_PAGE_TABLE_Start                                       0
#define   GC_MEMORY_FLUSH_PAGE_TABLE_DISABLE                                 0x0
#define   GC_MEMORY_FLUSH_PAGE_TABLE_ENABLE                                  0x1

// Register gcDisplayPriority.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~

// Controls the priority of the display controller requests.
// This works like a PWM. One register gives the period, and the other
// gives the ON time. When PWM is ON, display requests are accepted if both display
// and the other request is valid. If it is OFF, the other request will be accepted.
// If only one request is valid, it takes the bus regardless of the PWM bit.

#define gcDisplayPriorityRegAddrs                                         0x010D
#define GC_DISPLAY_PRIORITY_Address                                      0x00434
#define GC_DISPLAY_PRIORITY_MSB                                               15
#define GC_DISPLAY_PRIORITY_LSB                                                0
#define GC_DISPLAY_PRIORITY_Count                                              1
#define GC_DISPLAY_PRIORITY_FieldMask                                 0x0000FFFF
#define GC_DISPLAY_PRIORITY_ReadMask                                  0x0000FFFF
#define GC_DISPLAY_PRIORITY_WriteMask                                 0x0000FFFF
#define GC_DISPLAY_PRIORITY_ResetValue                                0x00000102

#define GC_DISPLAY_PRIORITY_PERIOD                                           7:0
#define GC_DISPLAY_PRIORITY_PERIOD_End                                         7
#define GC_DISPLAY_PRIORITY_PERIOD_Start                                       0

#define GC_DISPLAY_PRIORITY_HIGH                                            15:8
#define GC_DISPLAY_PRIORITY_HIGH_End                                          15
#define GC_DISPLAY_PRIORITY_HIGH_Start                                         8

// Register gcDbgCycleCounter.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~

// Increments every cycle.

#define gcDbgCycleCounterRegAddrs                                         0x010E
#define GC_DBG_CYCLE_COUNTER_Address                                     0x00438
#define GC_DBG_CYCLE_COUNTER_MSB                                              15
#define GC_DBG_CYCLE_COUNTER_LSB                                               0
#define GC_DBG_CYCLE_COUNTER_Count                                             1
#define GC_DBG_CYCLE_COUNTER_FieldMask                                0xFFFFFFFF
#define GC_DBG_CYCLE_COUNTER_ReadMask                                 0xFFFFFFFF
#define GC_DBG_CYCLE_COUNTER_WriteMask                                0xFFFFFFFF
#define GC_DBG_CYCLE_COUNTER_ResetValue                               0x00000000

#define GC_DBG_CYCLE_COUNTER_COUNT                                          31:0
#define GC_DBG_CYCLE_COUNTER_COUNT_End                                        31
#define GC_DBG_CYCLE_COUNTER_COUNT_Start                                       0

// Register gcOutstandingReads0.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Number of outstanding reads per client in multiples of 8B.

#define gcOutstandingReads0RegAddrs                                       0x010F
#define GC_OUTSTANDING_READS0_Address                                    0x0043C
#define GC_OUTSTANDING_READS0_MSB                                             15
#define GC_OUTSTANDING_READS0_LSB                                              0
#define GC_OUTSTANDING_READS0_Count                                            1
#define GC_OUTSTANDING_READS0_FieldMask                               0xFFFFFFFF
#define GC_OUTSTANDING_READS0_ReadMask                                0xFFFFFFFF
#define GC_OUTSTANDING_READS0_WriteMask                               0x00000000
#define GC_OUTSTANDING_READS0_ResetValue                              0x00000000

#define GC_OUTSTANDING_READS0_PEC                                            7:0
#define GC_OUTSTANDING_READS0_PEC_End                                          7
#define GC_OUTSTANDING_READS0_PEC_Start                                        0

#define GC_OUTSTANDING_READS0_PEZ                                           15:8
#define GC_OUTSTANDING_READS0_PEZ_End                                         15
#define GC_OUTSTANDING_READS0_PEZ_Start                                        8

#define GC_OUTSTANDING_READS0_FE                                           23:16
#define GC_OUTSTANDING_READS0_FE_End                                          23
#define GC_OUTSTANDING_READS0_FE_Start                                        16

#define GC_OUTSTANDING_READS0_MMU                                          31:24
#define GC_OUTSTANDING_READS0_MMU_End                                         31
#define GC_OUTSTANDING_READS0_MMU_Start                                       24

// Register gcOutstandingReads1.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Number of outstanding reads per client in multiples of 8B.

#define gcOutstandingReads1RegAddrs                                       0x0110
#define GC_OUTSTANDING_READS1_Address                                    0x00440
#define GC_OUTSTANDING_READS1_MSB                                             15
#define GC_OUTSTANDING_READS1_LSB                                              0
#define GC_OUTSTANDING_READS1_Count                                            1
#define GC_OUTSTANDING_READS1_FieldMask                               0xFFFFFFFF
#define GC_OUTSTANDING_READS1_ReadMask                                0xFFFFFFFF
#define GC_OUTSTANDING_READS1_WriteMask                               0x00000000
#define GC_OUTSTANDING_READS1_ResetValue                              0x00000000

#define GC_OUTSTANDING_READS1_RA                                             7:0
#define GC_OUTSTANDING_READS1_RA_End                                           7
#define GC_OUTSTANDING_READS1_RA_Start                                         0

#define GC_OUTSTANDING_READS1_TX                                            15:8
#define GC_OUTSTANDING_READS1_TX_End                                          15
#define GC_OUTSTANDING_READS1_TX_Start                                         8

#define GC_OUTSTANDING_READS1_FC                                           23:16
#define GC_OUTSTANDING_READS1_FC_End                                          23
#define GC_OUTSTANDING_READS1_FC_Start                                        16

// This field keeps the value of total read requests or total requested 
// data (in 64bits) depending on the value of LimitControl field in 
// AQMemoryDebug register.
#define GC_OUTSTANDING_READS1_TOTAL                                        31:24
#define GC_OUTSTANDING_READS1_TOTAL_End                                       31
#define GC_OUTSTANDING_READS1_TOTAL_Start                                     24

// Register gcOutstandingWrites.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Number of outstanding writes per client.

#define gcOutstandingWritesRegAddrs                                       0x0111
#define GC_OUTSTANDING_WRITES_Address                                    0x00444
#define GC_OUTSTANDING_WRITES_MSB                                             15
#define GC_OUTSTANDING_WRITES_LSB                                              0
#define GC_OUTSTANDING_WRITES_Count                                            1
#define GC_OUTSTANDING_WRITES_FieldMask                               0x00FFFFFF
#define GC_OUTSTANDING_WRITES_ReadMask                                0x00FFFFFF
#define GC_OUTSTANDING_WRITES_WriteMask                               0x00000000
#define GC_OUTSTANDING_WRITES_ResetValue                              0x00000000

#define GC_OUTSTANDING_WRITES_PEC                                            7:0
#define GC_OUTSTANDING_WRITES_PEC_End                                          7
#define GC_OUTSTANDING_WRITES_PEC_Start                                        0

#define GC_OUTSTANDING_WRITES_PEZ                                           15:8
#define GC_OUTSTANDING_WRITES_PEZ_End                                         15
#define GC_OUTSTANDING_WRITES_PEZ_Start                                        8

#define GC_OUTSTANDING_WRITES_FC                                           23:16
#define GC_OUTSTANDING_WRITES_FC_End                                          23
#define GC_OUTSTANDING_WRITES_FC_Start                                        16

// Register gcDebugSignalsRa.
// ~~~~~~~~~~~~~~~~~~~~~~~~~

// 32 bit debug signal from Ra.

#define gcDebugSignalsRaRegAddrs                                          0x0112
#define GC_DEBUG_SIGNALS_RA_Address                                      0x00448
#define GC_DEBUG_SIGNALS_RA_MSB                                               15
#define GC_DEBUG_SIGNALS_RA_LSB                                                0
#define GC_DEBUG_SIGNALS_RA_Count                                              1
#define GC_DEBUG_SIGNALS_RA_FieldMask                                 0xFFFFFFFF
#define GC_DEBUG_SIGNALS_RA_ReadMask                                  0xFFFFFFFF
#define GC_DEBUG_SIGNALS_RA_WriteMask                                 0x00000000
#define GC_DEBUG_SIGNALS_RA_ResetValue                                0x00000000

// Signals according to select signal:
// 0 -> Valid pixel count.
// 1 -> Total quad count.
// 2 -> Valid quad count (after early-z).
// 3 -> Total primitive count.
// 4 -> Various signals from input stage. See RTL for details.
// 5 -> Various signals from input stage. See RTL for details.
// 6 -> Various signals from render pipe. See RTL for details.
// 7 -> Various signals from render cache. See RTL for details.
// 8 -> Various signals from raster engine. See RTL for details.
// 9 -> Cache miss count (in the pipeline).
// A -> Cache miss count (in the prefetcher).
// F -> Signature = 0x12344321.
#define GC_DEBUG_SIGNALS_RA_SIGNAL                                          31:0
#define GC_DEBUG_SIGNALS_RA_SIGNAL_End                                        31
#define GC_DEBUG_SIGNALS_RA_SIGNAL_Start                                       0

// Register gcDebugSignalsTx.
// ~~~~~~~~~~~~~~~~~~~~~~~~~

// 32 bit debug signal from Tx.

#define gcDebugSignalsTxRegAddrs                                          0x0113
#define GC_DEBUG_SIGNALS_TX_Address                                      0x0044C
#define GC_DEBUG_SIGNALS_TX_MSB                                               15
#define GC_DEBUG_SIGNALS_TX_LSB                                                0
#define GC_DEBUG_SIGNALS_TX_Count                                              1
#define GC_DEBUG_SIGNALS_TX_FieldMask                                 0xFFFFFFFF
#define GC_DEBUG_SIGNALS_TX_ReadMask                                  0xFFFFFFFF
#define GC_DEBUG_SIGNALS_TX_WriteMask                                 0x00000000
#define GC_DEBUG_SIGNALS_TX_ResetValue                                0x00000000

// Signals according to select signal:
// 0 -> Total bilinear texture requests.
// 1 -> Total trilinear texture requests.
// 2 -> Total texture requests.
// 3 -> Total discarded texture requests.
// 4 -> Various signals from input stage. See RTL for details.
// 5 -> Memory read count.
// 6 -> Memory read count in 8B.
// 7 -> Cache miss count (in the pipeline).
// 8 -> Total hitting texels (in pre-fetcher).
// 9 -> Total missing texels (in pre-fetcher).
// F -> Signature = 0x12211221.
#define GC_DEBUG_SIGNALS_TX_SIGNAL                                          31:0
#define GC_DEBUG_SIGNALS_TX_SIGNAL_End                                        31
#define GC_DEBUG_SIGNALS_TX_SIGNAL_Start                                       0

// Register gcDebugSignalsFe.
// ~~~~~~~~~~~~~~~~~~~~~~~~~

// 32 bit debug signal from Fe.

#define gcDebugSignalsFeRegAddrs                                          0x0114
#define GC_DEBUG_SIGNALS_FE_Address                                      0x00450
#define GC_DEBUG_SIGNALS_FE_MSB                                               15
#define GC_DEBUG_SIGNALS_FE_LSB                                                0
#define GC_DEBUG_SIGNALS_FE_Count                                              1
#define GC_DEBUG_SIGNALS_FE_FieldMask                                 0xFFFFFFFF
#define GC_DEBUG_SIGNALS_FE_ReadMask                                  0xFFFFFFFF
#define GC_DEBUG_SIGNALS_FE_WriteMask                                 0x00000000
#define GC_DEBUG_SIGNALS_FE_ResetValue                                0x00000000

#define GC_DEBUG_SIGNALS_FE_SIGNAL                                          31:0
#define GC_DEBUG_SIGNALS_FE_SIGNAL_End                                        31
#define GC_DEBUG_SIGNALS_FE_SIGNAL_Start                                       0

// Register gcDebugSignalsPe.
// ~~~~~~~~~~~~~~~~~~~~~~~~~

// 32 bit debug signal from Pe.

#define gcDebugSignalsPeRegAddrs                                          0x0115
#define GC_DEBUG_SIGNALS_PE_Address                                      0x00454
#define GC_DEBUG_SIGNALS_PE_MSB                                               15
#define GC_DEBUG_SIGNALS_PE_LSB                                                0
#define GC_DEBUG_SIGNALS_PE_Count                                              1
#define GC_DEBUG_SIGNALS_PE_FieldMask                                 0xFFFFFFFF
#define GC_DEBUG_SIGNALS_PE_ReadMask                                  0xFFFFFFFF
#define GC_DEBUG_SIGNALS_PE_WriteMask                                 0x00000000
#define GC_DEBUG_SIGNALS_PE_ResetValue                                0x00000000

// Signals according to select signal:
// 0 -> pixel count killed by color pipe
// 1 -> pixel count killed by depth pipe
// 2 -> pixel count drawn by color pipe
// 3 -> pixel count drawn by depth pipe
// 4 -> debug signals for 3d_io, 2d_filter, 2d_fsm
// 5 -> debug signals for cache2d_cntrl
// 6 -> debug signals for cache2d_tag_alloc
// 7 -> debug signals for cache3d_c_cntrl, cache3d_c_tag_alloc
// 8 -> debug signals for cache3d_z_cntrl, cache3d_z_tag_alloc
// 9 -> debug signals for pref_2d, pref_3d
// a -> debug signals for cmd_state
// F -> Signature = 0xbabef00d.
#define GC_DEBUG_SIGNALS_PE_SIGNAL                                          31:0
#define GC_DEBUG_SIGNALS_PE_SIGNAL_End                                        31
#define GC_DEBUG_SIGNALS_PE_SIGNAL_Start                                       0

// Register gcDebugSignalsDe.
// ~~~~~~~~~~~~~~~~~~~~~~~~~

// 32 bit debug signal from De.

#define gcDebugSignalsDeRegAddrs                                          0x0116
#define GC_DEBUG_SIGNALS_DE_Address                                      0x00458
#define GC_DEBUG_SIGNALS_DE_MSB                                               15
#define GC_DEBUG_SIGNALS_DE_LSB                                                0
#define GC_DEBUG_SIGNALS_DE_Count                                              1
#define GC_DEBUG_SIGNALS_DE_FieldMask                                 0xFFFFFFFF
#define GC_DEBUG_SIGNALS_DE_ReadMask                                  0xFFFFFFFF
#define GC_DEBUG_SIGNALS_DE_WriteMask                                 0x00000000
#define GC_DEBUG_SIGNALS_DE_ResetValue                                0x00000000

#define GC_DEBUG_SIGNALS_DE_SIGNAL                                          31:0
#define GC_DEBUG_SIGNALS_DE_SIGNAL_End                                        31
#define GC_DEBUG_SIGNALS_DE_SIGNAL_Start                                       0

// Register gcDebugSignalsSh.
// ~~~~~~~~~~~~~~~~~~~~~~~~~

// 32 bit debug signal from Sh.

#define gcDebugSignalsShRegAddrs                                          0x0117
#define GC_DEBUG_SIGNALS_SH_Address                                      0x0045C
#define GC_DEBUG_SIGNALS_SH_MSB                                               15
#define GC_DEBUG_SIGNALS_SH_LSB                                                0
#define GC_DEBUG_SIGNALS_SH_Count                                              1
#define GC_DEBUG_SIGNALS_SH_FieldMask                                 0xFFFFFFFF
#define GC_DEBUG_SIGNALS_SH_ReadMask                                  0xFFFFFFFF
#define GC_DEBUG_SIGNALS_SH_WriteMask                                 0x00000000
#define GC_DEBUG_SIGNALS_SH_ResetValue                                0x00000000

#define GC_DEBUG_SIGNALS_SH_SIGNAL                                          31:0
#define GC_DEBUG_SIGNALS_SH_SIGNAL_End                                        31
#define GC_DEBUG_SIGNALS_SH_SIGNAL_Start                                       0

// Register gcDebugSignalsPa.
// ~~~~~~~~~~~~~~~~~~~~~~~~~

// 32 bit debug signal from Pa.

#define gcDebugSignalsPaRegAddrs                                          0x0118
#define GC_DEBUG_SIGNALS_PA_Address                                      0x00460
#define GC_DEBUG_SIGNALS_PA_MSB                                               15
#define GC_DEBUG_SIGNALS_PA_LSB                                                0
#define GC_DEBUG_SIGNALS_PA_Count                                              1
#define GC_DEBUG_SIGNALS_PA_FieldMask                                 0xFFFFFFFF
#define GC_DEBUG_SIGNALS_PA_ReadMask                                  0xFFFFFFFF
#define GC_DEBUG_SIGNALS_PA_WriteMask                                 0x00000000
#define GC_DEBUG_SIGNALS_PA_ResetValue                                0x00000000

#define GC_DEBUG_SIGNALS_PA_SIGNAL                                          31:0
#define GC_DEBUG_SIGNALS_PA_SIGNAL_End                                        31
#define GC_DEBUG_SIGNALS_PA_SIGNAL_Start                                       0

// Register gcDebugSignalsSe.
// ~~~~~~~~~~~~~~~~~~~~~~~~~

// 32 bit debug signal from Se.

#define gcDebugSignalsSeRegAddrs                                          0x0119
#define GC_DEBUG_SIGNALS_SE_Address                                      0x00464
#define GC_DEBUG_SIGNALS_SE_MSB                                               15
#define GC_DEBUG_SIGNALS_SE_LSB                                                0
#define GC_DEBUG_SIGNALS_SE_Count                                              1
#define GC_DEBUG_SIGNALS_SE_FieldMask                                 0xFFFFFFFF
#define GC_DEBUG_SIGNALS_SE_ReadMask                                  0xFFFFFFFF
#define GC_DEBUG_SIGNALS_SE_WriteMask                                 0x00000000
#define GC_DEBUG_SIGNALS_SE_ResetValue                                0x00000000

// Signals according to select signal:
// 0 -> culled triangles count.
// 1 -> culled lines count.
// 2 -> [31:18] goto signals, [17:8] main state machine state, [7:0] output state machine state. See RTL for details.
// 3 -> [31:22] unused, [21] early_isTriangle, [20] isTriangle, [19] increment_pc_e0, [18:14] jump_to_signals. See RTL for details.
//      [13:12] max_x_p_e2, [11:10] mid_x_p_e2, [9:8] min_x_p_e2, [7:6] max_y_p_e2, [5:4] mid_y_p_e2. See RTL for details.
//      [3:2] min_y_p_e2, [1:0] min_z_p_e2. See RTL for details.
// 4 -> area_e2. See RTL for details.
// 5 -> x0_e2.   See RTL for details.
// 6 -> x1_e2.   See RTL for details.
// 7 -> x2_e2.   See RTL for details.
// 8 -> y0_e2.   See RTL for details.
// 9 -> y1_e2.   See RTL for details.
// A -> y2_e2.   See RTL for details.
// B -> init_y_e2. See RTL for details.
// C -> init_y_e2. See RTL for details.
// D -> y2_e2.   See RTL for details.
// E -> y2_e2.   See RTL for details.
// F -> Signature = 0x5E5E5E5E.
#define GC_DEBUG_SIGNALS_SE_SIGNAL                                          31:0
#define GC_DEBUG_SIGNALS_SE_SIGNAL_End                                        31
#define GC_DEBUG_SIGNALS_SE_SIGNAL_Start                                       0

// Register gcDebugSignalsMc.
// ~~~~~~~~~~~~~~~~~~~~~~~~~

// 32 bit debug signal from Mc.

#define gcDebugSignalsMcRegAddrs                                          0x011A
#define GC_DEBUG_SIGNALS_MC_Address                                      0x00468
#define GC_DEBUG_SIGNALS_MC_MSB                                               15
#define GC_DEBUG_SIGNALS_MC_LSB                                                0
#define GC_DEBUG_SIGNALS_MC_Count                                              1
#define GC_DEBUG_SIGNALS_MC_FieldMask                                 0xFFFFFFFF
#define GC_DEBUG_SIGNALS_MC_ReadMask                                  0xFFFFFFFF
#define GC_DEBUG_SIGNALS_MC_WriteMask                                 0x00000000
#define GC_DEBUG_SIGNALS_MC_ResetValue                                0x00000000

// Signals according to select signal:
// 0 -> Various signals from FC block. See RTL for details.
// 1 -> Total read req in terms of 8B from pipeline.
// 2 -> Total read req in terms of 8B sent out from the IP.
// 3 -> Total write req in terms of 8B from pipeline.
// F -> Signature = 0x12345678.
#define GC_DEBUG_SIGNALS_MC_SIGNAL                                          31:0
#define GC_DEBUG_SIGNALS_MC_SIGNAL_End                                        31
#define GC_DEBUG_SIGNALS_MC_SIGNAL_Start                                       0

// Register gcDebugSignalsHi.
// ~~~~~~~~~~~~~~~~~~~~~~~~~

// 32 bit debug signal from Hi.

#define gcDebugSignalsHiRegAddrs                                          0x011B
#define GC_DEBUG_SIGNALS_HI_Address                                      0x0046C
#define GC_DEBUG_SIGNALS_HI_MSB                                               15
#define GC_DEBUG_SIGNALS_HI_LSB                                                0
#define GC_DEBUG_SIGNALS_HI_Count                                              1
#define GC_DEBUG_SIGNALS_HI_FieldMask                                 0xFFFFFFFF
#define GC_DEBUG_SIGNALS_HI_ReadMask                                  0xFFFFFFFF
#define GC_DEBUG_SIGNALS_HI_WriteMask                                 0x00000000
#define GC_DEBUG_SIGNALS_HI_ResetValue                                0x00000000

// Signals according to select signal:
// 0 -> Number of cycles AXI read request is stalled.
// 1 -> Number of cycles AXI write request is stalled.
// 2 -> Number of cycles AXI write data is stalled.
// F -> Signature = 0xaaaaaaaa.
#define GC_DEBUG_SIGNALS_HI_SIGNAL                                          31:0
#define GC_DEBUG_SIGNALS_HI_SIGNAL_End                                        31
#define GC_DEBUG_SIGNALS_HI_SIGNAL_Start                                       0

// Register gcDebugControl0.
// ~~~~~~~~~~~~~~~~~~~~~~~~
#define gcDebugControl0RegAddrs                                           0x011C
#define GC_DEBUG_CONTROL0_Address                                        0x00470
#define GC_DEBUG_CONTROL0_MSB                                                 15
#define GC_DEBUG_CONTROL0_LSB                                                  0
#define GC_DEBUG_CONTROL0_Count                                                1
#define GC_DEBUG_CONTROL0_FieldMask                                   0x0F0F0F0F
#define GC_DEBUG_CONTROL0_ReadMask                                    0x0F0F0F0F
#define GC_DEBUG_CONTROL0_WriteMask                                   0x0F0F0F0F
#define GC_DEBUG_CONTROL0_ResetValue                                  0x00000000

// Selects which set of 32 bit data to get from Fe.
// Resets the counters if set to 0xf.
#define GC_DEBUG_CONTROL0_FE                                                 3:0
#define GC_DEBUG_CONTROL0_FE_End                                               3
#define GC_DEBUG_CONTROL0_FE_Start                                             0

// Selects which set of 32 bit data to get from De.
// Resets the counters if set to 0xf.
#define GC_DEBUG_CONTROL0_DE                                                11:8
#define GC_DEBUG_CONTROL0_DE_End                                              11
#define GC_DEBUG_CONTROL0_DE_Start                                             8

// Selects which set of 32 bit data to get from Pe.
// Resets the counters if set to 0xf.
#define GC_DEBUG_CONTROL0_PE                                               19:16
#define GC_DEBUG_CONTROL0_PE_End                                              19
#define GC_DEBUG_CONTROL0_PE_Start                                            16

// Selects which set of 32 bit data to get from Sh.
// Resets the counters if set to 0xf.
#define GC_DEBUG_CONTROL0_SH                                               27:24
#define GC_DEBUG_CONTROL0_SH_End                                              27
#define GC_DEBUG_CONTROL0_SH_Start                                            24

// Register gcDebugControl1.
// ~~~~~~~~~~~~~~~~~~~~~~~~
#define gcDebugControl1RegAddrs                                           0x011D
#define GC_DEBUG_CONTROL1_Address                                        0x00474
#define GC_DEBUG_CONTROL1_MSB                                                 15
#define GC_DEBUG_CONTROL1_LSB                                                  0
#define GC_DEBUG_CONTROL1_Count                                                1
#define GC_DEBUG_CONTROL1_FieldMask                                   0x0F0F0F0F
#define GC_DEBUG_CONTROL1_ReadMask                                    0x0F0F0F0F
#define GC_DEBUG_CONTROL1_WriteMask                                   0x0F0F0F0F
#define GC_DEBUG_CONTROL1_ResetValue                                  0x00000000

// Selects which set of 32 bit data to get from Pa.
// Resets the counters if set to 0xf.
#define GC_DEBUG_CONTROL1_PA                                                 3:0
#define GC_DEBUG_CONTROL1_PA_End                                               3
#define GC_DEBUG_CONTROL1_PA_Start                                             0

// Selects which set of 32 bit data to get from Se.
// Resets the counters if set to 0xf.
#define GC_DEBUG_CONTROL1_SE                                                11:8
#define GC_DEBUG_CONTROL1_SE_End                                              11
#define GC_DEBUG_CONTROL1_SE_Start                                             8

// Selects which set of 32 bit data to get from Ra.
// Resets the counters if set to 0xf.
#define GC_DEBUG_CONTROL1_RA                                               19:16
#define GC_DEBUG_CONTROL1_RA_End                                              19
#define GC_DEBUG_CONTROL1_RA_Start                                            16

// Selects which set of 32 bit data to get from Tx.
// Resets the counters if set to 0xf.
#define GC_DEBUG_CONTROL1_TX                                               27:24
#define GC_DEBUG_CONTROL1_TX_End                                              27
#define GC_DEBUG_CONTROL1_TX_Start                                            24

// Register gcDebugControl2.
// ~~~~~~~~~~~~~~~~~~~~~~~~
#define gcDebugControl2RegAddrs                                           0x011E
#define GC_DEBUG_CONTROL2_Address                                        0x00478
#define GC_DEBUG_CONTROL2_MSB                                                 15
#define GC_DEBUG_CONTROL2_LSB                                                  0
#define GC_DEBUG_CONTROL2_Count                                                1
#define GC_DEBUG_CONTROL2_FieldMask                                   0x00000F0F
#define GC_DEBUG_CONTROL2_ReadMask                                    0x00000F0F
#define GC_DEBUG_CONTROL2_WriteMask                                   0x00000F0F
#define GC_DEBUG_CONTROL2_ResetValue                                  0x00000000

// Selects which set of 32 bit data to get from Mc.
// Resets the counters if set to 0xf.
#define GC_DEBUG_CONTROL2_MC                                                 3:0
#define GC_DEBUG_CONTROL2_MC_End                                               3
#define GC_DEBUG_CONTROL2_MC_Start                                             0

// Selects which set of 32 bit data to get from Hi.
// Resets the counters if set to 0xf.
#define GC_DEBUG_CONTROL2_HI                                                11:8
#define GC_DEBUG_CONTROL2_HI_End                                              11
#define GC_DEBUG_CONTROL2_HI_Start                                             8

// Register gcDebugControl3.
// ~~~~~~~~~~~~~~~~~~~~~~~~
#define gcDebugControl3RegAddrs                                           0x011F
#define GC_DEBUG_CONTROL3_Address                                        0x0047C
#define GC_DEBUG_CONTROL3_MSB                                                 15
#define GC_DEBUG_CONTROL3_LSB                                                  0
#define GC_DEBUG_CONTROL3_Count                                                1
#define GC_DEBUG_CONTROL3_FieldMask                                   0x00000F0F
#define GC_DEBUG_CONTROL3_ReadMask                                    0x00000F0F
#define GC_DEBUG_CONTROL3_WriteMask                                   0x00000F0F
#define GC_DEBUG_CONTROL3_ResetValue                                  0x00000000

// Selects which module's output will be put in the LSB 32 bits 
// of 64 bit debug signal.
#define GC_DEBUG_CONTROL3_PROBE0                                             3:0
#define GC_DEBUG_CONTROL3_PROBE0_End                                           3
#define GC_DEBUG_CONTROL3_PROBE0_Start                                         0
#define   GC_DEBUG_CONTROL3_PROBE0_FE                                        0x0
#define   GC_DEBUG_CONTROL3_PROBE0_DE                                        0x1
#define   GC_DEBUG_CONTROL3_PROBE0_PE                                        0x2
#define   GC_DEBUG_CONTROL3_PROBE0_SH                                        0x3
#define   GC_DEBUG_CONTROL3_PROBE0_PA                                        0x4
#define   GC_DEBUG_CONTROL3_PROBE0_SE                                        0x5
#define   GC_DEBUG_CONTROL3_PROBE0_RA                                        0x6
#define   GC_DEBUG_CONTROL3_PROBE0_TX                                        0x7
#define   GC_DEBUG_CONTROL3_PROBE0_MC                                        0x8

// Selects which module's output will be put in the MSB 32 bits 
// of 64 bit debug signal.
#define GC_DEBUG_CONTROL3_PROBE1                                            11:8
#define GC_DEBUG_CONTROL3_PROBE1_End                                          11
#define GC_DEBUG_CONTROL3_PROBE1_Start                                         8
#define   GC_DEBUG_CONTROL3_PROBE1_FE                                        0x0
#define   GC_DEBUG_CONTROL3_PROBE1_DE                                        0x1
#define   GC_DEBUG_CONTROL3_PROBE1_PE                                        0x2
#define   GC_DEBUG_CONTROL3_PROBE1_SH                                        0x3
#define   GC_DEBUG_CONTROL3_PROBE1_PA                                        0x4
#define   GC_DEBUG_CONTROL3_PROBE1_SE                                        0x5
#define   GC_DEBUG_CONTROL3_PROBE1_RA                                        0x6
#define   GC_DEBUG_CONTROL3_PROBE1_TX                                        0x7
#define   GC_DEBUG_CONTROL3_PROBE1_MC                                        0x8

// Register gcBusControl.
// ~~~~~~~~~~~~~~~~~~~~~
#define gcBusControlRegAddrs                                              0x0120
#define GC_BUS_CONTROL_Address                                           0x00480
#define GC_BUS_CONTROL_MSB                                                    15
#define GC_BUS_CONTROL_LSB                                                     0
#define GC_BUS_CONTROL_Count                                                   1
#define GC_BUS_CONTROL_FieldMask                                      0x000000FF
#define GC_BUS_CONTROL_ReadMask                                       0x000000FF
#define GC_BUS_CONTROL_WriteMask                                      0x000000FF
#define GC_BUS_CONTROL_ResetValue                                     0x00000088

// Select the return bus for PEC
#define GC_BUS_CONTROL_PEC                                                   0:0
#define GC_BUS_CONTROL_PEC_End                                                 0
#define GC_BUS_CONTROL_PEC_Start                                               0

// Select the return bus for PEZ. Return Bus for PEZ and RA should be the same.
#define GC_BUS_CONTROL_PEZ                                                   1:1
#define GC_BUS_CONTROL_PEZ_End                                                 1
#define GC_BUS_CONTROL_PEZ_Start                                               1

// Select the return bus for DC
#define GC_BUS_CONTROL_DC                                                    2:2
#define GC_BUS_CONTROL_DC_End                                                  2
#define GC_BUS_CONTROL_DC_Start                                                2

// Select the return bus for FE
#define GC_BUS_CONTROL_FE                                                    3:3
#define GC_BUS_CONTROL_FE_End                                                  3
#define GC_BUS_CONTROL_FE_Start                                                3

// Select the return bus for RA. Return Bus for RA and PEZ should be the same.
#define GC_BUS_CONTROL_RA                                                    4:4
#define GC_BUS_CONTROL_RA_End                                                  4
#define GC_BUS_CONTROL_RA_Start                                                4

// Select the return bus for MMU
#define GC_BUS_CONTROL_MMU                                                   5:5
#define GC_BUS_CONTROL_MMU_End                                                 5
#define GC_BUS_CONTROL_MMU_Start                                               5

// Select the return bus for FC
#define GC_BUS_CONTROL_FC                                                    6:6
#define GC_BUS_CONTROL_FC_End                                                  6
#define GC_BUS_CONTROL_FC_Start                                                6

// Select the return bus for TX
#define GC_BUS_CONTROL_TX                                                    7:7
#define GC_BUS_CONTROL_TX_End                                                  7
#define GC_BUS_CONTROL_TX_Start                                                7

// Register gcregEndianness0.
// ~~~~~~~~~~~~~~~~~~~~~~~~~
#define gcregEndianness0RegAddrs                                          0x0121
#define GCREG_ENDIANNESS0_Address                                        0x00484
#define GCREG_ENDIANNESS0_MSB                                                 15
#define GCREG_ENDIANNESS0_LSB                                                  0
#define GCREG_ENDIANNESS0_Count                                                1
#define GCREG_ENDIANNESS0_FieldMask                                   0xFFFFFFFF
#define GCREG_ENDIANNESS0_ReadMask                                    0xFFFFFFFF
#define GCREG_ENDIANNESS0_WriteMask                                   0xFFFFFFFF
#define GCREG_ENDIANNESS0_ResetValue                                  0x00000000

// Flip the words of 32 bit data.
#define GCREG_ENDIANNESS0_WORD_SWAP                                         31:0
#define GCREG_ENDIANNESS0_WORD_SWAP_End                                       31
#define GCREG_ENDIANNESS0_WORD_SWAP_Start                                      0

// Register gcregEndianness1.
// ~~~~~~~~~~~~~~~~~~~~~~~~~
#define gcregEndianness1RegAddrs                                          0x0122
#define GCREG_ENDIANNESS1_Address                                        0x00488
#define GCREG_ENDIANNESS1_MSB                                                 15
#define GCREG_ENDIANNESS1_LSB                                                  0
#define GCREG_ENDIANNESS1_Count                                                1
#define GCREG_ENDIANNESS1_FieldMask                                   0xFFFFFFFF
#define GCREG_ENDIANNESS1_ReadMask                                    0xFFFFFFFF
#define GCREG_ENDIANNESS1_WriteMask                                   0xFFFFFFFF
#define GCREG_ENDIANNESS1_ResetValue                                  0x00000000

// Flip the bytes of 16 bit data.
#define GCREG_ENDIANNESS1_BYTE_SWAP                                         31:0
#define GCREG_ENDIANNESS1_BYTE_SWAP_End                                       31
#define GCREG_ENDIANNESS1_BYTE_SWAP_Start                                      0

// Register gcregEndianness2.
// ~~~~~~~~~~~~~~~~~~~~~~~~~
#define gcregEndianness2RegAddrs                                          0x0123
#define GCREG_ENDIANNESS2_Address                                        0x0048C
#define GCREG_ENDIANNESS2_MSB                                                 15
#define GCREG_ENDIANNESS2_LSB                                                  0
#define GCREG_ENDIANNESS2_Count                                                1
#define GCREG_ENDIANNESS2_FieldMask                                   0xFFFFFFFF
#define GCREG_ENDIANNESS2_ReadMask                                    0xFFFFFFFF
#define GCREG_ENDIANNESS2_WriteMask                                   0xFFFFFFFF
#define GCREG_ENDIANNESS2_ResetValue                                  0x00000000

// Flip the bits of 8 bit data.
#define GCREG_ENDIANNESS2_BIT_SWAP                                          31:0
#define GCREG_ENDIANNESS2_BIT_SWAP_End                                        31
#define GCREG_ENDIANNESS2_BIT_SWAP_Start                                       0

////////////////////////////////////////////////////////////////////////////////
//                              ~~~~~~~~~~~~~~~~                              //
//                              Command AQMemory                              //
//                              ~~~~~~~~~~~~~~~~                              //
////////////////////////////////////////////////////////////////////////////////

// Offset Address.
// ~~~~~~~~~~~~~~

#define AQ_MEMORY_ADDRESS_TYPE                                             31:31
#define AQ_MEMORY_ADDRESS_TYPE_End                                            31
#define AQ_MEMORY_ADDRESS_TYPE_Start                                          31
#define   AQ_MEMORY_ADDRESS_TYPE_SYSTEM                                      0x0
#define   AQ_MEMORY_ADDRESS_TYPE_VIRTUAL_SYSTEM                              0x1

#define AQ_MEMORY_ADDRESS_ADDRESS                                           30:0
#define AQ_MEMORY_ADDRESS_ADDRESS_End                                         30
#define AQ_MEMORY_ADDRESS_ADDRESS_Start                                        0

// Offset PageTableEntry.
// ~~~~~~~~~~~~~~~~~~~~~

#define AQ_MEMORY_PAGE_TABLE_ENTRY_ADDRESS                                 31:10
#define AQ_MEMORY_PAGE_TABLE_ENTRY_ADDRESS_End                                31
#define AQ_MEMORY_PAGE_TABLE_ENTRY_ADDRESS_Start                              10

#define AQ_MEMORY_PAGE_TABLE_ENTRY_LINKED                                    8:8
#define AQ_MEMORY_PAGE_TABLE_ENTRY_LINKED_End                                  8
#define AQ_MEMORY_PAGE_TABLE_ENTRY_LINKED_Start                                8

#define AQ_MEMORY_PAGE_TABLE_ENTRY_REFERENCE_COUNT                           7:0
#define AQ_MEMORY_PAGE_TABLE_ENTRY_REFERENCE_COUNT_End                         7
#define AQ_MEMORY_PAGE_TABLE_ENTRY_REFERENCE_COUNT_Start                       0

