/*******************************************************************************
 *
 * Copyright (c) 2004-2008 by Vivante Corp.  All rights reserved.
 *
 * The material in this file is confidential and contains trade secrets of
 * Vivante Corporation.  This is proprietary information owned by Vivante
 * Corporation.  No part of this work may be disclosed, reproduced, copied,
 * transmitted, or used in any way for any purpose, without the express
 * written permission of Vivante Corporation.
 *
 ******************************************************************************/

/*******************************************************************************
 *
 * This file is automatically generated on Mon Apr 13 01:22:32 2009
 *
 * Any changes made to this file are lost at the next compile run!
 * So better make sure you update the source .r files instead!
 *
 ******************************************************************************/

////////////////////////////////////////////////////////////////////////////////
//                             ~~~~~~~~~~~~~~~~~~~                            //
//                             Module VertexShader                            //
//                             ~~~~~~~~~~~~~~~~~~~                            //
////////////////////////////////////////////////////////////////////////////////

// Register AQVertexShaderEndPC.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQVertexShaderEndPCRegAddrs                                       0x0200
#define AQ_VERTEX_SHADER_END_PC_Address                                  0x00800
#define AQ_VERTEX_SHADER_END_PC_MSB                                           15
#define AQ_VERTEX_SHADER_END_PC_LSB                                            0
#define AQ_VERTEX_SHADER_END_PC_Count                                          1
#define AQ_VERTEX_SHADER_END_PC_FieldMask                             0x000001FF
#define AQ_VERTEX_SHADER_END_PC_ReadMask                              0x000001FF
#define AQ_VERTEX_SHADER_END_PC_WriteMask                             0x000001FF
#define AQ_VERTEX_SHADER_END_PC_ResetValue                            0x00000000

// GC500 - A program will terminate when the PC equals this number.  The instruction with an address equal to this number will never be executed because termination happens before execution.  It is legal to set this to point to the last location in the instruction ram plus one.  For example, in an implementation with an 8 entry instruction ram, the last entry is 7.  In that case, it is legal to set the EndPC to 8.
#define AQ_VERTEX_SHADER_END_PC_ADDRESS                                      8:0
#define AQ_VERTEX_SHADER_END_PC_ADDRESS_End                                    8
#define AQ_VERTEX_SHADER_END_PC_ADDRESS_Start                                  0

// Register AQVertexShaderInst (1024 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~

// This is the maximum instruction count for vertex shader. It's 128 for GC500

#define AQVertexShaderInstRegAddrs                                        0x1000
#define AQ_VERTEX_SHADER_INST_Address                                    0x04000
#define AQ_VERTEX_SHADER_INST_MSB                                             15
#define AQ_VERTEX_SHADER_INST_LSB                                             10
#define AQ_VERTEX_SHADER_INST_Count                                         1024
#define AQ_VERTEX_SHADER_INST_FieldMask                               0xFFFFFFFF
#define AQ_VERTEX_SHADER_INST_ReadMask                                0xFFFFFFFF
#define AQ_VERTEX_SHADER_INST_WriteMask                               0xFFFFFFFF
#define AQ_VERTEX_SHADER_INST_ResetValue                              0x00000000

#define AQ_VERTEX_SHADER_INST_INSTRUCTION                                   31:0
#define AQ_VERTEX_SHADER_INST_INSTRUCTION_End                                 31
#define AQ_VERTEX_SHADER_INST_INSTRUCTION_Start                                0

// Register AQVertexShaderOutputControl.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQVertexShaderOutputControlRegAddrs                               0x0201
#define AQ_VERTEX_SHADER_OUTPUT_CONTROL_Address                          0x00804
#define AQ_VERTEX_SHADER_OUTPUT_CONTROL_MSB                                   15
#define AQ_VERTEX_SHADER_OUTPUT_CONTROL_LSB                                    0
#define AQ_VERTEX_SHADER_OUTPUT_CONTROL_Count                                  1
#define AQ_VERTEX_SHADER_OUTPUT_CONTROL_FieldMask                     0x0000000F
#define AQ_VERTEX_SHADER_OUTPUT_CONTROL_ReadMask                      0x0000000F
#define AQ_VERTEX_SHADER_OUTPUT_CONTROL_WriteMask                     0x0000000F
#define AQ_VERTEX_SHADER_OUTPUT_CONTROL_ResetValue                    0x00000000

// This is the number of vec4 values that will be copied out of the temporary register file and sent to the PA per vertex 
#define AQ_VERTEX_SHADER_OUTPUT_CONTROL_COUNT                                3:0
#define AQ_VERTEX_SHADER_OUTPUT_CONTROL_COUNT_End                              3
#define AQ_VERTEX_SHADER_OUTPUT_CONTROL_COUNT_Start                            0

// Register AQVertexShaderOutput (4 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Each address specifies a temporary register that will be read out and sent to the PA.  The order that the SH outputs data matches the order of the address fields specifying the temporary registers to be copied.  Address0 comes first.  Only the first AQVertexShaderOutputControl.Count addresses are used.  The rest are ignored.

#define AQVertexShaderOutputRegAddrs                                      0x0204
#define AQ_VERTEX_SHADER_OUTPUT_Address                                  0x00810
#define AQ_VERTEX_SHADER_OUTPUT_MSB                                           15
#define AQ_VERTEX_SHADER_OUTPUT_LSB                                            2
#define AQ_VERTEX_SHADER_OUTPUT_Count                                          4
#define AQ_VERTEX_SHADER_OUTPUT_FieldMask                             0x1F1F1F1F
#define AQ_VERTEX_SHADER_OUTPUT_ReadMask                              0x1F1F1F1F
#define AQ_VERTEX_SHADER_OUTPUT_WriteMask                             0x1F1F1F1F
#define AQ_VERTEX_SHADER_OUTPUT_ResetValue                            0x00000000

#define AQ_VERTEX_SHADER_OUTPUT_ADDRESS0                                     4:0
#define AQ_VERTEX_SHADER_OUTPUT_ADDRESS0_End                                   4
#define AQ_VERTEX_SHADER_OUTPUT_ADDRESS0_Start                                 0

#define AQ_VERTEX_SHADER_OUTPUT_ADDRESS1                                    12:8
#define AQ_VERTEX_SHADER_OUTPUT_ADDRESS1_End                                  12
#define AQ_VERTEX_SHADER_OUTPUT_ADDRESS1_Start                                 8

#define AQ_VERTEX_SHADER_OUTPUT_ADDRESS2                                   20:16
#define AQ_VERTEX_SHADER_OUTPUT_ADDRESS2_End                                  20
#define AQ_VERTEX_SHADER_OUTPUT_ADDRESS2_Start                                16

#define AQ_VERTEX_SHADER_OUTPUT_ADDRESS3                                   28:24
#define AQ_VERTEX_SHADER_OUTPUT_ADDRESS3_End                                  28
#define AQ_VERTEX_SHADER_OUTPUT_ADDRESS3_Start                                24

// Register AQVertexShaderInputControl.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQVertexShaderInputControlRegAddrs                                0x0202
#define AQ_VERTEX_SHADER_INPUT_CONTROL_Address                           0x00808
#define AQ_VERTEX_SHADER_INPUT_CONTROL_MSB                                    15
#define AQ_VERTEX_SHADER_INPUT_CONTROL_LSB                                     0
#define AQ_VERTEX_SHADER_INPUT_CONTROL_Count                                   1
#define AQ_VERTEX_SHADER_INPUT_CONTROL_FieldMask                      0x00001F0F
#define AQ_VERTEX_SHADER_INPUT_CONTROL_ReadMask                       0x00001F0F
#define AQ_VERTEX_SHADER_INPUT_CONTROL_WriteMask                      0x00001F0F
#define AQ_VERTEX_SHADER_INPUT_CONTROL_ResetValue                     0x00000000

// This is the number of vec4 values the FE sends the SH per vertex.
#define AQ_VERTEX_SHADER_INPUT_CONTROL_COUNT                                 3:0
#define AQ_VERTEX_SHADER_INPUT_CONTROL_COUNT_End                               3
#define AQ_VERTEX_SHADER_INPUT_CONTROL_COUNT_Start                             0

// The shader waits for a number of vertices to arrive before executing because the internal execution granularity is much larger than a vertex.  The shader will stop waiting and start executing after 16 times this many cycles have elapsed without receiving anything.
#define AQ_VERTEX_SHADER_INPUT_CONTROL_TIMEOUT                              12:8
#define AQ_VERTEX_SHADER_INPUT_CONTROL_TIMEOUT_End                            12
#define AQ_VERTEX_SHADER_INPUT_CONTROL_TIMEOUT_Start                           8

// Register AQVertexShaderInput (4 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// For each vertex, the Nth vec4 from the FE will be written into the temporary register specified in the nth address field.  Address fields corresponding to vec4s that will never arrive are ignored.

#define AQVertexShaderInputRegAddrs                                       0x0208
#define AQ_VERTEX_SHADER_INPUT_Address                                   0x00820
#define AQ_VERTEX_SHADER_INPUT_MSB                                            15
#define AQ_VERTEX_SHADER_INPUT_LSB                                             2
#define AQ_VERTEX_SHADER_INPUT_Count                                           4
#define AQ_VERTEX_SHADER_INPUT_FieldMask                              0x1F1F1F1F
#define AQ_VERTEX_SHADER_INPUT_ReadMask                               0x1F1F1F1F
#define AQ_VERTEX_SHADER_INPUT_WriteMask                              0x1F1F1F1F
#define AQ_VERTEX_SHADER_INPUT_ResetValue                             0x00000000

#define AQ_VERTEX_SHADER_INPUT_ADDRESS0                                      4:0
#define AQ_VERTEX_SHADER_INPUT_ADDRESS0_End                                    4
#define AQ_VERTEX_SHADER_INPUT_ADDRESS0_Start                                  0

#define AQ_VERTEX_SHADER_INPUT_ADDRESS1                                     12:8
#define AQ_VERTEX_SHADER_INPUT_ADDRESS1_End                                   12
#define AQ_VERTEX_SHADER_INPUT_ADDRESS1_Start                                  8

#define AQ_VERTEX_SHADER_INPUT_ADDRESS2                                    20:16
#define AQ_VERTEX_SHADER_INPUT_ADDRESS2_End                                   20
#define AQ_VERTEX_SHADER_INPUT_ADDRESS2_Start                                 16

#define AQ_VERTEX_SHADER_INPUT_ADDRESS3                                    28:24
#define AQ_VERTEX_SHADER_INPUT_ADDRESS3_End                                   28
#define AQ_VERTEX_SHADER_INPUT_ADDRESS3_Start                                 24

// Register AQVertexShaderTemporaryRegisterControl.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQVertexShaderTemporaryRegisterControlRegAddrs                    0x0203
#define AQ_VERTEX_SHADER_TEMPORARY_REGISTER_CONTROL_Address              0x0080C
#define AQ_VERTEX_SHADER_TEMPORARY_REGISTER_CONTROL_MSB                       15
#define AQ_VERTEX_SHADER_TEMPORARY_REGISTER_CONTROL_LSB                        0
#define AQ_VERTEX_SHADER_TEMPORARY_REGISTER_CONTROL_Count                      1
#define AQ_VERTEX_SHADER_TEMPORARY_REGISTER_CONTROL_FieldMask         0x0000003F
#define AQ_VERTEX_SHADER_TEMPORARY_REGISTER_CONTROL_ReadMask          0x0000003F
#define AQ_VERTEX_SHADER_TEMPORARY_REGISTER_CONTROL_WriteMask         0x0000003F
#define AQ_VERTEX_SHADER_TEMPORARY_REGISTER_CONTROL_ResetValue        0x00000000

// This specifies the number of temporary registers to allocate for each vertex.  The inclusive temporary register range that may be used by this vertex is r[0] to r[AQVertexShaderTemporaryRegisterControl.Count-1].
#define AQ_VERTEX_SHADER_TEMPORARY_REGISTER_CONTROL_COUNT                    5:0
#define AQ_VERTEX_SHADER_TEMPORARY_REGISTER_CONTROL_COUNT_End                  5
#define AQ_VERTEX_SHADER_TEMPORARY_REGISTER_CONTROL_COUNT_Start                0

// Register AQVertexShaderLoadBalancing.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQVertexShaderLoadBalancingRegAddrs                               0x020C
#define AQ_VERTEX_SHADER_LOAD_BALANCING_Address                          0x00830
#define AQ_VERTEX_SHADER_LOAD_BALANCING_MSB                                   15
#define AQ_VERTEX_SHADER_LOAD_BALANCING_LSB                                    0
#define AQ_VERTEX_SHADER_LOAD_BALANCING_Count                                  1
#define AQ_VERTEX_SHADER_LOAD_BALANCING_FieldMask                     0x0F0F00FF
#define AQ_VERTEX_SHADER_LOAD_BALANCING_ReadMask                      0x0F0F00FF
#define AQ_VERTEX_SHADER_LOAD_BALANCING_WriteMask                     0x0F0F00FF
#define AQ_VERTEX_SHADER_LOAD_BALANCING_ResetValue                    0x00000000

// This scales the number of empty vertex buffer output entries to determine how many vertex groups can be executing.  The maximum legal value = Min(255, floor(256.0/(shader_cores*((number_of_vertex_output_registers+1)>>1)))).  The minimum legal value = ceil(256.0*8.0/(512-((number_of_vertex_output_registers+1)&~1)*vertex_cache_size)).
#define AQ_VERTEX_SHADER_LOAD_BALANCING_SCALE                                7:0
#define AQ_VERTEX_SHADER_LOAD_BALANCING_SCALE_End                              7
#define AQ_VERTEX_SHADER_LOAD_BALANCING_SCALE_Start                            0

// This is used to cap the number of vertex groups that are allowed to execute.  0 is illegal.
#define AQ_VERTEX_SHADER_LOAD_BALANCING_MAX                                19:16
#define AQ_VERTEX_SHADER_LOAD_BALANCING_MAX_End                               19
#define AQ_VERTEX_SHADER_LOAD_BALANCING_MAX_Start                             16

// AQVertexShaderLoadBalancing.FavorPS/16.0 is the fraction of the time that the schedular will favor a pixel shader instruction over a vertex shader instruction.
#define AQ_VERTEX_SHADER_LOAD_BALANCING_FAVOR_PS                           27:24
#define AQ_VERTEX_SHADER_LOAD_BALANCING_FAVOR_PS_End                          27
#define AQ_VERTEX_SHADER_LOAD_BALANCING_FAVOR_PS_Start                        24

// Register AQVertexShaderPerformanceCounter.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQVertexShaderPerformanceCounterRegAddrs                          0x020D
#define AQ_VERTEX_SHADER_PERFORMANCE_COUNTER_Address                     0x00834
#define AQ_VERTEX_SHADER_PERFORMANCE_COUNTER_MSB                              15
#define AQ_VERTEX_SHADER_PERFORMANCE_COUNTER_LSB                               0
#define AQ_VERTEX_SHADER_PERFORMANCE_COUNTER_Count                             1
#define AQ_VERTEX_SHADER_PERFORMANCE_COUNTER_FieldMask                0xFFFFFFFF
#define AQ_VERTEX_SHADER_PERFORMANCE_COUNTER_ReadMask                 0xFFFFFFFF
#define AQ_VERTEX_SHADER_PERFORMANCE_COUNTER_WriteMask                0xFFFFFFFF
#define AQ_VERTEX_SHADER_PERFORMANCE_COUNTER_ResetValue               0x00000000

// This is set with a value from AQVertexShaderPerformanceSel
#define AQ_VERTEX_SHADER_PERFORMANCE_COUNTER_SEL0                            7:0
#define AQ_VERTEX_SHADER_PERFORMANCE_COUNTER_SEL0_End                          7
#define AQ_VERTEX_SHADER_PERFORMANCE_COUNTER_SEL0_Start                        0

// This is set with a value from AQVertexShaderPerformanceSel
#define AQ_VERTEX_SHADER_PERFORMANCE_COUNTER_SEL1                           15:8
#define AQ_VERTEX_SHADER_PERFORMANCE_COUNTER_SEL1_End                         15
#define AQ_VERTEX_SHADER_PERFORMANCE_COUNTER_SEL1_Start                        8

// This is set with a value from AQVertexShaderPerformanceSel
#define AQ_VERTEX_SHADER_PERFORMANCE_COUNTER_SEL2                          23:16
#define AQ_VERTEX_SHADER_PERFORMANCE_COUNTER_SEL2_End                         23
#define AQ_VERTEX_SHADER_PERFORMANCE_COUNTER_SEL2_Start                       16

// This is set with a value from AQVertexShaderPerformanceSel
#define AQ_VERTEX_SHADER_PERFORMANCE_COUNTER_SEL3                          31:24
#define AQ_VERTEX_SHADER_PERFORMANCE_COUNTER_SEL3_End                         31
#define AQ_VERTEX_SHADER_PERFORMANCE_COUNTER_SEL3_Start                       24

// Register AQVertexShaderConst (1024 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~

//       address % 4 == 0 for the x component
//                      1 for the y component
//                      2 for the z component
//                      3 for the w component

#define AQVertexShaderConstRegAddrs                                       0x1400
#define AQ_VERTEX_SHADER_CONST_Address                                   0x05000
#define AQ_VERTEX_SHADER_CONST_MSB                                            15
#define AQ_VERTEX_SHADER_CONST_LSB                                            10
#define AQ_VERTEX_SHADER_CONST_Count                                        1024
#define AQ_VERTEX_SHADER_CONST_FieldMask                              0xFFFFFFFF
#define AQ_VERTEX_SHADER_CONST_ReadMask                               0xFFFFFFFF
#define AQ_VERTEX_SHADER_CONST_WriteMask                              0xFFFFFFFF
#define AQ_VERTEX_SHADER_CONST_ResetValue                             0x00000000

#define AQ_VERTEX_SHADER_CONST_VALUE                                        31:0
#define AQ_VERTEX_SHADER_CONST_VALUE_End                                      31
#define AQ_VERTEX_SHADER_CONST_VALUE_Start                                     0

// Register AQVertexShaderStartPC.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQVertexShaderStartPCRegAddrs                                     0x020E
#define AQ_VERTEX_SHADER_START_PC_Address                                0x00838
#define AQ_VERTEX_SHADER_START_PC_MSB                                         15
#define AQ_VERTEX_SHADER_START_PC_LSB                                          0
#define AQ_VERTEX_SHADER_START_PC_Count                                        1
#define AQ_VERTEX_SHADER_START_PC_FieldMask                           0x03FF03FF
#define AQ_VERTEX_SHADER_START_PC_ReadMask                            0x03FF03FF
#define AQ_VERTEX_SHADER_START_PC_WriteMask                           0x03FF03FF
#define AQ_VERTEX_SHADER_START_PC_ResetValue                          0x00000000

// GC500 - This register is not used.
#define AQ_VERTEX_SHADER_START_PC_PC_OFFSET                                  9:0
#define AQ_VERTEX_SHADER_START_PC_PC_OFFSET_End                                9
#define AQ_VERTEX_SHADER_START_PC_PC_OFFSET_Start                              0

// GC500 - This register is not used.
#define AQ_VERTEX_SHADER_START_PC_CONST_OFFSET                             25:16
#define AQ_VERTEX_SHADER_START_PC_CONST_OFFSET_End                            25
#define AQ_VERTEX_SHADER_START_PC_CONST_OFFSET_Start                          16

// Register AQShBistControl.
// ~~~~~~~~~~~~~~~~~~~~~~~~

// Only accessible from the register interface
// This is write only.

#define AQShBistControlRegAddrs                                           0x020F
#define AQ_SH_BIST_CONTROL_Address                                       0x0083C
#define AQ_SH_BIST_CONTROL_MSB                                                15
#define AQ_SH_BIST_CONTROL_LSB                                                 0
#define AQ_SH_BIST_CONTROL_Count                                               1
#define AQ_SH_BIST_CONTROL_FieldMask                                  0x00000003
#define AQ_SH_BIST_CONTROL_ReadMask                                   0x00000003
#define AQ_SH_BIST_CONTROL_WriteMask                                  0x00000003
#define AQ_SH_BIST_CONTROL_ResetValue                                 0x00000000

#define AQ_SH_BIST_CONTROL_RESET                                             0:0
#define AQ_SH_BIST_CONTROL_RESET_End                                           0
#define AQ_SH_BIST_CONTROL_RESET_Start                                         0
#define   AQ_SH_BIST_CONTROL_RESET_NOT_RESET                                 0x0
#define   AQ_SH_BIST_CONTROL_RESET_RESET                                     0x1

#define AQ_SH_BIST_CONTROL_MODE                                              1:1
#define AQ_SH_BIST_CONTROL_MODE_End                                            1
#define AQ_SH_BIST_CONTROL_MODE_Start                                          1
#define   AQ_SH_BIST_CONTROL_MODE_NOT_BIST_MODE                              0x0
#define   AQ_SH_BIST_CONTROL_MODE_BIST_MODE                                  0x1

// Register AQShBistStatus0.
// ~~~~~~~~~~~~~~~~~~~~~~~~

// Only accessible from the register interface
// This is read only.

#define AQShBistStatus0RegAddrs                                           0x0210
#define AQ_SH_BIST_STATUS0_Address                                       0x00840
#define AQ_SH_BIST_STATUS0_MSB                                                15
#define AQ_SH_BIST_STATUS0_LSB                                                 0
#define AQ_SH_BIST_STATUS0_Count                                               1
#define AQ_SH_BIST_STATUS0_FieldMask                                  0x00000001
#define AQ_SH_BIST_STATUS0_ReadMask                                   0x00000001
#define AQ_SH_BIST_STATUS0_WriteMask                                  0x00000001
#define AQ_SH_BIST_STATUS0_ResetValue                                 0x00000000

#define AQ_SH_BIST_STATUS0_DONE                                              0:0
#define AQ_SH_BIST_STATUS0_DONE_End                                            0
#define AQ_SH_BIST_STATUS0_DONE_Start                                          0
#define   AQ_SH_BIST_STATUS0_DONE_NOT_DONE                                   0x0
#define   AQ_SH_BIST_STATUS0_DONE_DONE                                       0x1

// Register AQShBistStatus1.
// ~~~~~~~~~~~~~~~~~~~~~~~~

// Only accessible from the register interface
// This is read only.

#define AQShBistStatus1RegAddrs                                           0x0211
#define AQ_SH_BIST_STATUS1_Address                                       0x00844
#define AQ_SH_BIST_STATUS1_MSB                                                15
#define AQ_SH_BIST_STATUS1_LSB                                                 0
#define AQ_SH_BIST_STATUS1_Count                                               1
#define AQ_SH_BIST_STATUS1_FieldMask                                  0xFFFFFFFF
#define AQ_SH_BIST_STATUS1_ReadMask                                   0xFFFFFFFF
#define AQ_SH_BIST_STATUS1_WriteMask                                  0xFFFFFFFF
#define AQ_SH_BIST_STATUS1_ResetValue                                 0x00000000

// The number of rams in the SH is expected to fluctuate a lot over its lifetime.  A total of 64 errors bits are provided to cover most cases.
#define AQ_SH_BIST_STATUS1_BM_ERROR                                         31:0
#define AQ_SH_BIST_STATUS1_BM_ERROR_End                                       31
#define AQ_SH_BIST_STATUS1_BM_ERROR_Start                                      0

// Register AQShBistStatus2.
// ~~~~~~~~~~~~~~~~~~~~~~~~

// Only accessible from the register interface
// This is read only.

#define AQShBistStatus2RegAddrs                                           0x0212
#define AQ_SH_BIST_STATUS2_Address                                       0x00848
#define AQ_SH_BIST_STATUS2_MSB                                                15
#define AQ_SH_BIST_STATUS2_LSB                                                 0
#define AQ_SH_BIST_STATUS2_Count                                               1
#define AQ_SH_BIST_STATUS2_FieldMask                                  0xFFFFFFFF
#define AQ_SH_BIST_STATUS2_ReadMask                                   0xFFFFFFFF
#define AQ_SH_BIST_STATUS2_WriteMask                                  0xFFFFFFFF
#define AQ_SH_BIST_STATUS2_ResetValue                                 0x00000000

#define AQ_SH_BIST_STATUS2_BM_ERROR                                         31:0
#define AQ_SH_BIST_STATUS2_BM_ERROR_End                                       31
#define AQ_SH_BIST_STATUS2_BM_ERROR_Start                                      0

// Register AQShStatus.
// ~~~~~~~~~~~~~~~~~~~

// Only accessible from the register interface
// This is read only.

#define AQShStatusRegAddrs                                                0x0213
#define AQ_SH_STATUS_Address                                             0x0084C
#define AQ_SH_STATUS_MSB                                                      15
#define AQ_SH_STATUS_LSB                                                       0
#define AQ_SH_STATUS_Count                                                     1
#define AQ_SH_STATUS_FieldMask                                        0x007FFFFF
#define AQ_SH_STATUS_ReadMask                                         0x007FFFFF
#define AQ_SH_STATUS_WriteMask                                        0x007FFFFF
#define AQ_SH_STATUS_ResetValue                                       0x00000000

#define AQ_SH_STATUS_VERTEX_INPUT_INTERFACE_IDLE                             0:0
#define AQ_SH_STATUS_VERTEX_INPUT_INTERFACE_IDLE_End                           0
#define AQ_SH_STATUS_VERTEX_INPUT_INTERFACE_IDLE_Start                         0

#define AQ_SH_STATUS_VERTEX_INPUT_BUFFER_IDLE                                1:1
#define AQ_SH_STATUS_VERTEX_INPUT_BUFFER_IDLE_End                              1
#define AQ_SH_STATUS_VERTEX_INPUT_BUFFER_IDLE_Start                            1

#define AQ_SH_STATUS_VERTEX_GROUP_ALLOCATION_EMPTY                           2:2
#define AQ_SH_STATUS_VERTEX_GROUP_ALLOCATION_EMPTY_End                         2
#define AQ_SH_STATUS_VERTEX_GROUP_ALLOCATION_EMPTY_Start                       2

#define AQ_SH_STATUS_VERTEX_OUTPUT_BUFFER_EMPTY                              3:3
#define AQ_SH_STATUS_VERTEX_OUTPUT_BUFFER_EMPTY_End                            3
#define AQ_SH_STATUS_VERTEX_OUTPUT_BUFFER_EMPTY_Start                          3

#define AQ_SH_STATUS_VERTEX_OUTPUT_INTERFACE_IDLE                            4:4
#define AQ_SH_STATUS_VERTEX_OUTPUT_INTERFACE_IDLE_End                          4
#define AQ_SH_STATUS_VERTEX_OUTPUT_INTERFACE_IDLE_Start                        4

#define AQ_SH_STATUS_PIXEL_INPUT_INTERFACE_IDLE                              5:5
#define AQ_SH_STATUS_PIXEL_INPUT_INTERFACE_IDLE_End                            5
#define AQ_SH_STATUS_PIXEL_INPUT_INTERFACE_IDLE_Start                          5

#define AQ_SH_STATUS_PIXEL_INPUT_BUFFER_IDLE                                 6:6
#define AQ_SH_STATUS_PIXEL_INPUT_BUFFER_IDLE_End                               6
#define AQ_SH_STATUS_PIXEL_INPUT_BUFFER_IDLE_Start                             6

#define AQ_SH_STATUS_PIXEL_GROUP_ALLOCATION_EMPTY                            7:7
#define AQ_SH_STATUS_PIXEL_GROUP_ALLOCATION_EMPTY_End                          7
#define AQ_SH_STATUS_PIXEL_GROUP_ALLOCATION_EMPTY_Start                        7

#define AQ_SH_STATUS_PIXEL_OUTPUT_BUFFER_EMPTY                               8:8
#define AQ_SH_STATUS_PIXEL_OUTPUT_BUFFER_EMPTY_End                             8
#define AQ_SH_STATUS_PIXEL_OUTPUT_BUFFER_EMPTY_Start                           8

#define AQ_SH_STATUS_PIXEL_OUTPUT_INTERFACE_IDLE                             9:9
#define AQ_SH_STATUS_PIXEL_OUTPUT_INTERFACE_IDLE_End                           9
#define AQ_SH_STATUS_PIXEL_OUTPUT_INTERFACE_IDLE_Start                         9

#define AQ_SH_STATUS_SH2TX_VALID_                                          10:10
#define AQ_SH_STATUS_SH2TX_VALID__End                                         10
#define AQ_SH_STATUS_SH2TX_VALID__Start                                       10

// This is the ready from the output register.  This interface may also be stalled if the texture sideband fifo is full, but that will not be reflected in the value from this status bit.
#define AQ_SH_STATUS_SH2TX_READY                                           11:11
#define AQ_SH_STATUS_SH2TX_READY_End                                          11
#define AQ_SH_STATUS_SH2TX_READY_Start                                        11

#define AQ_SH_STATUS_SH2PE_VALID_                                          12:12
#define AQ_SH_STATUS_SH2PE_VALID__End                                         12
#define AQ_SH_STATUS_SH2PE_VALID__Start                                       12

#define AQ_SH_STATUS_SH2PE_READY                                           13:13
#define AQ_SH_STATUS_SH2PE_READY_End                                          13
#define AQ_SH_STATUS_SH2PE_READY_Start                                        13

#define AQ_SH_STATUS_SH2PA_VALID_                                          14:14
#define AQ_SH_STATUS_SH2PA_VALID__End                                         14
#define AQ_SH_STATUS_SH2PA_VALID__Start                                       14

#define AQ_SH_STATUS_SH2PA_READY                                           15:15
#define AQ_SH_STATUS_SH2PA_READY_End                                          15
#define AQ_SH_STATUS_SH2PA_READY_Start                                        15

#define AQ_SH_STATUS_FE2SH_VALID_                                          16:16
#define AQ_SH_STATUS_FE2SH_VALID__End                                         16
#define AQ_SH_STATUS_FE2SH_VALID__Start                                       16

#define AQ_SH_STATUS_FE2SH_READY                                           17:17
#define AQ_SH_STATUS_FE2SH_READY_End                                          17
#define AQ_SH_STATUS_FE2SH_READY_Start                                        17

#define AQ_SH_STATUS_TX2SH_VALID_                                          18:18
#define AQ_SH_STATUS_TX2SH_VALID__End                                         18
#define AQ_SH_STATUS_TX2SH_VALID__Start                                       18

#define AQ_SH_STATUS_TX2SH_READY                                           19:19
#define AQ_SH_STATUS_TX2SH_READY_End                                          19
#define AQ_SH_STATUS_TX2SH_READY_Start                                        19

#define AQ_SH_STATUS_RA2SH_VALID_                                          20:20
#define AQ_SH_STATUS_RA2SH_VALID__End                                         20
#define AQ_SH_STATUS_RA2SH_VALID__Start                                       20

#define AQ_SH_STATUS_RA2SH_READY                                           21:21
#define AQ_SH_STATUS_RA2SH_READY_End                                          21
#define AQ_SH_STATUS_RA2SH_READY_Start                                        21

#define AQ_SH_STATUS_TEXTURE_SIDEBAND_FIFO_EMPTY                           22:22
#define AQ_SH_STATUS_TEXTURE_SIDEBAND_FIFO_EMPTY_End                          22
#define AQ_SH_STATUS_TEXTURE_SIDEBAND_FIFO_EMPTY_Start                        22

////////////////////////////////////////////////////////////////////////////////
//                             ~~~~~~~~~~~~~~~~~~                             //
//                             Module PixelShader                             //
//                             ~~~~~~~~~~~~~~~~~~                             //
////////////////////////////////////////////////////////////////////////////////

// Register AQPixelShaderEndPC.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQPixelShaderEndPCRegAddrs                                        0x0400
#define AQ_PIXEL_SHADER_END_PC_Address                                   0x01000
#define AQ_PIXEL_SHADER_END_PC_MSB                                            15
#define AQ_PIXEL_SHADER_END_PC_LSB                                             0
#define AQ_PIXEL_SHADER_END_PC_Count                                           1
#define AQ_PIXEL_SHADER_END_PC_FieldMask                              0x000001FF
#define AQ_PIXEL_SHADER_END_PC_ReadMask                               0x000001FF
#define AQ_PIXEL_SHADER_END_PC_WriteMask                              0x000001FF
#define AQ_PIXEL_SHADER_END_PC_ResetValue                             0x00000000

// GC500 - A program will terminate when the PC equals this number.  The instruction with an address equal to this number will never be executed because termination happens before execution.
#define AQ_PIXEL_SHADER_END_PC_ADDRESS                                       8:0
#define AQ_PIXEL_SHADER_END_PC_ADDRESS_End                                     8
#define AQ_PIXEL_SHADER_END_PC_ADDRESS_Start                                   0

// Register AQPixelShaderInst (1024 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQPixelShaderInstRegAddrs                                         0x1800
#define AQ_PIXEL_SHADER_INST_Address                                     0x06000
#define AQ_PIXEL_SHADER_INST_MSB                                              15
#define AQ_PIXEL_SHADER_INST_LSB                                              10
#define AQ_PIXEL_SHADER_INST_Count                                          1024
#define AQ_PIXEL_SHADER_INST_FieldMask                                0xFFFFFFFF
#define AQ_PIXEL_SHADER_INST_ReadMask                                 0xFFFFFFFF
#define AQ_PIXEL_SHADER_INST_WriteMask                                0xFFFFFFFF
#define AQ_PIXEL_SHADER_INST_ResetValue                               0x00000000

#define AQ_PIXEL_SHADER_INST_INSTRUCTION                                    31:0
#define AQ_PIXEL_SHADER_INST_INSTRUCTION_End                                  31
#define AQ_PIXEL_SHADER_INST_INSTRUCTION_Start                                 0

// Register AQPixelShaderColorOut.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQPixelShaderColorOutRegAddrs                                     0x0401
#define AQ_PIXEL_SHADER_COLOR_OUT_Address                                0x01004
#define AQ_PIXEL_SHADER_COLOR_OUT_MSB                                         15
#define AQ_PIXEL_SHADER_COLOR_OUT_LSB                                          0
#define AQ_PIXEL_SHADER_COLOR_OUT_Count                                        1
#define AQ_PIXEL_SHADER_COLOR_OUT_FieldMask                           0x00003F1F
#define AQ_PIXEL_SHADER_COLOR_OUT_ReadMask                            0x00003F1F
#define AQ_PIXEL_SHADER_COLOR_OUT_WriteMask                           0x00003F1F
#define AQ_PIXEL_SHADER_COLOR_OUT_ResetValue                          0x00000000

// This temporary register specified by this field will be sent to the PE as the color.
#define AQ_PIXEL_SHADER_COLOR_OUT_ADDRESS                                    4:0
#define AQ_PIXEL_SHADER_COLOR_OUT_ADDRESS_End                                  4
#define AQ_PIXEL_SHADER_COLOR_OUT_ADDRESS_Start                                0

// XAQ2 does not support this reigster. This temporary register specified by this field will be sent to the PE as the multiple render target's color1.
#define AQ_PIXEL_SHADER_COLOR_OUT_ADDRESS1                                  13:8
#define AQ_PIXEL_SHADER_COLOR_OUT_ADDRESS1_End                                13
#define AQ_PIXEL_SHADER_COLOR_OUT_ADDRESS1_Start                               8

// Register AQPixelShaderInputControl.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQPixelShaderInputControlRegAddrs                                 0x0402
#define AQ_PIXEL_SHADER_INPUT_CONTROL_Address                            0x01008
#define AQ_PIXEL_SHADER_INPUT_CONTROL_MSB                                     15
#define AQ_PIXEL_SHADER_INPUT_CONTROL_LSB                                      0
#define AQ_PIXEL_SHADER_INPUT_CONTROL_Count                                    1
#define AQ_PIXEL_SHADER_INPUT_CONTROL_FieldMask                       0x00001F0F
#define AQ_PIXEL_SHADER_INPUT_CONTROL_ReadMask                        0x00001F0F
#define AQ_PIXEL_SHADER_INPUT_CONTROL_WriteMask                       0x00001F0F
#define AQ_PIXEL_SHADER_INPUT_CONTROL_ResetValue                      0x00000000

// This count should match the number of cycles of data sent from the RA.  In multisample mode, this value may be 1 larger than the value derived purely from the program because of the additional cycle needed to transfer multisample depth.
#define AQ_PIXEL_SHADER_INPUT_CONTROL_COUNT                                  3:0
#define AQ_PIXEL_SHADER_INPUT_CONTROL_COUNT_End                                3
#define AQ_PIXEL_SHADER_INPUT_CONTROL_COUNT_Start                              0

// The shader may wait for a number of quads to arrive before executing because the internal execution granularity can be much larger than a quad.  The shader will stop waiting and start executing after 16 times this many cycles have elapsed without receiving anything.
#define AQ_PIXEL_SHADER_INPUT_CONTROL_TIMEOUT                               12:8
#define AQ_PIXEL_SHADER_INPUT_CONTROL_TIMEOUT_End                             12
#define AQ_PIXEL_SHADER_INPUT_CONTROL_TIMEOUT_Start                            8

// Register AQPixelShaderTemporaryRegisterControl.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQPixelShaderTemporaryRegisterControlRegAddrs                     0x0403
#define AQ_PIXEL_SHADER_TEMPORARY_REGISTER_CONTROL_Address               0x0100C
#define AQ_PIXEL_SHADER_TEMPORARY_REGISTER_CONTROL_MSB                        15
#define AQ_PIXEL_SHADER_TEMPORARY_REGISTER_CONTROL_LSB                         0
#define AQ_PIXEL_SHADER_TEMPORARY_REGISTER_CONTROL_Count                       1
#define AQ_PIXEL_SHADER_TEMPORARY_REGISTER_CONTROL_FieldMask          0x0000003F
#define AQ_PIXEL_SHADER_TEMPORARY_REGISTER_CONTROL_ReadMask           0x0000003F
#define AQ_PIXEL_SHADER_TEMPORARY_REGISTER_CONTROL_WriteMask          0x0000003F
#define AQ_PIXEL_SHADER_TEMPORARY_REGISTER_CONTROL_ResetValue         0x00000000

// This specifies the number of temporary registers to allocate for each pixel.  The inclusive temporary register range that may be used by this pixel is r[0] to r[AQPixelShaderTemporaryRegisterControl.Count-1].  In multisample mode, this value may be 1 larger than the value derived purely from the program because the multisample depth value is automatically placed at the end of the range.
#define AQ_PIXEL_SHADER_TEMPORARY_REGISTER_CONTROL_COUNT                     5:0
#define AQ_PIXEL_SHADER_TEMPORARY_REGISTER_CONTROL_COUNT_End                   5
#define AQ_PIXEL_SHADER_TEMPORARY_REGISTER_CONTROL_COUNT_Start                 0

// Register AQPixelShaderControl.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQPixelShaderControlRegAddrs                                      0x0404
#define AQ_PIXEL_SHADER_CONTROL_Address                                  0x01010
#define AQ_PIXEL_SHADER_CONTROL_MSB                                           15
#define AQ_PIXEL_SHADER_CONTROL_LSB                                            0
#define AQ_PIXEL_SHADER_CONTROL_Count                                          1
#define AQ_PIXEL_SHADER_CONTROL_FieldMask                             0x00000003
#define AQ_PIXEL_SHADER_CONTROL_ReadMask                              0x00000003
#define AQ_PIXEL_SHADER_CONTROL_WriteMask                             0x00000003
#define AQ_PIXEL_SHADER_CONTROL_ResetValue                            0x00000000

// Pixel shading is bypassed when this is enabled.  Data transactions from the RA pass
// through the shader to the PE unmodified.  The RA2SH and SH2PE interfaces only match in double
// depth mode, so attempting to use this in other modes probably won't work.
#define AQ_PIXEL_SHADER_CONTROL_BYPASS_SHADING                               0:0
#define AQ_PIXEL_SHADER_CONTROL_BYPASS_SHADING_End                             0
#define AQ_PIXEL_SHADER_CONTROL_BYPASS_SHADING_Start                           0
#define   AQ_PIXEL_SHADER_CONTROL_BYPASS_SHADING_DISABLE                     0x0
#define   AQ_PIXEL_SHADER_CONTROL_BYPASS_SHADING_ENABLE                      0x1

// Enabling this causes the color sent to the PE to be clamped to [0.0, 1.0].
#define AQ_PIXEL_SHADER_CONTROL_COLOR_OUT_SATURATE                           1:1
#define AQ_PIXEL_SHADER_CONTROL_COLOR_OUT_SATURATE_End                         1
#define AQ_PIXEL_SHADER_CONTROL_COLOR_OUT_SATURATE_Start                       1
#define   AQ_PIXEL_SHADER_CONTROL_COLOR_OUT_SATURATE_DISABLE                 0x0
#define   AQ_PIXEL_SHADER_CONTROL_COLOR_OUT_SATURATE_ENABLE                  0x1

// Register AQPixelShaderPerformanceCounter.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQPixelShaderPerformanceCounterRegAddrs                           0x0405
#define AQ_PIXEL_SHADER_PERFORMANCE_COUNTER_Address                      0x01014
#define AQ_PIXEL_SHADER_PERFORMANCE_COUNTER_MSB                               15
#define AQ_PIXEL_SHADER_PERFORMANCE_COUNTER_LSB                                0
#define AQ_PIXEL_SHADER_PERFORMANCE_COUNTER_Count                              1
#define AQ_PIXEL_SHADER_PERFORMANCE_COUNTER_FieldMask                 0xFFFFFFFF
#define AQ_PIXEL_SHADER_PERFORMANCE_COUNTER_ReadMask                  0xFFFFFFFF
#define AQ_PIXEL_SHADER_PERFORMANCE_COUNTER_WriteMask                 0xFFFFFFFF
#define AQ_PIXEL_SHADER_PERFORMANCE_COUNTER_ResetValue                0x00000000

// This is set with a value from AQPixelShaderPerformanceSel
#define AQ_PIXEL_SHADER_PERFORMANCE_COUNTER_SEL0                             7:0
#define AQ_PIXEL_SHADER_PERFORMANCE_COUNTER_SEL0_End                           7
#define AQ_PIXEL_SHADER_PERFORMANCE_COUNTER_SEL0_Start                         0

// This is set with a value from AQPixelShaderPerformanceSel
#define AQ_PIXEL_SHADER_PERFORMANCE_COUNTER_SEL1                            15:8
#define AQ_PIXEL_SHADER_PERFORMANCE_COUNTER_SEL1_End                          15
#define AQ_PIXEL_SHADER_PERFORMANCE_COUNTER_SEL1_Start                         8

// This is set with a value from AQPixelShaderPerformanceSel
#define AQ_PIXEL_SHADER_PERFORMANCE_COUNTER_SEL2                           23:16
#define AQ_PIXEL_SHADER_PERFORMANCE_COUNTER_SEL2_End                          23
#define AQ_PIXEL_SHADER_PERFORMANCE_COUNTER_SEL2_Start                        16

// This is set with a value from AQPixelShaderPerformanceSel
#define AQ_PIXEL_SHADER_PERFORMANCE_COUNTER_SEL3                           31:24
#define AQ_PIXEL_SHADER_PERFORMANCE_COUNTER_SEL3_End                          31
#define AQ_PIXEL_SHADER_PERFORMANCE_COUNTER_SEL3_Start                        24

// Register AQPixelShaderConst (256 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~

// GC500 - There are 64 vec4 constants.
//       address % 4 == 0 for the x component
//                      1 for the y component
//                      2 for the z component
//                      3 for the w component

#define AQPixelShaderConstRegAddrs                                        0x1C00
#define AQ_PIXEL_SHADER_CONST_Address                                    0x07000
#define AQ_PIXEL_SHADER_CONST_MSB                                             15
#define AQ_PIXEL_SHADER_CONST_LSB                                              8
#define AQ_PIXEL_SHADER_CONST_Count                                          256
#define AQ_PIXEL_SHADER_CONST_FieldMask                               0xFFFFFFFF
#define AQ_PIXEL_SHADER_CONST_ReadMask                                0xFFFFFFFF
#define AQ_PIXEL_SHADER_CONST_WriteMask                               0xFFFFFFFF
#define AQ_PIXEL_SHADER_CONST_ResetValue                              0x00000000

#define AQ_PIXEL_SHADER_CONST_VALUE                                         31:0
#define AQ_PIXEL_SHADER_CONST_VALUE_End                                       31
#define AQ_PIXEL_SHADER_CONST_VALUE_Start                                      0

// Register AQPixelShaderStartPC.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define AQPixelShaderStartPCRegAddrs                                      0x0406
#define AQ_PIXEL_SHADER_START_PC_Address                                 0x01018
#define AQ_PIXEL_SHADER_START_PC_MSB                                          15
#define AQ_PIXEL_SHADER_START_PC_LSB                                           0
#define AQ_PIXEL_SHADER_START_PC_Count                                         1
#define AQ_PIXEL_SHADER_START_PC_FieldMask                            0x03FF03FF
#define AQ_PIXEL_SHADER_START_PC_ReadMask                             0x03FF03FF
#define AQ_PIXEL_SHADER_START_PC_WriteMask                            0x03FF03FF
#define AQ_PIXEL_SHADER_START_PC_ResetValue                           0x00000000

// GC500 - This register is not used.
#define AQ_PIXEL_SHADER_START_PC_PC_OFFSET                                   9:0
#define AQ_PIXEL_SHADER_START_PC_PC_OFFSET_End                                 9
#define AQ_PIXEL_SHADER_START_PC_PC_OFFSET_Start                               0

// GC500 - Constant register base address.
#define AQ_PIXEL_SHADER_START_PC_CONST_OFFSET                              25:16
#define AQ_PIXEL_SHADER_START_PC_CONST_OFFSET_End                             25
#define AQ_PIXEL_SHADER_START_PC_CONST_OFFSET_Start                           16

////////////////////////////////////////////////////////////////////////////////
//                      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                     //
//                      Command AQVertexShaderPerformance                     //
//                      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                     //
////////////////////////////////////////////////////////////////////////////////

// Offset AQVertexShaderPerformance.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#define AQ_VERTEX_SHADER_PERFORMANCE_SEL                                     7:0
#define AQ_VERTEX_SHADER_PERFORMANCE_SEL_End                                   7
#define AQ_VERTEX_SHADER_PERFORMANCE_SEL_Start                                 0
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_NONE                             0x00
// The ready used for the sh2tx counters do not look at the sideband fifo status.  The sideband fifo should never be full, so this will still give an accurate count
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_SH2TX_VALID__AND_READY_          0x01
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_SH2TX_VALID__AND_READY           0x02
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_SH2TX_VALID_AND_READY_           0x03
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_SH2TX_VALID_AND_READY            0x04
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_TX2SH_VALID__AND_READY_          0x05
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_TX2SH_VALID__AND_READY           0x06
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_TX2SH_VALID_AND_READY_           0x07
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_TX2SH_VALID_AND_READY            0x08
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_SH2PA_VALID__AND_READY_          0x09
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_SH2PA_VALID__AND_READY           0x0A
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_SH2PA_VALID_AND_READY_           0x0B
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_SH2PA_VALID_AND_READY            0x0C
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_FE2SH_VALID__AND_READY_          0x0D
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_FE2SH_VALID__AND_READY           0x0E
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_FE2SH_VALID_AND_READY_           0x0F
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_FE2SH_VALID_AND_READY            0x10
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_TEXTURE_REQUEST_FIFO_ALMOST_FULL 0x11
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_TEXTURE_SIDEBAND_FIFO_FULL       0x12
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_TEXTURE_RETURN_CHECK_FIFO_FULL   0x13
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_STATE_LOAD_TO_DATA_WAIT_FOR_IDLE 0x14
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_DATA_TO_STATE_LOAD_WAIT_FOR_IDLE 0x15
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_STATE_LOAD_TO_DATA_TRANSITIONS   0x16
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_STATE_LOADS                      0x17
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_VERTEX_CACHE_HITS                0x18
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_VERTEX_CACHE_MISSES              0x19
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_INPUT_ATTRIBUTES                 0x1A
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_INPUT_TIMEOUTS                   0x1B
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_WRITE_GENERATE_ATTRIBUTES        0x1C
// All of the groups that still need to execute more instructions are suspended waiting for texture data.  This is the status for the entire shader.
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_ALL_UNFINISHED_GROUPS_WAITING_FOR_TEXTURE 0x1D
// There are pending texture requests but no instructions are executing.  This is the status for the entire shader.
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_PENDING_TEXTURES_WITHOUT_INSTRUCTION_EXECUTION 0x1E
// This is the count divided by the smallest power of 2 number >= the number of cores.
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_INSTRUCTIONS_EXECUTED            0x1F
// This is the number of instructions executed for an entire group.  It increments by 1 regardless of how many vertices in the group needed that instruction
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_GROUP_INSTRUCTIONS_EXECUTED      0x20
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_OUTPUT_BUFFER_BANK_COLLISIONS    0x21
// The only available groups are texture loads, and the texture request fifo is full
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_TEXTURE_REQUEST_FIFO_LIMITED     0x22
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_GROUPS                           0x23
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_VERTICES                         0x24
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_HALF_GROUPS_OR_PAGES_IN_USE      0x25
// This is the SH busy not the VS busy.
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_BUSY                             0x26
// This does not include discarded texture loads.
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_TEXTURE_LOADS                    0x27
#define   AQ_VERTEX_SHADER_PERFORMANCE_SEL_DISCARDED_TEXTURE_LOADS          0x28

////////////////////////////////////////////////////////////////////////////////
//                      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                      //
//                      Command AQPixelShaderPerformance                      //
//                      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                      //
////////////////////////////////////////////////////////////////////////////////

// Offset AQPixelShaderPerformance.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#define AQ_PIXEL_SHADER_PERFORMANCE_SEL                                      7:0
#define AQ_PIXEL_SHADER_PERFORMANCE_SEL_End                                    7
#define AQ_PIXEL_SHADER_PERFORMANCE_SEL_Start                                  0
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_NONE                              0x00
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_SH2PE_VALID__AND_READY_           0x01
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_SH2PE_VALID__AND_READY            0x02
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_SH2PE_VALID_AND_READY_            0x03
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_SH2PE_VALID_AND_READY             0x04
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_RA2SH_VALID__AND_READY_           0x05
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_RA2SH_VALID__AND_READY            0x06
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_RA2SH_VALID_AND_READY_            0x07
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_RA2SH_VALID_AND_READY             0x08
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_STATE_LOAD_TO_DATA_WAIT_FOR_IDLE  0x09
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_DATA_TO_STATE_LOAD_WAIT_FOR_IDLE  0x0A
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_STATE_LOAD_TO_DATA_TRANSITIONS    0x0B
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_STATE_LOADS                       0x0C
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_INPUT_ATTRIBUTES                  0x0D
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_INPUT_TIMEOUTS                    0x0E
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_WRITE_GENERATE_ATTRIBUTES         0x0F
// This is the count divided by the smallest power of 2 number >= the number of cores.
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_INSTRUCTIONS_EXECUTED             0x10
// This is the number of instructions executed for an entire group.  It increments by 1 regardless of how many vertices in the group needed that instruction
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_GROUP_INSTRUCTIONS_EXECUTED       0x11
// The only available groups are texture loads, and the texture request fifo is full
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_TEXTURE_REQUEST_FIFO_LIMITED      0x12
// This is the number of incoming pixel that got shaded.  Some of them may not be covered at all, but they need to be shaded anyway because of quad granularity.  This number may be slightly less than the number computed from the group count because generated quads are not included in this count.
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_SHADED_PIXELS                     0x13
// The number of incoming covered pixels that got shaded
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_SHADED_COVERED_PIXELS             0x14
// These are the covered pixels that are texkilled.  Uncovered pixels that are texkilled are not counted.
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_TEXKILLED_PIXELS                  0x15
// The number of shaded pixels output from the shader
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_OUTPUT_SHADED_PIXELS              0x16
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_GROUPS                            0x17
// This is the number of quads from the RA that were discarded
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_DISCARDED_QUADS                   0x18
// This is the number of attributes that were discarded as a result of the quad discarding
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_DISCARDED_ATTRIBUTES              0x19
// This is the number of quads discarded while idle
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_IDLE_DISCARDED_QUADS              0x1A
// This is the number of attributes discarded while idle
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_IDLE_DISCARDED_ATTRIBUTES         0x1B
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_BYPASS_ATTRIBUTES                 0x1C
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_BYPASS_MODE_CYCLES                0x1D
// This does not include discarded texture loads.
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_TEXTURE_LOADS                     0x1E
#define   AQ_PIXEL_SHADER_PERFORMANCE_SEL_DISCARDED_TEXTURE_LOADS           0x1F

////////////////////////////////////////////////////////////////////////////////
//                       ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                       //
//                       Command ShaderInstructionWord3                       //
//                       ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                       //
////////////////////////////////////////////////////////////////////////////////

// Offset AQ.
// ~~~~~~~~~

#define AQ_CTRLFLOWBIT                                                     31:31
#define AQ_CTRLFLOWBIT_End                                                    31
#define AQ_CTRLFLOWBIT_Start                                                  31
#define   AQ_CTRLFLOWBIT_DISABLE                                             0x0
#define   AQ_CTRLFLOWBIT_ENABLE                                              0x1

#define AQ_OPCODE                                                          30:26
#define AQ_OPCODE_End                                                         30
#define AQ_OPCODE_Start                                                       26
#define   AQ_OPCODE_NOP                                                     0x00
#define   AQ_OPCODE_MOV                                                     0x01
#define   AQ_OPCODE_MOVA                                                    0x02
#define   AQ_OPCODE_CMP                                                     0x03
#define   AQ_OPCODE_ADD                                                     0x04
#define   AQ_OPCODE_MAD                                                     0x05
#define   AQ_OPCODE_MUL                                                     0x06
#define   AQ_OPCODE_RCP                                                     0x07
#define   AQ_OPCODE_RSQ                                                     0x08
#define   AQ_OPCODE_DST                                                     0x09
#define   AQ_OPCODE_LITP                                                    0x0A
#define   AQ_OPCODE_DP3                                                     0x0B
#define   AQ_OPCODE_DP4                                                     0x0C
#define   AQ_OPCODE_MIN                                                     0x0D
#define   AQ_OPCODE_MAX                                                     0x0E
#define   AQ_OPCODE_SLT                                                     0x0F
#define   AQ_OPCODE_SGE                                                     0x10
#define   AQ_OPCODE_EXP                                                     0x11
#define   AQ_OPCODE_LOG                                                     0x12
#define   AQ_OPCODE_FRC                                                     0x13
#define   AQ_OPCODE_MAXXYZ                                                  0x14
#define   AQ_OPCODE_TEXLDL                                                  0x14
#define   AQ_OPCODE_TEXKILL                                                 0x15
#define   AQ_OPCODE_TEXLD                                                   0x16
#define   AQ_OPCODE_TEXLDB                                                  0x17
#define   AQ_OPCODE_TEXLDP                                                  0x18
#define   AQ_OPCODE_TEXLDD                                                  0x19
#define   AQ_OPCODE_DSX                                                     0x1A
#define   AQ_OPCODE_DSY                                                     0x1B
#define   AQ_OPCODE_CALL                                                    0x1C
#define   AQ_OPCODE_CALLNZ                                                  0x1D
#define   AQ_OPCODE_RET                                                     0x1E
#define   AQ_OPCODE_LOOP                                                    0x03
#define   AQ_OPCODE_ENDLOOP                                                 0x04
#define   AQ_OPCODE_REP                                                     0x05
#define   AQ_OPCODE_ENDREP                                                  0x06
#define   AQ_OPCODE_IF                                                      0x07
#define   AQ_OPCODE_ELSE                                                    0x08
#define   AQ_OPCODE_ENDIF                                                   0x09
#define   AQ_OPCODE_IFC                                                     0x0A
#define   AQ_OPCODE_BREAK                                                   0x0B
#define   AQ_OPCODE_BREAKP                                                  0x0C
#define   AQ_OPCODE_BREAKC                                                  0x0D
#define   AQ_OPCODE_SETP                                                    0x0E

#define AQ_A0_ROUND                                                        24:24
#define AQ_A0_ROUND_End                                                       24
#define AQ_A0_ROUND_Start                                                     24
#define   AQ_A0_ROUND_DOWN                                                   0x0
#define   AQ_A0_ROUND_UP                                                     0x1

#define AQ_DEST_ADDR_MODE                                                  23:23
#define AQ_DEST_ADDR_MODE_End                                                 23
#define AQ_DEST_ADDR_MODE_Start                                               23

#define AQ_DEST_PRED_ENABLE                                                22:22
#define AQ_DEST_PRED_ENABLE_End                                               22
#define AQ_DEST_PRED_ENABLE_Start                                             22

#define AQ_DESTREG_ADR_LABEL                                               21:13
#define AQ_DESTREG_ADR_LABEL_End                                              21
#define AQ_DESTREG_ADR_LABEL_Start                                            13

#define AQ_DESTMASK                                                         12:9
#define AQ_DESTMASK_End                                                       12
#define AQ_DESTMASK_Start                                                      9

#define AQ_DESTREGTYPE                                                       8:5
#define AQ_DESTREGTYPE_End                                                     8
#define AQ_DESTREGTYPE_Start                                                   5

#define AQ_DEST_MODIFIER_BIT                                                 4:4
#define AQ_DEST_MODIFIER_BIT_End                                               4
#define AQ_DEST_MODIFIER_BIT_Start                                             4
#define   AQ_DEST_MODIFIER_BIT_NONE                                          0x0
#define   AQ_DEST_MODIFIER_BIT_SAT                                           0x1

#define AQ_DEST_PRED_METHOD                                                  3:3
#define AQ_DEST_PRED_METHOD_End                                                3
#define AQ_DEST_PRED_METHOD_Start                                              3

#define AQ_BOOL_METHOD_BIT                                                   2:2
#define AQ_BOOL_METHOD_BIT_End                                                 2
#define AQ_BOOL_METHOD_BIT_Start                                               2

#define AQ_DEST_PRED_SWIZZLE                                                 1:0
#define AQ_DEST_PRED_SWIZZLE_End                                               1
#define AQ_DEST_PRED_SWIZZLE_Start                                             0

////////////////////////////////////////////////////////////////////////////////
//                         ~~~~~~~~~~~~~~~~~~~~~~~~~~~                        //
//                         Command ShaderSourceWord210                        //
//                         ~~~~~~~~~~~~~~~~~~~~~~~~~~~                        //
////////////////////////////////////////////////////////////////////////////////

// Offset AQSrc.
// ~~~~~~~~~~~~

#define AQ_SRC_ADRMODEBIT                                                  31:31
#define AQ_SRC_ADRMODEBIT_End                                                 31
#define AQ_SRC_ADRMODEBIT_Start                                               31
#define   AQ_SRC_ADRMODEBIT_ABSOLUTE                                         0x0
#define   AQ_SRC_ADRMODEBIT_RELATIVE                                         0x1

#define AQ_SRC_TEXLDD_SAMP_NO_LOW                                          30:28
#define AQ_SRC_TEXLDD_SAMP_NO_LOW_End                                         30
#define AQ_SRC_TEXLDD_SAMP_NO_LOW_Start                                       28

#define AQ_SRC_REGADR                                                      27:20
#define AQ_SRC_REGADR_End                                                     27
#define AQ_SRC_REGADR_Start                                                   20

#define AQ_SRC_REGTYPE                                                     19:16
#define AQ_SRC_REGTYPE_End                                                    19
#define AQ_SRC_REGTYPE_Start                                                  16

#define AQ_SRC_WSWIZZLE                                                    15:14
#define AQ_SRC_WSWIZZLE_End                                                   15
#define AQ_SRC_WSWIZZLE_Start                                                 14

#define AQ_SRC_ZSWIZZLE                                                    13:12
#define AQ_SRC_ZSWIZZLE_End                                                   13
#define AQ_SRC_ZSWIZZLE_Start                                                 12

#define AQ_SRC_YSWIZZLE                                                    11:10
#define AQ_SRC_YSWIZZLE_End                                                   11
#define AQ_SRC_YSWIZZLE_Start                                                 10

#define AQ_SRC_XSWIZZLE                                                      9:8
#define AQ_SRC_XSWIZZLE_End                                                    9
#define AQ_SRC_XSWIZZLE_Start                                                  8

#define AQ_SRC_MODIFIER                                                      5:4
#define AQ_SRC_MODIFIER_End                                                    5
#define AQ_SRC_MODIFIER_Start                                                  4
#define   AQ_SRC_MODIFIER_NONE                                               0x0
#define   AQ_SRC_MODIFIER_NEG                                                0x1
#define   AQ_SRC_MODIFIER_ABS                                                0x2

#define AQ_SRC_AL_BIT                                                        3:3
#define AQ_SRC_AL_BIT_End                                                      3
#define AQ_SRC_AL_BIT_Start                                                    3
#define   AQ_SRC_AL_BIT_A0                                                   0x0
#define   AQ_SRC_AL_BIT_AL                                                   0x1

#define AQ_SRC_A0_SWIZZLE                                                    2:1
#define AQ_SRC_A0_SWIZZLE_End                                                  2
#define AQ_SRC_A0_SWIZZLE_Start                                                1

#define AQ_SRC_TEXLDD_SAMP_NO_HIGH                                           0:0
#define AQ_SRC_TEXLDD_SAMP_NO_HIGH_End                                         0
#define AQ_SRC_TEXLDD_SAMP_NO_HIGH_Start                                       0

////////////////////////////////////////////////////////////////////////////////
//                         ~~~~~~~~~~~~~~~~~~~~~~~~~~~                        //
//                         Command ShaderSourceSwizzle                        //
//                         ~~~~~~~~~~~~~~~~~~~~~~~~~~~                        //
////////////////////////////////////////////////////////////////////////////////

// Offset ShaderSrc.
// ~~~~~~~~~~~~~~~~

#define SHADER_SRC_SWIZZLE                                                   1:0
#define SHADER_SRC_SWIZZLE_End                                                 1
#define SHADER_SRC_SWIZZLE_Start                                               0
#define   SHADER_SRC_SWIZZLE_X                                               0x0
#define   SHADER_SRC_SWIZZLE_Y                                               0x1
#define   SHADER_SRC_SWIZZLE_Z                                               0x2
#define   SHADER_SRC_SWIZZLE_W                                               0x3

////////////////////////////////////////////////////////////////////////////////
//                         ~~~~~~~~~~~~~~~~~~~~~~~~~~                         //
//                         Command ShaderRegisterType                         //
//                         ~~~~~~~~~~~~~~~~~~~~~~~~~~                         //
////////////////////////////////////////////////////////////////////////////////

// Offset SrcDest.
// ~~~~~~~~~~~~~~

#define SRC_DEST_REG                                                         3:0
#define SRC_DEST_REG_End                                                       3
#define SRC_DEST_REG_Start                                                     0
#define   SRC_DEST_REG_COLOROUT                                              0x0
#define   SRC_DEST_REG_DEPTHOUT                                              0x1
#define   SRC_DEST_REG_TEMP                                                  0x2
#define   SRC_DEST_REG_INPUT                                                 0x3
#define   SRC_DEST_REG_INTEGER                                               0x4
#define   SRC_DEST_REG_CONST                                                 0x5
#define   SRC_DEST_REG_TEXTURE                                               0x6
#define   SRC_DEST_REG_ADDR                                                  0x6
#define   SRC_DEST_REG_RASTOUT                                               0x7
#define   SRC_DEST_REG_POSITION                                              0x7
#define   SRC_DEST_REG_ATTROUT                                               0x8
#define   SRC_DEST_REG_FACE                                                  0x8
#define   SRC_DEST_REG_TEXCRDOUT                                             0x9
#define   SRC_DEST_REG_PRED                                                  0x9
#define   SRC_DEST_REG_SAMPLER                                               0xA
#define   SRC_DEST_REG_BOOL                                                  0xB
#define   SRC_DEST_REG_VS_OUTPUT                                             0xC

////////////////////////////////////////////////////////////////////////////////
//                      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                      //
//                      Command AQShaderInstructionWord0                      //
//                      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                      //
////////////////////////////////////////////////////////////////////////////////

// Offset AQ_INST.
// ~~~~~~~~~~~~~~

#define AQ_INST_OP_CODE                                                      5:0
#define AQ_INST_OP_CODE_End                                                    5
#define AQ_INST_OP_CODE_Start                                                  0
#define   AQ_INST_OP_CODE_NOP                                               0x00
#define   AQ_INST_OP_CODE_ADD                                               0x01
#define   AQ_INST_OP_CODE_MAD                                               0x02
#define   AQ_INST_OP_CODE_MUL                                               0x03
#define   AQ_INST_OP_CODE_DST                                               0x04
#define   AQ_INST_OP_CODE_DP3                                               0x05
#define   AQ_INST_OP_CODE_DP4                                               0x06
#define   AQ_INST_OP_CODE_DSX                                               0x07
#define   AQ_INST_OP_CODE_DSY                                               0x08
#define   AQ_INST_OP_CODE_MOV                                               0x09
#define   AQ_INST_OP_CODE_MOVAR                                             0x0A
#define   AQ_INST_OP_CODE_MOVAF                                             0x0B
#define   AQ_INST_OP_CODE_RCP                                               0x0C
#define   AQ_INST_OP_CODE_RSQ                                               0x0D
#define   AQ_INST_OP_CODE_LITP                                              0x0E
#define   AQ_INST_OP_CODE_SELECT                                            0x0F
#define   AQ_INST_OP_CODE_SET                                               0x10
#define   AQ_INST_OP_CODE_EXP                                               0x11
#define   AQ_INST_OP_CODE_LOG                                               0x12
#define   AQ_INST_OP_CODE_FRC                                               0x13
#define   AQ_INST_OP_CODE_CALL                                              0x14
#define   AQ_INST_OP_CODE_RET                                               0x15
#define   AQ_INST_OP_CODE_BRANCH                                            0x16
#define   AQ_INST_OP_CODE_TEXKILL                                           0x17
#define   AQ_INST_OP_CODE_TEXLD                                             0x18
#define   AQ_INST_OP_CODE_TEXLDB                                            0x19
#define   AQ_INST_OP_CODE_TEXLDD                                            0x1A
#define   AQ_INST_OP_CODE_TEXLDL                                            0x1B
#define   AQ_INST_OP_CODE_TEXLDP                                            0x1C
#define   AQ_INST_OP_CODE_TEXLDPCF                                          0x1C
#define   AQ_INST_OP_CODE_REP                                               0x1D
#define   AQ_INST_OP_CODE_ENDREP                                            0x1E
#define   AQ_INST_OP_CODE_LOOP                                              0x1F
#define   AQ_INST_OP_CODE_ENDLOOP                                           0x20

#define AQ_INST_CONDITION_CODE                                               9:6
#define AQ_INST_CONDITION_CODE_End                                             9
#define AQ_INST_CONDITION_CODE_Start                                           6
#define   AQ_INST_CONDITION_CODE_TRUE                                        0x0
#define   AQ_INST_CONDITION_CODE_GT                                          0x1
#define   AQ_INST_CONDITION_CODE_LT                                          0x2
#define   AQ_INST_CONDITION_CODE_GE                                          0x3
#define   AQ_INST_CONDITION_CODE_LE                                          0x4
#define   AQ_INST_CONDITION_CODE_EQ                                          0x5
#define   AQ_INST_CONDITION_CODE_NE                                          0x6
#define   AQ_INST_CONDITION_CODE_AND                                         0x7
#define   AQ_INST_CONDITION_CODE_OR                                          0x8
#define   AQ_INST_CONDITION_CODE_XOR                                         0x9
#define   AQ_INST_CONDITION_CODE_NOT                                         0xA
#define   AQ_INST_CONDITION_CODE_NZ                                          0xB
#define   AQ_INST_CONDITION_CODE_GEZ                                         0xC
#define   AQ_INST_CONDITION_CODE_GZ                                          0xD
#define   AQ_INST_CONDITION_CODE_LEZ                                         0xE
#define   AQ_INST_CONDITION_CODE_LZ                                          0xF

#define AQ_INST_SATURATE                                                   11:11
#define AQ_INST_SATURATE_End                                                  11
#define AQ_INST_SATURATE_Start                                                11
#define   AQ_INST_SATURATE_NONE                                              0x0
#define   AQ_INST_SATURATE_ZERO_TO_ONE                                       0x1

#define AQ_INST_DEST_VALID                                                 12:12
#define AQ_INST_DEST_VALID_End                                                12
#define AQ_INST_DEST_VALID_Start                                              12

#define AQ_INST_DEST_REL_ADR                                               15:13
#define AQ_INST_DEST_REL_ADR_End                                              15
#define AQ_INST_DEST_REL_ADR_Start                                            13

#define AQ_INST_DEST_ADR                                                   20:16
#define AQ_INST_DEST_ADR_End                                                  20
#define AQ_INST_DEST_ADR_Start                                                16

#define AQ_INST_DEST_WRITE_ENABLE                                          26:23
#define AQ_INST_DEST_WRITE_ENABLE_End                                         26
#define AQ_INST_DEST_WRITE_ENABLE_Start                                       23

#define AQ_INST_SAMPLER_NUM                                                30:27
#define AQ_INST_SAMPLER_NUM_End                                               30
#define AQ_INST_SAMPLER_NUM_Start                                             27

////////////////////////////////////////////////////////////////////////////////
//                      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                      //
//                      Command AQShaderInstructionWord1                      //
//                      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                      //
////////////////////////////////////////////////////////////////////////////////

// Offset AQ_INST.
// ~~~~~~~~~~~~~~

#define AQ_INST_SAMPLER_REL_ADR                                              2:0
#define AQ_INST_SAMPLER_REL_ADR_End                                            2
#define AQ_INST_SAMPLER_REL_ADR_Start                                          0

#define AQ_INST_SAMPLER_SWIZZLE                                             10:3
#define AQ_INST_SAMPLER_SWIZZLE_End                                           10
#define AQ_INST_SAMPLER_SWIZZLE_Start                                          3

#define AQ_INST_SRC0_VALID                                                 11:11
#define AQ_INST_SRC0_VALID_End                                                11
#define AQ_INST_SRC0_VALID_Start                                              11

#define AQ_INST_SRC0_ADR                                                   19:12
#define AQ_INST_SRC0_ADR_End                                                  19
#define AQ_INST_SRC0_ADR_Start                                                12

#define AQ_INST_SRC0_SWIZZLE                                               29:22
#define AQ_INST_SRC0_SWIZZLE_End                                              29
#define AQ_INST_SRC0_SWIZZLE_Start                                            22

#define AQ_INST_SRC0_MODIFIER_NEG                                          30:30
#define AQ_INST_SRC0_MODIFIER_NEG_End                                         30
#define AQ_INST_SRC0_MODIFIER_NEG_Start                                       30

#define AQ_INST_SRC0_MODIFIER_ABS                                          31:31
#define AQ_INST_SRC0_MODIFIER_ABS_End                                         31
#define AQ_INST_SRC0_MODIFIER_ABS_Start                                       31

////////////////////////////////////////////////////////////////////////////////
//                      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                      //
//                      Command AQShaderInstructionWord2                      //
//                      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                      //
////////////////////////////////////////////////////////////////////////////////

// Offset AQ_INST.
// ~~~~~~~~~~~~~~

#define AQ_INST_SRC0_REL_ADR                                                 2:0
#define AQ_INST_SRC0_REL_ADR_End                                               2
#define AQ_INST_SRC0_REL_ADR_Start                                             0

#define AQ_INST_SRC0_TYPE                                                    4:3
#define AQ_INST_SRC0_TYPE_End                                                  4
#define AQ_INST_SRC0_TYPE_Start                                                3

#define AQ_INST_SRC1_VALID                                                   6:6
#define AQ_INST_SRC1_VALID_End                                                 6
#define AQ_INST_SRC1_VALID_Start                                               6

#define AQ_INST_SRC1_ADR                                                    14:7
#define AQ_INST_SRC1_ADR_End                                                  14
#define AQ_INST_SRC1_ADR_Start                                                 7

#define AQ_INST_SRC1_SWIZZLE                                               24:17
#define AQ_INST_SRC1_SWIZZLE_End                                              24
#define AQ_INST_SRC1_SWIZZLE_Start                                            17

#define AQ_INST_SRC1_MODIFIER_NEG                                          25:25
#define AQ_INST_SRC1_MODIFIER_NEG_End                                         25
#define AQ_INST_SRC1_MODIFIER_NEG_Start                                       25

#define AQ_INST_SRC1_MODIFIER_ABS                                          26:26
#define AQ_INST_SRC1_MODIFIER_ABS_End                                         26
#define AQ_INST_SRC1_MODIFIER_ABS_Start                                       26

#define AQ_INST_SRC1_REL_ADR                                               29:27
#define AQ_INST_SRC1_REL_ADR_End                                              29
#define AQ_INST_SRC1_REL_ADR_Start                                            27

////////////////////////////////////////////////////////////////////////////////
//                      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                      //
//                      Command AQShaderInstructionWord3                      //
//                      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                      //
////////////////////////////////////////////////////////////////////////////////

// Offset AQ_INST.
// ~~~~~~~~~~~~~~

#define AQ_INST_SRC1_TYPE                                                    1:0
#define AQ_INST_SRC1_TYPE_End                                                  1
#define AQ_INST_SRC1_TYPE_Start                                                0

#define AQ_INST_SRC2_VALID                                                   3:3
#define AQ_INST_SRC2_VALID_End                                                 3
#define AQ_INST_SRC2_VALID_Start                                               3

#define AQ_INST_SRC2_ADR                                                    11:4
#define AQ_INST_SRC2_ADR_End                                                  11
#define AQ_INST_SRC2_ADR_Start                                                 4

#define AQ_INST_SRC2_SWIZZLE                                               21:14
#define AQ_INST_SRC2_SWIZZLE_End                                              21
#define AQ_INST_SRC2_SWIZZLE_Start                                            14

#define AQ_INST_SRC2_MODIFIER_NEG                                          22:22
#define AQ_INST_SRC2_MODIFIER_NEG_End                                         22
#define AQ_INST_SRC2_MODIFIER_NEG_Start                                       22

#define AQ_INST_SRC2_MODIFIER_ABS                                          23:23
#define AQ_INST_SRC2_MODIFIER_ABS_End                                         23
#define AQ_INST_SRC2_MODIFIER_ABS_Start                                       23

#define AQ_INST_SRC2_REL_ADR                                               27:25
#define AQ_INST_SRC2_REL_ADR_End                                              27
#define AQ_INST_SRC2_REL_ADR_Start                                            25

#define AQ_INST_SRC2_TYPE                                                  29:28
#define AQ_INST_SRC2_TYPE_End                                                 29
#define AQ_INST_SRC2_TYPE_Start                                               28

////////////////////////////////////////////////////////////////////////////////
//                 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                //
//                 Command AQShaderInstructionFlowControlWord3                //
//                 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                //
////////////////////////////////////////////////////////////////////////////////

// Offset AQ_INST.
// ~~~~~~~~~~~~~~

#define AQ_INST_SRC1_TYPE                                                    1:0
#define AQ_INST_SRC1_TYPE_End                                                  1
#define AQ_INST_SRC1_TYPE_Start                                                0

#define AQ_INST_SRC2_VALID                                                   3:3
#define AQ_INST_SRC2_VALID_End                                                 3
#define AQ_INST_SRC2_VALID_Start                                               3

#define AQ_INST_LOOP_OP                                                      4:4
#define AQ_INST_LOOP_OP_End                                                    4
#define AQ_INST_LOOP_OP_Start                                                  4
#define   AQ_INST_LOOP_OP_NONE                                               0x0
#define   AQ_INST_LOOP_OP_DEALLOCATE_ON_FALSE                                0x1

#define AQ_INST_TARGET                                                      15:7
#define AQ_INST_TARGET_End                                                    15
#define AQ_INST_TARGET_Start                                                   7

////////////////////////////////////////////////////////////////////////////////
//                        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~                        //
//                        Command AQShaderRegisterType                        //
//                        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~                        //
////////////////////////////////////////////////////////////////////////////////

// Offset AQShaderSrc.
// ~~~~~~~~~~~~~~~~~~

#define AQ_SHADER_SRC_REG_TYPE                                               1:0
#define AQ_SHADER_SRC_REG_TYPE_End                                             1
#define AQ_SHADER_SRC_REG_TYPE_Start                                           0
#define   AQ_SHADER_SRC_REG_TYPE_TEMP                                        0x0
#define   AQ_SHADER_SRC_REG_TYPE_FACE                                        0x1
#define   AQ_SHADER_SRC_REG_TYPE_UNBOUNDED_CONST                             0x2
#define   AQ_SHADER_SRC_REG_TYPE_BOUNDED_CONST                               0x3

////////////////////////////////////////////////////////////////////////////////
//                        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                       //
//                        Command AQShaderSourceSwizzle                       //
//                        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                       //
////////////////////////////////////////////////////////////////////////////////

// Offset AQShaderSrc.
// ~~~~~~~~~~~~~~~~~~

#define AQ_SHADER_SRC_XSWIZZLE                                               1:0
#define AQ_SHADER_SRC_XSWIZZLE_End                                             1
#define AQ_SHADER_SRC_XSWIZZLE_Start                                           0

#define AQ_SHADER_SRC_YSWIZZLE                                               3:2
#define AQ_SHADER_SRC_YSWIZZLE_End                                             3
#define AQ_SHADER_SRC_YSWIZZLE_Start                                           2

#define AQ_SHADER_SRC_ZSWIZZLE                                               5:4
#define AQ_SHADER_SRC_ZSWIZZLE_End                                             5
#define AQ_SHADER_SRC_ZSWIZZLE_Start                                           4

#define AQ_SHADER_SRC_WSWIZZLE                                               7:6
#define AQ_SHADER_SRC_WSWIZZLE_End                                             7
#define AQ_SHADER_SRC_WSWIZZLE_Start                                           6

////////////////////////////////////////////////////////////////////////////////
//                     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                     //
//                     Command AQShaderRelativeAddressing                     //
//                     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                     //
////////////////////////////////////////////////////////////////////////////////

// Offset AQShader.
// ~~~~~~~~~~~~~~~

#define AQ_SHADER_REL_ADR                                                    2:0
#define AQ_SHADER_REL_ADR_End                                                  2
#define AQ_SHADER_REL_ADR_Start                                                0
#define   AQ_SHADER_REL_ADR_NONE                                             0x0
#define   AQ_SHADER_REL_ADR_A0_X                                             0x1
#define   AQ_SHADER_REL_ADR_A0_Y                                             0x2
#define   AQ_SHADER_REL_ADR_A0_Z                                             0x3
#define   AQ_SHADER_REL_ADR_A0_W                                             0x4
#define   AQ_SHADER_REL_ADR_AL                                               0x5

////////////////////////////////////////////////////////////////////////////////
//                            ~~~~~~~~~~~~~~~~~~~~                            //
//                            Command AQShaderLoop                            //
//                            ~~~~~~~~~~~~~~~~~~~~                            //
////////////////////////////////////////////////////////////////////////////////

// Offset AQShaderLoop.
// ~~~~~~~~~~~~~~~~~~~

#define AQ_SHADER_LOOP_COUNT                                                 8:0
#define AQ_SHADER_LOOP_COUNT_End                                               8
#define AQ_SHADER_LOOP_COUNT_Start                                             0

#define AQ_SHADER_LOOP_INITIAL                                             18:10
#define AQ_SHADER_LOOP_INITIAL_End                                            18
#define AQ_SHADER_LOOP_INITIAL_Start                                          10

#define AQ_SHADER_LOOP_STEP                                                30:21
#define AQ_SHADER_LOOP_STEP_End                                               30
#define AQ_SHADER_LOOP_STEP_Start                                             21

