#include <pmon.h>
#include <cpu.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <linux/types.h>
#define udelay delay
#define ac97_base 0xbfe74000  // 0xbfe74000
#define confreg_base 0xbfd00000
#define dma_base  0xbfe74080  //0xbf004280
#define ac97_reg_write(addr, val) do{ *(volatile u32 *)(ac97_base+(addr))=val; }while(0)
#define ac97_reg_read(addr) *(volatile u32 * )(ac97_base+(addr))
//#define udelay(n)   
#define dma_reg_write(addr, val) do{ *(volatile u32 *)(dma_base+(addr))=val; }while(0)
//#define dma_reg_read(addr) *(volatile u32 * )(dma_base+(addr))
#define dma_reg_read(addr) *(volatile u32 *)(addr)
#define codec_wait(n) do{ int __i=n;\
        while (__i-->0){ \
            if ((ac97_reg_read(0x54) & 0x3) != 0) break;\
            udelay(1000); }\
            if (__i>0){ \
                ac97_reg_read(0x6c);\
                ac97_reg_read(0x68);\
            }\
        }while (0)

//yq:0x70-->0x68
        
#define DMA_BUF	0x00800000
#define BUF_SIZE	0x200000        //2MB
//#define  BUF_SIZE 0x7000
#define SYNC_W 1    //sync cache for writing data
#define CPU2FIFO 1

#define AC97_RECORD 0
#define AC97_PLAY   1

#define REC_DMA_BUF		(DMA_BUF+ BUF_SIZE)        //0x00a00000
#define REC_BUF_SIZE		(BUF_SIZE>>1)

#ifdef DEBUG
#undef TR
#define TR0(fmt, args...) printf("SynopGMAC: " fmt, ##args)
#define TR(fmt, args...) printf("SynopGMAC: " fmt, ##args)
#else
#define TR0(fmt, args...)
#define TR(fmt, args...) // not debugging: nothing
#endif

static unsigned short sample_rate=0xac44;

static int ac97_rw=0;

static struct desc{
	u32 ordered;		//下一个描述符地址寄存器
	u32 saddr;			//内存地址寄存器
	u32 daddr;			//设备地址寄存器
	u32 length;		//长度寄存器
	u32 step_length;	//间隔长度寄存器
	u32 step_times;	//循环次数寄存器
	u32 cmd;			//控制寄存器
};


static struct desc *DMA_DESC_BASE;
static struct desc *dma_desc2_addr;

static u32 play_desc1[7]={
	0x1,                       //need to be filled
	DMA_BUF & 0x1fffffff,     
	0xdfe72420,                //(ac97_base&0x9fffffff)+0x20,           //9fffffff?fun
	0x8,
	0x0,
	(BUF_SIZE/8/4),
	0x00001001
};

static u32 play_desc2[7]={
	0x00001,
	DMA_BUF & 0x1fffffff,
	0xdfe72420,                                //( ac97_base&0x9fffffff)+0x20,
	0x6,
	0x0,
	(BUF_SIZE/8/6/2),
	0x00001001	
};

static u32 rec_desc1[7]={
	0x1,                       //need to be filled
	(REC_DMA_BUF|0xa0000000)&0x1fffffff,                    //(ac97_base&0x9fffffff)+0x20,           //9fffffff?func
	0x9fe74c4c,
	0x8,
	0x0,
	(BUF_SIZE/8/4),
	0x00000001
};

static u32 rec_desc2[7]={
	0x1,                       //need to be filled
	(REC_DMA_BUF|0xa0000000)&0x1fffffff,                    //(ac97_base&0x9fffffff)+0x20,      //9fffffff?func
	0x9fe74c4c,
	0x6,
	0x0,
	(BUF_SIZE/8/6/2),
	0x00000001
};

void  init_audio_data(void)
{
	unsigned int *data = (unsigned int*)(DMA_BUF|0xa0000000);
	int i;

	for (i=0; i<((BUF_SIZE)>>3); i++){
		data[i*2] = 0x7fffe000;
		data[i*2+1] = 0x1f2e3d4c;
	}

	for(i=0; i<40; i++){
		TR("%x:  data:%x\n",((DMA_BUF|0xa0000000)+(i*4)),*(volatile unsigned int *)(DMA_BUF|0xa0000000+(i*4)));
	}
	TR("===init audio data complete\n");
}
 
int ac97_config(void)
{
	int i=0;
	int codec_id;
#ifdef CONFIG_CHINESE
	printf("配置 ac97 编解码器\n");
#else
	printf("config ac97 codec\n");
#endif
	
	/* 必须执行？？ AC97 codec冷启动 */
	for(i=0;i<100000;i++) *(volatile unsigned char *)0xbfe74000 |= 1;
	
	/* 输出通道配置寄存器 */
	ac97_reg_write(0x4, 0x6969);
	TR("OCCR0 complete:%x\n",ac97_reg_read(0x4));
	/* 输入通道配置寄存器 */
	ac97_reg_write(0x10,0x690001);
	TR("ICCR complete\n");
	ac97_reg_write(0x58,0x0); //INTM
	TR("INTM complete\n");
	
	/* codec reset */
	ac97_reg_write(0x18,0x0|(0x0<<16)|(0<<31));
	codec_wait(10000);

	/* 读取0x7c寄存器地址的值 参考ALC203数据手册 */
	ac97_reg_write(0x18,0|(0x7c<<16)|(1<<31));
	codec_wait(10000);
	codec_id = ac97_reg_read(0x18)&0xffff;
	ac97_reg_write(0x18,0|(0x7e<<16)|(1<<31));
	codec_wait(10000);
	codec_id = (codec_id<<16) | (ac97_reg_read(0x18)&0xffff);
#ifdef CONFIG_CHINESE
	printf("编解码器ID： %x \n", codec_id); //read ID
#else
	printf("codec ID :%x \n", codec_id); //read ID
#endif
	
	if (codec_id == 0x414c4760){
		/* 输出通道配置寄存器 */
		ac97_reg_write(0x4, 0x6969);
		TR("OCCR0 complete:%x\n",ac97_reg_read(0x4));
		/* 输入通道配置寄存器 */
		ac97_reg_write(0x10,0x690001);
		TR("ICCR complete\n");
		
		ac97_reg_write(0x18,0x201|(0x6a<<16)|(0<<31));
		codec_wait(10000);
		ac97_reg_write(0x18,0x0808|(0x38<<16)|(0<<31));
		codec_wait(10000);
		ac97_reg_write(0x18,0x0e|(0x66<<16)|(0<<31));
		codec_wait(10000);
	}
	else{
		/* 输出通道配置寄存器 */
		ac97_reg_write(0x4, 0x6b6b);
		TR("OCCR0 complete:%x\n",ac97_reg_read(0x4));
		/* 输入通道配置寄存器 */
		ac97_reg_write(0x10,0x6b0001);
		TR("ICCR complete\n");
	}
	
	/* ALC655 需要设置该寄存器 */
	ac97_reg_write(0x18,0x0f0f|(0x1c<<16)|(0<<31));
	codec_wait(10000);
	/* line in */
	ac97_reg_write(0x18,0x0101|(0x10<<16)|(0<<31));
	codec_wait(10000);
	
	for(i=5;i>0;i--){
		ac97_reg_write(0x18,0x0|(0x26<<16)|(1<<31));
		codec_wait(10000);
		TR("===D/A status:%x\n",ac97_reg_read(0x18)&0xffffffff);
	}
	//设置音量
	ac97_reg_write(0x18,0x0808|(0x2<<16)|(0<<31));      //Master Volume. data=0x0808
	TR("register 0x18 Master Volume.content2:%x\n",ac97_reg_read(0x18));
	codec_wait(10000);
	ac97_reg_write(0x18,0x0808|(0x4<<16)|(0<<31));      //headphone Vol.
	codec_wait(10000);
	ac97_reg_write(0x18,0x0008|(0x6<<16)|(0<<31));      //headphone Vol.
	codec_wait(10000);
	ac97_reg_write(0x18,0x0008|(0xc<<16)|(0<<31));      //phone Vol.
	codec_wait(10000);
	ac97_reg_write(0x18,0x0808|(0x18<<16)|(0<<31));     //PCM Out Vol.
	codec_wait(10000);
	ac97_reg_write(0x18,0x1|(0x2A<<16)|(0<<31));        //Extended Audio Status  and control
	codec_wait(10000);
	ac97_reg_write(0x18,sample_rate|(0x2c<<16)|(0<<31));     //PCM Out Vol. FIXME:22k can play 44k wav data?
	codec_wait(10000);
	/* record设置录音寄存器 */
	if (ac97_rw==AC97_RECORD){
		TR("===record config\n");
		ac97_reg_write(0x18,sample_rate|(0x32<<16)|(0<<31));     //ADC rate .
		codec_wait(10000);
		ac97_reg_write(0x18,0x035f|(0x0E<<16)|(0<<31));     //Mic vol .
		codec_wait(10000);
		ac97_reg_write(0x18,0x0f0f|(0x1E<<16)|(0<<31));     //MIC Gain ADC.
		codec_wait(10000);
		ac97_reg_write(0x18,sample_rate|(0x34<<16)|(0<<31));     //MIC rate.
		codec_wait(10000);
	}
#ifdef CONFIG_CHINESE
	printf("配置完毕\n");
#else
	printf("config done\n");
#endif
	return 0;
}

void dma_config(void)
{
	u32 addr;
	u32 addr2;

	DMA_DESC_BASE = (struct desc*)malloc(sizeof(struct desc) + 32);
	addr = DMA_DESC_BASE = ((u32)DMA_DESC_BASE+31) & (~31);
	TR("===addr:%x\n",DMA_DESC_BASE);

	dma_desc2_addr = (struct desc*)malloc(sizeof(struct desc) + 32);
	addr2 = dma_desc2_addr = ((u32)dma_desc2_addr+31) & (~31);
	TR("===addr2:%x\n",dma_desc2_addr);
	
	/* play */
	if (AC97_PLAY == ac97_rw) {
		DMA_DESC_BASE->ordered = play_desc1[0] | (addr & 0x1fffffff);    ///addr&0xffffffe0;
		DMA_DESC_BASE->saddr = play_desc1[1];   //0x00010000;//addr&0x1fffffff;
		DMA_DESC_BASE->daddr = play_desc1[2];
		DMA_DESC_BASE->length = play_desc1[3];
		DMA_DESC_BASE->step_length = play_desc1[4];
		DMA_DESC_BASE->step_times = play_desc1[5];
		DMA_DESC_BASE->cmd = play_desc1[6];
		pci_sync_cache(0, (unsigned long)addr, 32*7, SYNC_W);
		TR("===play1\n");
		TR("===desc1:%x;%x,%x,%x,%x\n",DMA_DESC_BASE->ordered,DMA_DESC_BASE->saddr,DMA_DESC_BASE->daddr,DMA_DESC_BASE->length,DMA_DESC_BASE->step_times);	 
		TR("===mem desc:%x,%x\n",*(volatile unsigned int*)(addr),*(volatile unsigned int*)(addr+4));
		
		dma_desc2_addr->ordered = play_desc2[0] | (addr2 & 0x1fffffff);
		dma_desc2_addr->saddr = play_desc2[1];//0x00001000;//addr2&0x1fffffff;                     //play_desc2[1];
		dma_desc2_addr->daddr = play_desc2[2];
		dma_desc2_addr->length = play_desc2[3];
		dma_desc2_addr->step_length = play_desc2[4];
		dma_desc2_addr->step_times = play_desc2[5];
		dma_desc2_addr->cmd = play_desc2[6];
		pci_sync_cache(0, (unsigned long)addr2, 32*7, SYNC_W);
		TR("===play2");
		TR("===desc2:%x\n", dma_desc2_addr->ordered);
    
		addr = (u32)(addr & 0x1fffffff);

		TR("===addr:%x\n",addr);
		TR("===addr':%x",addr|0x00000009);
		do{
			*(volatile u32*)(confreg_base+0x1160) = addr|0x00000009;
			delay(1000);
			TR("dma register:%x\n",(*(volatile u32*)(confreg_base+0x1160)));
		}while(0);
	}
	/* record 记录 */
	else{
		DMA_DESC_BASE->ordered = rec_desc1[0] | (addr & 0x1fffffff);    ///addr&0xffffffe0;
		DMA_DESC_BASE->saddr = rec_desc1[1];   //0x00010000;//addr&0x1fffffff;
		DMA_DESC_BASE->daddr = rec_desc1[2];
		DMA_DESC_BASE->length = rec_desc1[3];
		DMA_DESC_BASE->step_length = rec_desc1[4];
		DMA_DESC_BASE->step_times = rec_desc1[5];
		DMA_DESC_BASE->cmd = rec_desc1[6];
		TR("========rec1\n");
		pci_sync_cache(0, (unsigned long)addr, 32*7, SYNC_W);

		TR("====rec desc:%x;%x,%x,%x,%x\n",DMA_DESC_BASE->ordered,DMA_DESC_BASE->saddr,DMA_DESC_BASE->daddr,DMA_DESC_BASE->length,DMA_DESC_BASE->step_times);	 
		dma_desc2_addr->ordered = rec_desc2[0] | (addr2 & 0x1fffffff);
		dma_desc2_addr->saddr = rec_desc2[1];//0x00001000;//addr2&0x1fffffff;                     //play_desc2[1];
		dma_desc2_addr->daddr = rec_desc2[2];
		dma_desc2_addr->length = rec_desc2[3];
		dma_desc2_addr->step_length = rec_desc2[4];
		dma_desc2_addr->step_times = rec_desc2[5];
		dma_desc2_addr->cmd = rec_desc2[6];
		pci_sync_cache(0, (unsigned long)addr2, 32*7, SYNC_W);
		TR("===rec2");
		TR("====desc2:%x\n", dma_desc2_addr->ordered);

		addr=(u32)(addr&0x1fffffff);    
		TR("====addr:%x\n",addr);
		TR("====addr':%x",addr|0x0000000a);
		do{
			*(volatile u32*)(confreg_base+0x1160) = addr|0x0000000a;
			delay(1000);	
			TR("dma register:%x\n",(*(volatile u32*)(confreg_base+0x1160)));
		}while(0);
	}
}

/*
void dma_setup_trans(u32 * src_addr,u32 size)
{
	// play
	if (AC97_PLAY==ac97_rw){
		dma_reg_write(0x0,src_addr);
		dma_reg_write(0x4,size>>2);
	}
	//record
	else{
		dma_reg_write(0x10,src_addr);
		dma_reg_write(0x14,size>>2);
	}
}
*/

/* 测试录音结果 */
int ac97_test(int argc,char **argv)
{
	char cmdbuf[100];
	int i;

	if(argc!=2 && argc!=1)return -1;
	if(argc==2){
		sprintf(cmdbuf,"load -o 0x%x -r %s",DMA_BUF|0xa0000000,argv[1]);
		do_cmd(cmdbuf);
	}
	ac97_rw = AC97_PLAY;

#ifdef CONFIG_CHINESE
	printf("开始放音：注意听是否跟所录声音一致\n");
#else
	printf("begin test\n");
#endif
	
	/* 需要配置DMA */
	dma_config();
	TR("play data on 0x%x, sz=0x%x\n", (DMA_BUF|0xa0000000), BUF_SIZE);
	*(volatile u32*)(confreg_base+0x1160) = 0x00200005;
	TR("dma state1:%x\n%x\n%x\n%x\n%x\n", dma_reg_read(0xa0200004), dma_reg_read(0xa0200008), dma_reg_read(0xa020000c), dma_reg_read(0xa0200014), dma_reg_read(0xa0200018));
	*(volatile u32*)(confreg_base+0x1160) = 0x00200005;
	TR("dma state2:%x\n%x\n%x\n%x\n%x\n", dma_reg_read(0xa0200004), dma_reg_read(0xa0200008), dma_reg_read(0xa020000c), dma_reg_read(0xa0200014), dma_reg_read(0xa0200018));

	//1.wait a trans complete
//	while(((dma_reg_read(0x2c))&0x1)==0)
//	idle();

	//2.clear int status  bit.
//	dma_reg_write(0x2c,0x1);
	/* 等待 录音时间 */
	for(i=0; i<8; i++){
		udelay(1000000);
		printf("."); 
	}
	/* codec reset 复位AC97 codec */
	ac97_reg_write(0x18,0x0|(0x0<<16)|(0<<31));
	codec_wait(10000);
#ifdef CONFIG_CHINESE
	printf("放音结束\n");
#else
	printf("test done\n");
#endif
	return 0;
}

/* 把codec 输入的数据通过DMA传输到内存 */
int ac97_read(int argc,char **argv)
{
	int i;
	unsigned int j;
	unsigned short * rec_buff;
	unsigned int  *  ply_buff;
	ac97_rw = AC97_RECORD;

	init_audio_data();

	/*1.dma_config read*/
	dma_config();
	
	/*2.ac97 config read*/
	ac97_config();

	/*3.set dma desc*/
#ifdef CONFIG_CHINESE
	printf("请用麦克风录一段音 ");
#else
	printf("please speck to microphone ");
#endif
	for(i=0;i<8;i++){
		udelay(1000000);
		printf("."); 
	}
#ifdef CONFIG_CHINESE
	printf("录音结束\n");
#else
	printf("rec done\n");
#endif
	
	/* 0xbfd01160 DMA模块控制寄存器位 */
	*(volatile u32*)(confreg_base + 0x1160) = 0x00200006;
	TR("dma state1:%x\n%x\n%x\n%x\n%x\n",dma_reg_read(0xa0200004),dma_reg_read(0xa0200008),dma_reg_read(0xa020000c),dma_reg_read(0xa0200014),dma_reg_read(0xa0200018));
//	dma_setup_trans(REC_DMA_BUF,REC_BUF_SIZE);

	/*4.wait dma done,return*/ 
//	while(((dma_reg_read(0x2c))&0x8)==0)
//		udelay(1000);//1 ms 
//	dma_reg_write(0x2c,0x8);
	
	/*5.transform single channel to double channel*/
	rec_buff = (unsigned short *)(REC_DMA_BUF | 0xa0000000);
	ply_buff = (unsigned int *)(DMA_BUF | 0xa0000000);

	for(i=0; i<(REC_BUF_SIZE<<1); i++){
		j = 0x0000ffff & (unsigned int) rec_buff[i];
		ply_buff[i] = (j<<16)|(j);
	}

	return 0;
}

static const Cmd Cmds[] =
{
	{"MyCmds"},
	{"ac97_test","file",0,"ac97_test file",ac97_test,0,99,CMD_REPEAT},
	{"ac97_read","",0,"ac97_read",ac97_read,0,99,CMD_REPEAT},
	{"ac97_config","",0,"ac97_config",ac97_config,0,99,CMD_REPEAT},
	{0, 0}
};

static void init_cmd __P((void)) __attribute__ ((constructor));

static void
init_cmd()
{
	cmdlist_expand(Cmds, 1);
}

