/*
 * Bonito Register Map 
 * Copyright (c) 1999 Algorithmics Ltd
 *
 * Algorithmics gives permission for anyone to use and modify this file
 * without any obligation or license condition except that you retain
 * this copyright message in any source redistribution in whole or part.
 *
 * Updated copies of this and other files can be found at
 * ftp://ftp.algor.co.uk/pub/bonito/
 * 
 * Users of the Bonito controller are warmly recommended to contribute
 * any useful changes back to Algorithmics (mail to
 * bonito@algor.co.uk).
 */

/* Revision 1.48 autogenerated on 08/17/99 15:20:01 */

#ifndef _FCR_H__

#ifdef __ASSEMBLER__
#else /* !__ASSEMBLER */
extern char           *heaptop;

#endif /* __ASSEMBLER__ */

/* APB bus control registers */
#define APB_MISC_BASE 0x1f004100

#define GPIO_OE28_0    0x00
#define GPIO_R28_0     0x10
#define GPIO_W28_0     0x20
#define APB_MISC_CTL   0x40

/*
#define GPIO_OE47_20	0x00
#define GPIO_OE77_48	0x08
#define GPIO_R47_20	0x10
#define GPIO_R77_48	0x18
#define GPIO_W47_20	0x20
#define GPIO_W77_48	0x28
#define APB_MISC_CTL	0x40
*/
#define AHB_MISC_BASE 0x1f003200

#define GPIO_OE60_29	0x20
#define GPIO_R60_29	0x24
#define GPIO_W60_29	0x28



#define RTC_INDEX_REG 0x70
#define RTC_DATA_REG 0x71
#define RTC_NVRAM_BASE		0x0e


#define COM2_BASE_ADDR	0xbfd003f8
#define COM3_BASE_ADDR	0xbf004080
#define COM1_BASE_ADDR  0xbf004080
//#define	NS16550HZ	1843200
//#define	NS16550HZ	(33350000/4)
//#define	NS16550HZ	(APB_CLK/4)
#define	NS16550HZ	APB_CLK
/*********************************************************************/
/*nvram define                                                       */
/*********************************************************************/
#ifdef NVRAM_IN_FLASH
#	define	NVRAM_SIZE		494
#	define	NVRAM_SECSIZE		500
#	define	NVRAM_OFFS		0x0007f000
#	define ETHER_OFFS		494 	/* Ethernet address base */
#else	/* Use clock ram, 256 bytes only */
#	define NVRAM_SIZE		114
#	define NVRAM_SECSIZE		NVRAM_SIZE	/* Helper */
#	define NVRAM_OFFS		0
#	define ETHER_OFFS		108 	/* Ethernet address base */
#endif



/*********************************************************************/
/*PCI map	                                                     */
/*********************************************************************/

#ifdef X86_LIKE_SPACE
/* To make address spaces alike with x86 system, we put sdram
 * start address at 0 and pci devices' start address at 0x14000000 for
 * both CPU address space & PCI memory address space.
 *
 * We have 3 64M window in CPU address space to access PCI memory,but the
 * legacy PCI  start pci memory from 0x10000000, so we can use the same address to access
 * them from cpu memory space. But to access the 0xc0000 vga ram, we have to
 * reserve the first window. Only the last two are used for pci devices. 
 * --zfx 060716
 */
/* make sdram appear at both cpu & pci memory space 0,
 * so for dma the physical address can be directly used 
 * as bus address. --zfx 060716
 */

#define PCI_MEM_SPACE_PCI_BASE		0x10000000
#define PCI_LOCAL_MEM_PCI_BASE		0x00000000
#define PCI_LOCAL_MEM_ISA_BASE		0x80000000
#define PCI_LOCAL_REG_PCI_BASE		0x90000000

#else

#define PCI_MEM_SPACE_PCI_BASE		0x00000000
#define PCI_LOCAL_MEM_PCI_BASE		0x80000000
#define PCI_LOCAL_MEM_ISA_BASE		0x00800000
#define PCI_LOCAL_REG_PCI_BASE		0x90000000

#endif

#define PCI_IO_SPACE_BASE		0x00000000

#endif /* _BONITO_H_ */
