/*	$OpenBSD$	*/

/*
 * System call argument lists.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from;	OpenBSD: syscalls.master,v 1.37 1999/06/07 07:17:42 deraadt Exp 
 */

#define	syscallarg(x)	union { x datum; register_t regt; }

struct sys_exit_args {
	syscallarg(int) rval;
};

struct sys_read_args {
	syscallarg(int) fd;
	syscallarg(void *) buf;
	syscallarg(size_t) nbyte;
};

struct sys_write_args {
	syscallarg(int) fd;
	syscallarg(const void *) buf;
	syscallarg(size_t) nbyte;
};

struct sys_open_args {
	syscallarg(const char *) path;
	syscallarg(int) flags;
	syscallarg(int) mode;
};

struct sys_close_args {
	syscallarg(int) fd;
};

struct sys_wait4_args {
	syscallarg(int) pid;
	syscallarg(int *) status;
	syscallarg(int) options;
	syscallarg(struct rusage *) rusage;
};

struct compat_43_sys_creat_args {
	syscallarg(const char *) path;
	syscallarg(int) mode;
};

struct sys_link_args {
	syscallarg(const char *) path;
	syscallarg(const char *) link;
};

struct sys_unlink_args {
	syscallarg(const char *) path;
};

struct sys_chdir_args {
	syscallarg(const char *) path;
};

struct sys_fchdir_args {
	syscallarg(int) fd;
};

struct sys_mknod_args {
	syscallarg(const char *) path;
	syscallarg(int) mode;
	syscallarg(dev_t) dev;
};

struct sys_chmod_args {
	syscallarg(const char *) path;
	syscallarg(int) mode;
};

struct sys_chown_args {
	syscallarg(const char *) path;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};

struct sys_obreak_args {
	syscallarg(char *) nsize;
};

struct sys_ogetfsstat_args {
	syscallarg(struct statfs *) buf;
	syscallarg(long) bufsize;
	syscallarg(int) flags;
};

struct compat_43_sys_lseek_args {
	syscallarg(int) fd;
	syscallarg(long) offset;
	syscallarg(int) whence;
};

struct sys_mount_args {
	syscallarg(const char *) type;
	syscallarg(const char *) path;
	syscallarg(int) flags;
	syscallarg(void *) data;
};

struct sys_unmount_args {
	syscallarg(const char *) path;
	syscallarg(int) flags;
};

struct sys_setuid_args {
	syscallarg(uid_t) uid;
};

struct sys_ptrace_args {
	syscallarg(int) req;
	syscallarg(pid_t) pid;
	syscallarg(caddr_t) addr;
	syscallarg(int) data;
};

struct sys_recvmsg_args {
	syscallarg(int) s;
	syscallarg(struct msghdr *) msg;
	syscallarg(int) flags;
};

struct sys_sendmsg_args {
	syscallarg(int) s;
	syscallarg(const struct msghdr *) msg;
	syscallarg(int) flags;
};

struct sys_recvfrom_args {
	syscallarg(int) s;
	syscallarg(void *) buf;
	syscallarg(size_t) len;
	syscallarg(int) flags;
	syscallarg(struct sockaddr *) from;
	syscallarg(socklen_t *) fromlenaddr;
};

struct sys_accept_args {
	syscallarg(int) s;
	syscallarg(struct sockaddr *) name;
	syscallarg(socklen_t *) anamelen;
};

struct sys_getpeername_args {
	syscallarg(int) fdes;
	syscallarg(struct sockaddr *) asa;
	syscallarg(int *) alen;
};

struct sys_getsockname_args {
	syscallarg(int) fdes;
	syscallarg(struct sockaddr *) asa;
	syscallarg(socklen_t *) alen;
};

struct sys_access_args {
	syscallarg(const char *) path;
	syscallarg(int) flags;
};

struct sys_chflags_args {
	syscallarg(const char *) path;
	syscallarg(u_int) flags;
};

struct sys_fchflags_args {
	syscallarg(int) fd;
	syscallarg(u_int) flags;
};

struct sys_kill_args {
	syscallarg(int) pid;
	syscallarg(int) signum;
};

struct compat_43_sys_stat_args {
	syscallarg(const char *) path;
	syscallarg(struct ostat *) ub;
};

struct compat_43_sys_lstat_args {
	syscallarg(char *) path;
	syscallarg(struct ostat *) ub;
};

struct sys_dup_args {
	syscallarg(int) fd;
};

struct sys_profil_args {
	syscallarg(caddr_t) samples;
	syscallarg(size_t) size;
	syscallarg(u_long) offset;
	syscallarg(u_int) scale;
};

struct sys_ktrace_args {
	syscallarg(const char *) fname;
	syscallarg(int) ops;
	syscallarg(int) facs;
	syscallarg(pid_t) pid;
};

struct sys_sigaction_args {
	syscallarg(int) signum;
	syscallarg(const struct sigaction *) nsa;
	syscallarg(struct sigaction *) osa;
};

struct sys_sigprocmask_args {
	syscallarg(int) how;
	syscallarg(sigset_t) mask;
};

struct sys_getlogin_args {
	syscallarg(char *) namebuf;
	syscallarg(u_int) namelen;
};

struct sys_setlogin_args {
	syscallarg(const char *) namebuf;
};

struct sys_acct_args {
	syscallarg(const char *) path;
};

struct sys_sigaltstack_args {
	syscallarg(const struct sigaltstack *) nss;
	syscallarg(struct sigaltstack *) oss;
};

struct sys_ioctl_args {
	syscallarg(int) fd;
	syscallarg(u_long) com;
	syscallarg(void *) data;
};

struct sys_reboot_args {
	syscallarg(int) opt;
};

struct sys_revoke_args {
	syscallarg(const char *) path;
};

struct sys_symlink_args {
	syscallarg(const char *) path;
	syscallarg(const char *) link;
};

struct sys_readlink_args {
	syscallarg(const char *) path;
	syscallarg(char *) buf;
	syscallarg(size_t) count;
};

struct sys_execve_args {
	syscallarg(const char *) path;
	syscallarg(char *const *) argp;
	syscallarg(char *const *) envp;
};

struct sys_umask_args {
	syscallarg(int) newmask;
};

struct sys_chroot_args {
	syscallarg(const char *) path;
};

struct compat_43_sys_fstat_args {
	syscallarg(int) fd;
	syscallarg(struct ostat *) sb;
};

struct compat_43_sys_getkerninfo_args {
	syscallarg(int) op;
	syscallarg(char *) where;
	syscallarg(int *) size;
	syscallarg(int) arg;
};

struct sys_omsync_args {
	syscallarg(caddr_t) addr;
	syscallarg(size_t) len;
};

struct sys_sbrk_args {
	syscallarg(int) incr;
};

struct sys_sstk_args {
	syscallarg(int) incr;
};

struct compat_43_sys_mmap_args {
	syscallarg(caddr_t) addr;
	syscallarg(size_t) len;
	syscallarg(int) prot;
	syscallarg(int) flags;
	syscallarg(int) fd;
	syscallarg(long) pos;
};

struct sys_ovadvise_args {
	syscallarg(int) anom;
};

struct sys_munmap_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
};

struct sys_mprotect_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(int) prot;
};

struct sys_madvise_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(int) behav;
};

struct sys_mincore_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(char *) vec;
};

struct sys_getgroups_args {
	syscallarg(int) gidsetsize;
	syscallarg(gid_t *) gidset;
};

struct sys_setgroups_args {
	syscallarg(int) gidsetsize;
	syscallarg(const gid_t *) gidset;
};

struct sys_setpgid_args {
	syscallarg(pid_t) pid;
	syscallarg(int) pgid;
};

struct sys_setitimer_args {
	syscallarg(int) which;
	syscallarg(const struct itimerval *) itv;
	syscallarg(struct itimerval *) oitv;
};

struct sys_swapon_args {
	syscallarg(const char *) name;
};

struct sys_getitimer_args {
	syscallarg(int) which;
	syscallarg(struct itimerval *) itv;
};

struct compat_43_sys_gethostname_args {
	syscallarg(char *) hostname;
	syscallarg(u_int) len;
};

struct compat_43_sys_sethostname_args {
	syscallarg(char *) hostname;
	syscallarg(u_int) len;
};

struct sys_dup2_args {
	syscallarg(int) from;
	syscallarg(int) to;
};

struct sys_fcntl_args {
	syscallarg(int) fd;
	syscallarg(int) cmd;
	syscallarg(void *) arg;
};

struct sys_select_args {
	syscallarg(int) nd;
	syscallarg(fd_set *) in;
	syscallarg(fd_set *) ou;
	syscallarg(fd_set *) ex;
	syscallarg(struct timeval *) tv;
};

struct sys_fsync_args {
	syscallarg(int) fd;
};

struct sys_setpriority_args {
	syscallarg(int) which;
	syscallarg(int) who;
	syscallarg(int) prio;
};

struct sys_socket_args {
	syscallarg(int) domain;
	syscallarg(int) type;
	syscallarg(int) protocol;
};

struct sys_connect_args {
	syscallarg(int) s;
	syscallarg(const struct sockaddr *) name;
	syscallarg(socklen_t) namelen;
};

struct compat_43_sys_accept_args {
	syscallarg(int) s;
	syscallarg(caddr_t) name;
	syscallarg(int *) anamelen;
};

struct sys_getpriority_args {
	syscallarg(int) which;
	syscallarg(int) who;
};

struct compat_43_sys_send_args {
	syscallarg(int) s;
	syscallarg(caddr_t) buf;
	syscallarg(int) len;
	syscallarg(int) flags;
};

struct compat_43_sys_recv_args {
	syscallarg(int) s;
	syscallarg(caddr_t) buf;
	syscallarg(int) len;
	syscallarg(int) flags;
};

struct sys_sigreturn_args {
	syscallarg(struct sigcontext *) sigcntxp;
};

struct sys_bind_args {
	syscallarg(int) s;
	syscallarg(const struct sockaddr *) name;
	syscallarg(socklen_t) namelen;
};

struct sys_setsockopt_args {
	syscallarg(int) s;
	syscallarg(int) level;
	syscallarg(int) name;
	syscallarg(const void *) val;
	syscallarg(socklen_t) valsize;
};

struct sys_listen_args {
	syscallarg(int) s;
	syscallarg(int) backlog;
};

struct compat_43_sys_sigvec_args {
	syscallarg(int) signum;
	syscallarg(struct sigvec *) nsv;
	syscallarg(struct sigvec *) osv;
};

struct compat_43_sys_sigblock_args {
	syscallarg(int) mask;
};

struct compat_43_sys_sigsetmask_args {
	syscallarg(int) mask;
};

struct sys_sigsuspend_args {
	syscallarg(int) mask;
};

struct compat_43_sys_sigstack_args {
	syscallarg(struct sigstack *) nss;
	syscallarg(struct sigstack *) oss;
};

struct compat_43_sys_recvmsg_args {
	syscallarg(int) s;
	syscallarg(struct omsghdr *) msg;
	syscallarg(int) flags;
};

struct compat_43_sys_sendmsg_args {
	syscallarg(int) s;
	syscallarg(caddr_t) msg;
	syscallarg(int) flags;
};

struct sys_vtrace_args {
	syscallarg(int) request;
	syscallarg(int) value;
};

struct sys_gettimeofday_args {
	syscallarg(struct timeval *) tp;
	syscallarg(struct timezone *) tzp;
};

struct sys_getrusage_args {
	syscallarg(int) who;
	syscallarg(struct rusage *) rusage;
};

struct sys_getsockopt_args {
	syscallarg(int) s;
	syscallarg(int) level;
	syscallarg(int) name;
	syscallarg(void *) val;
	syscallarg(socklen_t *) avalsize;
};

struct sys_readv_args {
	syscallarg(int) fd;
	syscallarg(const struct iovec *) iovp;
	syscallarg(int) iovcnt;
};

struct sys_writev_args {
	syscallarg(int) fd;
	syscallarg(const struct iovec *) iovp;
	syscallarg(int) iovcnt;
};

struct sys_settimeofday_args {
	syscallarg(const struct timeval *) tv;
	syscallarg(const struct timezone *) tzp;
};

struct sys_fchown_args {
	syscallarg(int) fd;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};

struct sys_fchmod_args {
	syscallarg(int) fd;
	syscallarg(int) mode;
};

struct compat_43_sys_recvfrom_args {
	syscallarg(int) s;
	syscallarg(caddr_t) buf;
	syscallarg(size_t) len;
	syscallarg(int) flags;
	syscallarg(caddr_t) from;
	syscallarg(int *) fromlenaddr;
};

struct compat_43_sys_setreuid_args {
	syscallarg(int) ruid;
	syscallarg(int) euid;
};

struct compat_43_sys_setregid_args {
	syscallarg(int) rgid;
	syscallarg(int) egid;
};

struct sys_rename_args {
	syscallarg(const char *) from;
	syscallarg(const char *) to;
};

struct compat_43_sys_truncate_args {
	syscallarg(const char *) path;
	syscallarg(long) length;
};

struct compat_43_sys_ftruncate_args {
	syscallarg(int) fd;
	syscallarg(long) length;
};

struct sys_flock_args {
	syscallarg(int) fd;
	syscallarg(int) how;
};

struct sys_mkfifo_args {
	syscallarg(const char *) path;
	syscallarg(int) mode;
};

struct sys_sendto_args {
	syscallarg(int) s;
	syscallarg(const void *) buf;
	syscallarg(size_t) len;
	syscallarg(int) flags;
	syscallarg(const struct sockaddr *) to;
	syscallarg(socklen_t) tolen;
};

struct sys_shutdown_args {
	syscallarg(int) s;
	syscallarg(int) how;
};

struct sys_socketpair_args {
	syscallarg(int) domain;
	syscallarg(int) type;
	syscallarg(int) protocol;
	syscallarg(int *) rsv;
};

struct sys_mkdir_args {
	syscallarg(const char *) path;
	syscallarg(int) mode;
};

struct sys_rmdir_args {
	syscallarg(const char *) path;
};

struct sys_utimes_args {
	syscallarg(const char *) path;
	syscallarg(const struct timeval *) tptr;
};

struct sys_adjtime_args {
	syscallarg(const struct timeval *) delta;
	syscallarg(struct timeval *) olddelta;
};

struct compat_43_sys_getpeername_args {
	syscallarg(int) fdes;
	syscallarg(caddr_t) asa;
	syscallarg(socklen_t *) alen;
};

struct compat_43_sys_sethostid_args {
	syscallarg(int32_t) hostid;
};

struct compat_43_sys_getrlimit_args {
	syscallarg(int) which;
	syscallarg(struct ogetrlimit *) rlp;
};

struct compat_43_sys_setrlimit_args {
	syscallarg(int) which;
	syscallarg(struct ogetrlimit *) rlp;
};

struct compat_43_sys_killpg_args {
	syscallarg(int) pgid;
	syscallarg(int) signum;
};

struct sys_quotactl_args {
	syscallarg(const char *) path;
	syscallarg(int) cmd;
	syscallarg(int) uid;
	syscallarg(char *) arg;
};

struct compat_43_sys_getsockname_args {
	syscallarg(int) fdec;
	syscallarg(caddr_t) asa;
	syscallarg(int *) alen;
};

struct sys_nfssvc_args {
	syscallarg(int) flag;
	syscallarg(void *) argp;
};

struct compat_43_sys_getdirentries_args {
	syscallarg(int) fd;
	syscallarg(char *) buf;
	syscallarg(int) count;
	syscallarg(long *) basep;
};

struct sys_ostatfs_args {
	syscallarg(const char *) path;
	syscallarg(struct ostatfs *) buf;
};

struct sys_ofstatfs_args {
	syscallarg(int) fd;
	syscallarg(struct ostatfs *) buf;
};

#if 0
struct sys_getfh_args {
	syscallarg(const char *) fname;
	syscallarg(fhandle_t *) fhp;
};
#endif

struct compat_09_sys_getdomainname_args {
	syscallarg(char *) domainname;
	syscallarg(int) len;
};

struct compat_09_sys_setdomainname_args {
	syscallarg(char *) domainname;
	syscallarg(int) len;
};

struct compat_09_sys_uname_args {
	syscallarg(struct outsname *) name;
};

struct sys_sysarch_args {
	syscallarg(int) op;
	syscallarg(char *) parms;
};

struct compat_10_sys_semsys_args {
	syscallarg(int) which;
	syscallarg(int) a2;
	syscallarg(int) a3;
	syscallarg(int) a4;
	syscallarg(int) a5;
};

struct compat_10_sys_msgsys_args {
	syscallarg(int) which;
	syscallarg(int) a2;
	syscallarg(int) a3;
	syscallarg(int) a4;
	syscallarg(int) a5;
	syscallarg(int) a6;
};

struct compat_10_sys_shmsys_args {
	syscallarg(int) which;
	syscallarg(int) a2;
	syscallarg(int) a3;
	syscallarg(int) a4;
};

struct sys_ntp_gettime_args {
	syscallarg(struct ntptimeval *) ntvp;
};

struct sys_ntp_adjtime_args {
	syscallarg(struct timex *) tp;
};

struct sys_setgid_args {
	syscallarg(gid_t) gid;
};

struct sys_setegid_args {
	syscallarg(gid_t) egid;
};

struct sys_seteuid_args {
	syscallarg(uid_t) euid;
};

#if 0
struct lfs_bmapv_args {
	syscallarg(fsid_t *) fsidp;
	syscallarg(struct block_info *) blkiov;
	syscallarg(int) blkcnt;
};

struct lfs_markv_args {
	syscallarg(fsid_t *) fsidp;
	syscallarg(struct block_info *) blkiov;
	syscallarg(int) blkcnt;
};

struct lfs_segclean_args {
	syscallarg(fsid_t *) fsidp;
	syscallarg(u_long) segment;
};

struct lfs_segwait_args {
	syscallarg(fsid_t *) fsidp;
	syscallarg(struct timeval *) tv;
};
#endif

struct sys_stat_args {
	syscallarg(const char *) path;
	syscallarg(struct stat *) ub;
};

struct sys_fstat_args {
	syscallarg(int) fd;
	syscallarg(struct stat *) sb;
};

struct sys_lstat_args {
	syscallarg(const char *) path;
	syscallarg(struct stat *) ub;
};

struct sys_pathconf_args {
	syscallarg(const char *) path;
	syscallarg(int) name;
};

struct sys_fpathconf_args {
	syscallarg(int) fd;
	syscallarg(int) name;
};

struct sys_swapctl_args {
	syscallarg(int) cmd;
	syscallarg(const void *) arg;
	syscallarg(int) misc;
};

struct sys_getrlimit_args {
	syscallarg(int) which;
	syscallarg(struct rlimit *) rlp;
};

struct sys_setrlimit_args {
	syscallarg(int) which;
	syscallarg(const struct rlimit *) rlp;
};

struct sys_getdirentries_args {
	syscallarg(int) fd;
	syscallarg(char *) buf;
	syscallarg(int) count;
	syscallarg(long *) basep;
};

struct sys_mmap_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(int) prot;
	syscallarg(int) flags;
	syscallarg(int) fd;
	syscallarg(long) pad;
	syscallarg(off_t) pos;
};

struct sys_lseek_args {
	syscallarg(int) fd;
	syscallarg(int) pad;
	syscallarg(off_t) offset;
	syscallarg(int) whence;
};

struct sys_truncate_args {
	syscallarg(const char *) path;
	syscallarg(int) pad;
	syscallarg(off_t) length;
};

struct sys_ftruncate_args {
	syscallarg(int) fd;
	syscallarg(int) pad;
	syscallarg(off_t) length;
};

struct sys___sysctl_args {
	syscallarg(int *) name;
	syscallarg(u_int) namelen;
	syscallarg(void *) old;
	syscallarg(size_t *) oldlenp;
	syscallarg(void *) new;
	syscallarg(size_t) newlen;
};

struct sys_mlock_args {
	syscallarg(const void *) addr;
	syscallarg(size_t) len;
};

struct sys_munlock_args {
	syscallarg(const void *) addr;
	syscallarg(size_t) len;
};

struct sys_undelete_args {
	syscallarg(const char *) path;
};

struct sys_futimes_args {
	syscallarg(int) fd;
	syscallarg(const struct timeval *) tptr;
};

struct sys_getpgid_args {
	syscallarg(pid_t) pid;
};

struct sys_xfspioctl_args {
	syscallarg(int) operation;
	syscallarg(char *) a_pathP;
	syscallarg(int) a_opcode;
	syscallarg(struct ViceIoctl *) a_paramsP;
	syscallarg(int) a_followSymlinks;
};

struct sys___osemctl_args {
	syscallarg(int) semid;
	syscallarg(int) semnum;
	syscallarg(int) cmd;
	syscallarg(union semun *) arg;
};

struct sys_semget_args {
	syscallarg(key_t) key;
	syscallarg(int) nsems;
	syscallarg(int) semflg;
};

struct sys_semop_args {
	syscallarg(int) semid;
	syscallarg(struct sembuf *) sops;
	syscallarg(u_int) nsops;
};

struct sys_semconfig_args {
	syscallarg(int) flag;
};

struct sys_omsgctl_args {
	syscallarg(int) msqid;
	syscallarg(int) cmd;
	syscallarg(struct omsqid_ds *) buf;
};

struct sys_msgget_args {
	syscallarg(key_t) key;
	syscallarg(int) msgflg;
};

struct sys_msgsnd_args {
	syscallarg(int) msqid;
	syscallarg(const void *) msgp;
	syscallarg(size_t) msgsz;
	syscallarg(int) msgflg;
};

struct sys_msgrcv_args {
	syscallarg(int) msqid;
	syscallarg(void *) msgp;
	syscallarg(size_t) msgsz;
	syscallarg(long) msgtyp;
	syscallarg(int) msgflg;
};

struct sys_shmat_args {
	syscallarg(int) shmid;
	syscallarg(const void *) shmaddr;
	syscallarg(int) shmflg;
};

struct sys_oshmctl_args {
	syscallarg(int) shmid;
	syscallarg(int) cmd;
	syscallarg(struct oshmid_ds *) buf;
};

struct sys_shmdt_args {
	syscallarg(const void *) shmaddr;
};

struct sys_shmget_args {
	syscallarg(key_t) key;
	syscallarg(int) size;
	syscallarg(int) shmflg;
};

struct sys_clock_gettime_args {
	syscallarg(clockid_t) clock_id;
	syscallarg(struct timespec *) tp;
};

struct sys_clock_settime_args {
	syscallarg(clockid_t) clock_id;
	syscallarg(const struct timespec *) tp;
};

struct sys_clock_getres_args {
	syscallarg(clockid_t) clock_id;
	syscallarg(struct timespec *) tp;
};

struct sys_timer_create_args {
	syscallarg(int) clock_id;
	syscallarg(struct sigevent *) evp;
	syscallarg(timer_t *) timerid;
};

struct sys_timer_delete_args {
	syscallarg(timer_t) timerid;
};

struct sys_timer_settime_args {
	syscallarg(timer_t) timerid;
	syscallarg(int) flags;
	syscallarg(struct itimerspec *) value;
	syscallarg(struct itimerspec *) ovalue;
};

struct sys_timer_gettime_args {
	syscallarg(timer_t) timerid;
	syscallarg(struct itimerspec *) value;
};

struct sys_timer_getoverrun_args {
	syscallarg(timer_t) timerid;
};

struct sys_nanosleep_args {
	syscallarg(const struct timespec *) rqtp;
	syscallarg(struct timespec *) rmtp;
};

struct sys_mlockall_args {
	syscallarg(int) flags;
};

struct sys_minherit_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(int) inherit;
};

struct sys_rfork_args {
	syscallarg(int) flags;
};

struct sys_poll_args {
	syscallarg(struct pollfd *) fds;
	syscallarg(unsigned long) nfds;
	syscallarg(int) timeout;
};

struct sys_lchown_args {
	syscallarg(const char *) path;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};

struct sys_getsid_args {
	syscallarg(pid_t) pid;
};

struct sys_msync_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(int) flags;
};

struct sys___semctl_args {
	syscallarg(int) semid;
	syscallarg(int) semnum;
	syscallarg(int) cmd;
	syscallarg(union semun *) arg;
};

struct sys_shmctl_args {
	syscallarg(int) shmid;
	syscallarg(int) cmd;
	syscallarg(struct shmid_ds *) buf;
};

struct sys_msgctl_args {
	syscallarg(int) msqid;
	syscallarg(int) cmd;
	syscallarg(struct msqid_ds *) buf;
};

struct sys_getfsstat_args {
	syscallarg(struct statfs *) buf;
	syscallarg(size_t) bufsize;
	syscallarg(int) flags;
};

struct sys_statfs_args {
	syscallarg(const char *) path;
	syscallarg(struct statfs *) buf;
};

struct sys_fstatfs_args {
	syscallarg(int) fd;
	syscallarg(struct statfs *) buf;
};

struct sys_pipe_args {
	syscallarg(int *) fdp;
};

struct sys_sched_setparam_args {
	syscallarg(pid_t) pid;
	syscallarg(struct sched_param *) param;
};

struct sys_sched_getparam_args {
	syscallarg(pid_t) pid;
	syscallarg(struct sched_param *) param;
};

struct sys_sched_setscheduler_args {
	syscallarg(pid_t) pid;
	syscallarg(int) policy;
	syscallarg(struct sched_param *) param;
};

struct sys_sched_getscheduler_args {
	syscallarg(pid_t) pid;
};

struct sys_sched_get_priority_max_args {
	syscallarg(int) policy;
};

struct sys_sched_get_priority_min_args {
	syscallarg(int) policy;
};

struct sys_sched_get_rr_interval_args {
	syscallarg(pid_t) pid;
	syscallarg(struct timespec *) min;
};

struct sys_sigwaitinfo_args {
	syscallarg(sigset_t *) set;
	syscallarg(siginfo_t *) info;
};

struct sys_sigtimedwait_args {
	syscallarg(sigset_t *) set;
	syscallarg(siginfo_t *) info;
	syscallarg(struct timespec *) timeout;
};

struct sys_sigqueue_args {
	syscallarg(pid_t) pid;
	syscallarg(int) signo;
	syscallarg(union sigval) value;
};

struct sys_mq_open_args {
	syscallarg(char *) name;
	syscallarg(int) oflag;
	syscallarg(int) mode;
	syscallarg(struct mq_attr *) attr;
};

struct sys_mq_close_args {
	syscallarg(int) mqdes;
};

struct sys_mq_unlink_args {
	syscallarg(char *) name;
};

struct sys_mq_send_args {
	syscallarg(int) mqdes;
	syscallarg(char *) msg_ptr;
	syscallarg(size_t) msg_len;
	syscallarg(unsigned int) msg_prio;
};

struct sys_mq_receive_args {
	syscallarg(int) mqdes;
	syscallarg(char *) msg_ptr;
	syscallarg(size_t) msg_len;
	syscallarg(unsigned int) msg_prio;
};

struct sys_mq_notify_args {
	syscallarg(int) mqdes;
	syscallarg(struct sigevent *) notification;
};

struct sys_mq_setattr_args {
	syscallarg(int) mqdes;
	syscallarg(struct mq_attr *) mqstat;
	syscallarg(struct mq_attr *) omqstat;
};

struct sys_mq_getattr_args {
	syscallarg(int) mqdes;
	syscallarg(struct mq_attr *) mqstat;
	syscallarg(struct mq_attr *) omqstat;
};

struct sys_sem_open_args {
	syscallarg(char *) name;
	syscallarg(int) oflag;
	syscallarg(int) mode;
	syscallarg(unsigned int) value;
};

struct sys_sem_close_args {
	syscallarg(int) sem;
};

struct sys_sem_unlink_args {
	syscallarg(char *) name;
};

struct sys_sem_semop_args {
	syscallarg(int) sem;
	syscallarg(int) op;
	syscallarg(int *) val;
};

/*
 * System call prototypes.
 */

#ifdef POSIX1003_1b
#endif
int	sys_exit	__P((struct proc *, void *, register_t *));
int	sys_fork	__P((struct proc *, void *, register_t *));
int	sys_read	__P((struct proc *, void *, register_t *));
int	sys_write	__P((struct proc *, void *, register_t *));
int	sys_open	__P((struct proc *, void *, register_t *));
int	sys_close	__P((struct proc *, void *, register_t *));
int	sys_wait4	__P((struct proc *, void *, register_t *));
int	compat_43_sys_creat	__P((struct proc *, void *, register_t *));
int	sys_link	__P((struct proc *, void *, register_t *));
int	sys_unlink	__P((struct proc *, void *, register_t *));
int	sys_chdir	__P((struct proc *, void *, register_t *));
int	sys_fchdir	__P((struct proc *, void *, register_t *));
int	sys_mknod	__P((struct proc *, void *, register_t *));
int	sys_chmod	__P((struct proc *, void *, register_t *));
int	sys_chown	__P((struct proc *, void *, register_t *));
int	sys_obreak	__P((struct proc *, void *, register_t *));
int	sys_ogetfsstat	__P((struct proc *, void *, register_t *));
int	compat_43_sys_lseek	__P((struct proc *, void *, register_t *));
int	sys_getpid	__P((struct proc *, void *, register_t *));
int	sys_mount	__P((struct proc *, void *, register_t *));
int	sys_unmount	__P((struct proc *, void *, register_t *));
int	sys_setuid	__P((struct proc *, void *, register_t *));
int	sys_getuid	__P((struct proc *, void *, register_t *));
int	sys_geteuid	__P((struct proc *, void *, register_t *));
int	sys_ptrace	__P((struct proc *, void *, register_t *));
int	sys_recvmsg	__P((struct proc *, void *, register_t *));
int	sys_sendmsg	__P((struct proc *, void *, register_t *));
int	sys_recvfrom	__P((struct proc *, void *, register_t *));
int	sys_accept	__P((struct proc *, void *, register_t *));
int	sys_getpeername	__P((struct proc *, void *, register_t *));
int	sys_getsockname	__P((struct proc *, void *, register_t *));
int	sys_access	__P((struct proc *, void *, register_t *));
int	sys_chflags	__P((struct proc *, void *, register_t *));
int	sys_fchflags	__P((struct proc *, void *, register_t *));
int	sys_sync	__P((struct proc *, void *, register_t *));
int	sys_kill	__P((struct proc *, void *, register_t *));
int	compat_43_sys_stat	__P((struct proc *, void *, register_t *));
int	sys_getppid	__P((struct proc *, void *, register_t *));
int	compat_43_sys_lstat	__P((struct proc *, void *, register_t *));
int	sys_dup	__P((struct proc *, void *, register_t *));
int	sys_opipe	__P((struct proc *, void *, register_t *));
int	sys_getegid	__P((struct proc *, void *, register_t *));
int	sys_profil	__P((struct proc *, void *, register_t *));
#ifdef KTRACE
int	sys_ktrace	__P((struct proc *, void *, register_t *));
#else
#endif
int	sys_sigaction	__P((struct proc *, void *, register_t *));
int	sys_getgid	__P((struct proc *, void *, register_t *));
int	sys_sigprocmask	__P((struct proc *, void *, register_t *));
int	sys_getlogin	__P((struct proc *, void *, register_t *));
int	sys_setlogin	__P((struct proc *, void *, register_t *));
int	sys_acct	__P((struct proc *, void *, register_t *));
int	sys_sigpending	__P((struct proc *, void *, register_t *));
int	sys_sigaltstack	__P((struct proc *, void *, register_t *));
int	sys_ioctl	__P((struct proc *, void *, register_t *));
int	sys_reboot	__P((struct proc *, void *, register_t *));
int	sys_revoke	__P((struct proc *, void *, register_t *));
int	sys_symlink	__P((struct proc *, void *, register_t *));
int	sys_readlink	__P((struct proc *, void *, register_t *));
int	sys_execve	__P((struct proc *, void *, register_t *));
int	sys_umask	__P((struct proc *, void *, register_t *));
int	sys_chroot	__P((struct proc *, void *, register_t *));
int	compat_43_sys_fstat	__P((struct proc *, void *, register_t *));
int	compat_43_sys_getkerninfo	__P((struct proc *, void *, register_t *));
int	compat_43_sys_getpagesize	__P((struct proc *, void *, register_t *));
int	sys_omsync	__P((struct proc *, void *, register_t *));
int	sys_vfork	__P((struct proc *, void *, register_t *));
int	sys_sbrk	__P((struct proc *, void *, register_t *));
int	sys_sstk	__P((struct proc *, void *, register_t *));
int	compat_43_sys_mmap	__P((struct proc *, void *, register_t *));
int	sys_ovadvise	__P((struct proc *, void *, register_t *));
int	sys_munmap	__P((struct proc *, void *, register_t *));
int	sys_mprotect	__P((struct proc *, void *, register_t *));
int	sys_madvise	__P((struct proc *, void *, register_t *));
int	sys_mincore	__P((struct proc *, void *, register_t *));
int	sys_getgroups	__P((struct proc *, void *, register_t *));
int	sys_setgroups	__P((struct proc *, void *, register_t *));
int	sys_getpgrp	__P((struct proc *, void *, register_t *));
int	sys_setpgid	__P((struct proc *, void *, register_t *));
int	sys_setitimer	__P((struct proc *, void *, register_t *));
int	compat_43_sys_wait	__P((struct proc *, void *, register_t *));
int	sys_swapon	__P((struct proc *, void *, register_t *));
int	sys_getitimer	__P((struct proc *, void *, register_t *));
int	compat_43_sys_gethostname	__P((struct proc *, void *, register_t *));
int	compat_43_sys_sethostname	__P((struct proc *, void *, register_t *));
int	compat_43_sys_getdtablesize	__P((struct proc *, void *, register_t *));
int	sys_dup2	__P((struct proc *, void *, register_t *));
int	sys_fcntl	__P((struct proc *, void *, register_t *));
int	sys_select	__P((struct proc *, void *, register_t *));
int	sys_fsync	__P((struct proc *, void *, register_t *));
int	sys_setpriority	__P((struct proc *, void *, register_t *));
int	sys_socket	__P((struct proc *, void *, register_t *));
int	sys_connect	__P((struct proc *, void *, register_t *));
int	compat_43_sys_accept	__P((struct proc *, void *, register_t *));
int	sys_getpriority	__P((struct proc *, void *, register_t *));
int	compat_43_sys_send	__P((struct proc *, void *, register_t *));
int	compat_43_sys_recv	__P((struct proc *, void *, register_t *));
int	sys_sigreturn	__P((struct proc *, void *, register_t *));
int	sys_bind	__P((struct proc *, void *, register_t *));
int	sys_setsockopt	__P((struct proc *, void *, register_t *));
int	sys_listen	__P((struct proc *, void *, register_t *));
int	compat_43_sys_sigvec	__P((struct proc *, void *, register_t *));
int	compat_43_sys_sigblock	__P((struct proc *, void *, register_t *));
int	compat_43_sys_sigsetmask	__P((struct proc *, void *, register_t *));
int	sys_sigsuspend	__P((struct proc *, void *, register_t *));
int	compat_43_sys_sigstack	__P((struct proc *, void *, register_t *));
int	compat_43_sys_recvmsg	__P((struct proc *, void *, register_t *));
int	compat_43_sys_sendmsg	__P((struct proc *, void *, register_t *));
#ifdef TRACE
int	sys_vtrace	__P((struct proc *, void *, register_t *));
#else
#endif
int	sys_gettimeofday	__P((struct proc *, void *, register_t *));
int	sys_getrusage	__P((struct proc *, void *, register_t *));
int	sys_getsockopt	__P((struct proc *, void *, register_t *));
int	sys_readv	__P((struct proc *, void *, register_t *));
int	sys_writev	__P((struct proc *, void *, register_t *));
int	sys_settimeofday	__P((struct proc *, void *, register_t *));
int	sys_fchown	__P((struct proc *, void *, register_t *));
int	sys_fchmod	__P((struct proc *, void *, register_t *));
int	compat_43_sys_recvfrom	__P((struct proc *, void *, register_t *));
int	compat_43_sys_setreuid	__P((struct proc *, void *, register_t *));
int	compat_43_sys_setregid	__P((struct proc *, void *, register_t *));
int	sys_rename	__P((struct proc *, void *, register_t *));
int	compat_43_sys_truncate	__P((struct proc *, void *, register_t *));
int	compat_43_sys_ftruncate	__P((struct proc *, void *, register_t *));
int	sys_flock	__P((struct proc *, void *, register_t *));
int	sys_mkfifo	__P((struct proc *, void *, register_t *));
int	sys_sendto	__P((struct proc *, void *, register_t *));
int	sys_shutdown	__P((struct proc *, void *, register_t *));
int	sys_socketpair	__P((struct proc *, void *, register_t *));
int	sys_mkdir	__P((struct proc *, void *, register_t *));
int	sys_rmdir	__P((struct proc *, void *, register_t *));
int	sys_utimes	__P((struct proc *, void *, register_t *));
int	sys_adjtime	__P((struct proc *, void *, register_t *));
int	compat_43_sys_getpeername	__P((struct proc *, void *, register_t *));
int	compat_43_sys_gethostid	__P((struct proc *, void *, register_t *));
int	compat_43_sys_sethostid	__P((struct proc *, void *, register_t *));
int	compat_43_sys_getrlimit	__P((struct proc *, void *, register_t *));
int	compat_43_sys_setrlimit	__P((struct proc *, void *, register_t *));
int	compat_43_sys_killpg	__P((struct proc *, void *, register_t *));
int	sys_setsid	__P((struct proc *, void *, register_t *));
int	sys_quotactl	__P((struct proc *, void *, register_t *));
int	compat_43_sys_quota	__P((struct proc *, void *, register_t *));
int	compat_43_sys_getsockname	__P((struct proc *, void *, register_t *));
#if defined(NFSCLIENT) || defined(NFSSERVER)
int	sys_nfssvc	__P((struct proc *, void *, register_t *));
#else
#endif
int	compat_43_sys_getdirentries	__P((struct proc *, void *, register_t *));
int	sys_ostatfs	__P((struct proc *, void *, register_t *));
int	sys_ofstatfs	__P((struct proc *, void *, register_t *));
#if defined(NFSCLIENT) || defined(NFSSERVER)
int	sys_getfh	__P((struct proc *, void *, register_t *));
#else
#endif
int	compat_09_sys_getdomainname	__P((struct proc *, void *, register_t *));
int	compat_09_sys_setdomainname	__P((struct proc *, void *, register_t *));
int	compat_09_sys_uname	__P((struct proc *, void *, register_t *));
int	sys_sysarch	__P((struct proc *, void *, register_t *));
#if defined(SYSVSEM) && !defined(alpha)
int	compat_10_sys_semsys	__P((struct proc *, void *, register_t *));
#else
#endif
#if defined(SYSVMSG) && !defined(alpha)
int	compat_10_sys_msgsys	__P((struct proc *, void *, register_t *));
#else
#endif
#if defined(SYSVSHM) && !defined(alpha)
int	compat_10_sys_shmsys	__P((struct proc *, void *, register_t *));
#else
#endif
#ifdef NTP
int	sys_ntp_gettime	__P((struct proc *, void *, register_t *));
int	sys_ntp_adjtime	__P((struct proc *, void *, register_t *));
#else
#endif
int	sys_setgid	__P((struct proc *, void *, register_t *));
int	sys_setegid	__P((struct proc *, void *, register_t *));
int	sys_seteuid	__P((struct proc *, void *, register_t *));
#ifdef LFS
int	lfs_bmapv	__P((struct proc *, void *, register_t *));
int	lfs_markv	__P((struct proc *, void *, register_t *));
int	lfs_segclean	__P((struct proc *, void *, register_t *));
int	lfs_segwait	__P((struct proc *, void *, register_t *));
#else
#endif
int	sys_stat	__P((struct proc *, void *, register_t *));
int	sys_fstat	__P((struct proc *, void *, register_t *));
int	sys_lstat	__P((struct proc *, void *, register_t *));
int	sys_pathconf	__P((struct proc *, void *, register_t *));
int	sys_fpathconf	__P((struct proc *, void *, register_t *));
int	sys_swapctl	__P((struct proc *, void *, register_t *));
int	sys_getrlimit	__P((struct proc *, void *, register_t *));
int	sys_setrlimit	__P((struct proc *, void *, register_t *));
int	sys_getdirentries	__P((struct proc *, void *, register_t *));
int	sys_mmap	__P((struct proc *, void *, register_t *));
int	sys_lseek	__P((struct proc *, void *, register_t *));
int	sys_truncate	__P((struct proc *, void *, register_t *));
int	sys_ftruncate	__P((struct proc *, void *, register_t *));
int	sys___sysctl	__P((struct proc *, void *, register_t *));
int	sys_mlock	__P((struct proc *, void *, register_t *));
int	sys_munlock	__P((struct proc *, void *, register_t *));
int	sys_undelete	__P((struct proc *, void *, register_t *));
int	sys_futimes	__P((struct proc *, void *, register_t *));
int	sys_getpgid	__P((struct proc *, void *, register_t *));
int	sys_xfspioctl	__P((struct proc *, void *, register_t *));
#ifdef LKM
int	sys_lkmnosys	__P((struct proc *, void *, register_t *));
int	sys_lkmnosys	__P((struct proc *, void *, register_t *));
int	sys_lkmnosys	__P((struct proc *, void *, register_t *));
int	sys_lkmnosys	__P((struct proc *, void *, register_t *));
int	sys_lkmnosys	__P((struct proc *, void *, register_t *));
int	sys_lkmnosys	__P((struct proc *, void *, register_t *));
int	sys_lkmnosys	__P((struct proc *, void *, register_t *));
int	sys_lkmnosys	__P((struct proc *, void *, register_t *));
int	sys_lkmnosys	__P((struct proc *, void *, register_t *));
int	sys_lkmnosys	__P((struct proc *, void *, register_t *));
#else	/* !LKM */
#endif	/* !LKM */
#ifdef SYSVSEM
int	sys___osemctl	__P((struct proc *, void *, register_t *));
int	sys_semget	__P((struct proc *, void *, register_t *));
int	sys_semop	__P((struct proc *, void *, register_t *));
int	sys_semconfig	__P((struct proc *, void *, register_t *));
#else
#endif
#ifdef SYSVMSG
int	sys_omsgctl	__P((struct proc *, void *, register_t *));
int	sys_msgget	__P((struct proc *, void *, register_t *));
int	sys_msgsnd	__P((struct proc *, void *, register_t *));
int	sys_msgrcv	__P((struct proc *, void *, register_t *));
#else
#endif
#ifdef SYSVSHM
int	sys_shmat	__P((struct proc *, void *, register_t *));
int	sys_oshmctl	__P((struct proc *, void *, register_t *));
int	sys_shmdt	__P((struct proc *, void *, register_t *));
int	sys_shmget	__P((struct proc *, void *, register_t *));
#else
#endif
int	sys_clock_gettime	__P((struct proc *, void *, register_t *));
int	sys_clock_settime	__P((struct proc *, void *, register_t *));
int	sys_clock_getres	__P((struct proc *, void *, register_t *));
#ifdef POSIX1003_1b
int	sys_timer_create	__P((struct proc *, void *, register_t *));
int	sys_timer_delete	__P((struct proc *, void *, register_t *));
int	sys_timer_settime	__P((struct proc *, void *, register_t *));
int	sys_timer_gettime	__P((struct proc *, void *, register_t *));
int	sys_timer_getoverrun	__P((struct proc *, void *, register_t *));
#else
#endif /* POSIX1003_1b */
int	sys_nanosleep	__P((struct proc *, void *, register_t *));
#ifdef POSIX1003_1b
int	sys_mlockall	__P((struct proc *, void *, register_t *));
int	sys_munlockall	__P((struct proc *, void *, register_t *));
#else
#endif /* POSIX1003_1b */
int	sys_minherit	__P((struct proc *, void *, register_t *));
int	sys_rfork	__P((struct proc *, void *, register_t *));
int	sys_poll	__P((struct proc *, void *, register_t *));
int	sys_issetugid	__P((struct proc *, void *, register_t *));
int	sys_lchown	__P((struct proc *, void *, register_t *));
int	sys_getsid	__P((struct proc *, void *, register_t *));
int	sys_msync	__P((struct proc *, void *, register_t *));
#ifdef SYSVSEM
int	sys___semctl	__P((struct proc *, void *, register_t *));
#else
#endif
#ifdef SYSVSHM
int	sys_shmctl	__P((struct proc *, void *, register_t *));
#else
#endif
#ifdef SYSVMSG
int	sys_msgctl	__P((struct proc *, void *, register_t *));
#else
#endif
int	sys_getfsstat	__P((struct proc *, void *, register_t *));
int	sys_statfs	__P((struct proc *, void *, register_t *));
int	sys_fstatfs	__P((struct proc *, void *, register_t *));
int	sys_pipe	__P((struct proc *, void *, register_t *));
#ifdef POSIX1003_1b
int	sys_sched_setparam	__P((struct proc *, void *, register_t *));
int	sys_sched_getparam	__P((struct proc *, void *, register_t *));
int	sys_sched_setscheduler	__P((struct proc *, void *, register_t *));
int	sys_sched_getscheduler	__P((struct proc *, void *, register_t *));
int	sys_sched_yield	__P((struct proc *, void *, register_t *));
int	sys_sched_get_priority_max	__P((struct proc *, void *, register_t *));
int	sys_sched_get_priority_min	__P((struct proc *, void *, register_t *));
int	sys_sched_get_rr_interval	__P((struct proc *, void *, register_t *));
int	sys_sigwaitinfo	__P((struct proc *, void *, register_t *));
int	sys_sigtimedwait	__P((struct proc *, void *, register_t *));
int	sys_sigqueue	__P((struct proc *, void *, register_t *));
int	sys_mq_open	__P((struct proc *, void *, register_t *));
int	sys_mq_close	__P((struct proc *, void *, register_t *));
int	sys_mq_unlink	__P((struct proc *, void *, register_t *));
int	sys_mq_send	__P((struct proc *, void *, register_t *));
int	sys_mq_receive	__P((struct proc *, void *, register_t *));
int	sys_mq_notify	__P((struct proc *, void *, register_t *));
int	sys_mq_setattr	__P((struct proc *, void *, register_t *));
int	sys_mq_getattr	__P((struct proc *, void *, register_t *));
int	sys_sem_open	__P((struct proc *, void *, register_t *));
int	sys_sem_close	__P((struct proc *, void *, register_t *));
int	sys_sem_unlink	__P((struct proc *, void *, register_t *));
int	sys_sem_semop	__P((struct proc *, void *, register_t *));
#else
#endif
