#include "argvize.c"
#define LINESZ	200		/* max command line length */

static char *expand (char *);

static int help(int argc,char **argv);

static int quitnow=0;
static  int nocmd(int argc,char **argv)
{
nr_printf("syntax error");
return 0;
}
static int quit(int argc,char **argv)
{
quitnow=1;
return 0;
}

struct mycmd{
char *name;
int (*func)(int argc,char **argv);
char *usage;
char *note;
};

#define __my_cmd __attribute__ ((unused,__section__ (".mycmd")))
#define mycmd_init(name,func,usage,note)                              \
	    static struct mycmd  __mycmd_##name __my_cmd = {#name,func,usage,note};

extern struct mycmd __mycmd_h;
extern struct mycmd __mycmd_nocmd;
static int help(int argc,char **argv)
{
struct mycmd *pcmd;
   for(pcmd=&__mycmd_h;pcmd!=&__mycmd_nocmd;pcmd++)
{
nr_printf("%-10s:%-30s:%s\n",pcmd->name,pcmd->usage,pcmd->note);
}
return 0;
}

/*
 *  Execute command
 *  ---------------
 *
 *  Execute the comman string given. If the command string given is
 *  empty, check the 'rptcmd' environment var and repeat the last
 *  command accordingly. If value is 'off' no repeat takes place. If
 *  the value is 'on' all commands repeatable can be repeated. If
 *  value is 'trace' only the 't' and 'to' commands will be repeated.
 */
void
do_cmd(p)
	char *p;
{
	char	*av[MAX_AC];	/* argument holder */
	int32_t	ac;		/* # of arguments */
	char	*cmdlist[20];
	int	 nc, j, c;
	int clistno;
	struct mycmd *pcmd;


	/* Expand command substituting $vars. Breakup into separate cmds */

	if(!(p = expand (p))) {
		return;
	}

	nc = 0;
	cmdlist[nc++] = p;
	for (; *p;) {
		c = *p;
		if(c == '\'' || c == '"') {
			p++;
			while (*p && *p != c) {
				++p;
			}
			if(*p) {
				p++;
			}
			else {
				nr_printf("unbalanced %c\n", c);
				return;
			}
		}
		else if(c == ';') {
			*p++ = 0;
			cmdlist[nc++] = p;
		}
		else {
			p++;
		}
	}

	/*
	 *  Lookup command in command list and dispatch.
	 */
	for (j = 0; j < nc; j++) {
		int stat = -1;
		ac = argvize (av, cmdlist[j]);
		if(ac == 0) {
			break;
		}

		clistno = 0;

   for(pcmd=&__mycmd_h;pcmd!=&__mycmd_nocmd;pcmd++)
   if(!strcmp(av[0],pcmd->name))break;
	stat = pcmd->func(ac, av);

		if(stat < 0) {
		nr_printf("usage:%-10s:%-30s:%s\n",pcmd->name,pcmd->usage,pcmd->note);
		}

		if(stat != 0) {
			break;	/* skip commands after ';' */
		}
	}
}

/*
 * expand(cmdline) - expand environment variables
 * entry:
 *	char *cmdline pointer to input command line
 * returns:
 *	pointer to static buffer containing expanded line.
 */
static char *
expand(cmdline)
	char *cmdline;
{
	char *ip, *op, *v;
	char var[256];
	static char expline[LINESZ + 8];

	if(!strchr (cmdline, '$')) {
		return cmdline;
	}

	ip = cmdline;
	op = expline;
	while (*ip) {
		if(op >= &expline[sizeof(expline) - 1]) {
			nr_printf ("Line too long after expansion\n");
			return (0);
		}

		if(*ip != '$') {
			*op++ = *ip++;
			continue;
		}

		ip++;
		if(*ip == '$') {
			*op++ = '$';
			ip++;
			continue;
		}

		/* get variable name */
		v = var;
		if(*ip == '{') {
			/* allow ${xxx} */
			ip++;
			while (*ip && *ip != '}') {
				*v++ = *ip++;
			}
			if(*ip && *ip != '}') {
				nr_printf ("Variable syntax\n");
				return (0);
			}
			ip++;
		} else {
			/* look for $[A-Za-z0-9]* */
			while (isalpha(*ip) || isdigit(*ip)) {
				*v++ = *ip++;
			}
		}

		*v = 0;
		if(!(v = getenv (var,0))) {
			nr_printf ("'%s': undefined\n", var);
			return (0);
		}

		if(op + strlen(v) >= &expline[sizeof(expline) - 1]) {
			nr_printf ("Line expansion ovf.\n");
			return (0);
		}

		while (*v) {
			*op++ = *v++;
		}
	}
	*op = '\0';
	return (expline);
}

mycmd_init(h,help,"h","show this help");
mycmd_init(q,quit,"q","quit this shell");
