/*******************************************************************************
 *
 * Copyright (c) 2004-2008 by Vivante Corp.  All rights reserved.
 *
 * The material in this file is confidential and contains trade secrets of
 * Vivante Corporation.  This is proprietary information owned by Vivante
 * Corporation.  No part of this work may be disclosed, reproduced, copied,
 * transmitted, or used in any way for any purpose, without the express
 * written permission of Vivante Corporation.
 *
 ******************************************************************************/

/*******************************************************************************
 *
 * This file is automatically generated on Mon Apr 13 01:22:32 2009
 *
 * Any changes made to this file are lost at the next compile run!
 * So better make sure you update the source .r files instead!
 *
 ******************************************************************************/

////////////////////////////////////////////////////////////////////////////////
//                          ~~~~~~~~~~~~~~~~~~~~~~~~                          //
//                          Module DisplayController                          //
//                          ~~~~~~~~~~~~~~~~~~~~~~~~                          //
////////////////////////////////////////////////////////////////////////////////

// Register gcregFrameBufferConfig (2 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Frame Buffer and Timing control.

#define gcregFrameBufferConfigRegAddrs                                    0x0124
#define GCREG_FRAME_BUFFER_CONFIG_Address                                0x00490
#define GCREG_FRAME_BUFFER_CONFIG_MSB                                         15
#define GCREG_FRAME_BUFFER_CONFIG_LSB                                          1
#define GCREG_FRAME_BUFFER_CONFIG_Count                                        2
#define GCREG_FRAME_BUFFER_CONFIG_FieldMask                           0x11111117
#define GCREG_FRAME_BUFFER_CONFIG_ReadMask                            0x11011117
#define GCREG_FRAME_BUFFER_CONFIG_WriteMask                           0x00111117
#define GCREG_FRAME_BUFFER_CONFIG_ResetValue                          0x00000000

// When the frame buffer address gets written to, this bit
// gets set to one.  It will be reset to zero at the start of
// the next VBLANK when the register gets copied into the
// working set.
#define GCREG_FRAME_BUFFER_CONFIG_FLIP_IN_PROGRESS                         28:28
#define GCREG_FRAME_BUFFER_CONFIG_FLIP_IN_PROGRESS_End                        28
#define GCREG_FRAME_BUFFER_CONFIG_FLIP_IN_PROGRESS_Start                      28
#define   GCREG_FRAME_BUFFER_CONFIG_FLIP_IN_PROGRESS_NO                      0x0
#define   GCREG_FRAME_BUFFER_CONFIG_FLIP_IN_PROGRESS_YES                     0x1

// When the display FIFO underflows, this bit gets set to
// one.  Reading this register will reset it back to zero.
#define GCREG_FRAME_BUFFER_CONFIG_UNDERFLOW                                24:24
#define GCREG_FRAME_BUFFER_CONFIG_UNDERFLOW_End                               24
#define GCREG_FRAME_BUFFER_CONFIG_UNDERFLOW_Start                             24
#define   GCREG_FRAME_BUFFER_CONFIG_UNDERFLOW_NO                             0x0
#define   GCREG_FRAME_BUFFER_CONFIG_UNDERFLOW_YES                            0x1

// Writing a one in this register will force a reset of the
// display controller.  All registers will be copied to the
// working set and counters will be reset to the end of HSYNC
// and VSYNC.
#define GCREG_FRAME_BUFFER_CONFIG_RESET                                    20:20
#define GCREG_FRAME_BUFFER_CONFIG_RESET_End                                   20
#define GCREG_FRAME_BUFFER_CONFIG_RESET_Start                                 20
#define   GCREG_FRAME_BUFFER_CONFIG_RESET_RESET                              0x1

// The valid field defines whether we can copy a new set of
// registers at the next VBLANK or not.  This ensures a frame
// will always start with a valid working set if this
// register is programmed last, which reduces the need for SW
// to wait for the start of a VBLANK signal in order to
// ensure all states are loaded before the next VBLANK.
#define GCREG_FRAME_BUFFER_CONFIG_VALID                                    16:16
#define GCREG_FRAME_BUFFER_CONFIG_VALID_End                                   16
#define GCREG_FRAME_BUFFER_CONFIG_VALID_Start                                 16
#define   GCREG_FRAME_BUFFER_CONFIG_VALID_WORKING                            0x0
#define   GCREG_FRAME_BUFFER_CONFIG_VALID_PENDING                            0x1

// When Gamma is enabled, the R, G, and B channels will be
// routed through the Gamma LUT to perform gamma correction.
// NOTE: This field is double buffered.
#define GCREG_FRAME_BUFFER_CONFIG_GAMMA                                    12:12
#define GCREG_FRAME_BUFFER_CONFIG_GAMMA_End                                   12
#define GCREG_FRAME_BUFFER_CONFIG_GAMMA_Start                                 12
#define   GCREG_FRAME_BUFFER_CONFIG_GAMMA_DISABLED                           0x0
#define   GCREG_FRAME_BUFFER_CONFIG_GAMMA_ENABLED                            0x1

// When Output is enabled, pixels will be displayed.  When
// Output is disabled, all pixels will be black.  This allows
// a panel to have correct timing but without any pixels.
// NOTE: This field is double buffered.
#define GCREG_FRAME_BUFFER_CONFIG_OUTPUT                                     8:8
#define GCREG_FRAME_BUFFER_CONFIG_OUTPUT_End                                   8
#define GCREG_FRAME_BUFFER_CONFIG_OUTPUT_Start                                 8
#define   GCREG_FRAME_BUFFER_CONFIG_OUTPUT_DISABLED                          0x0
#define   GCREG_FRAME_BUFFER_CONFIG_OUTPUT_ENABLED                           0x1

// Mode of the frame buffer.
// NOTE: This field is double buffered.
#define GCREG_FRAME_BUFFER_CONFIG_MODE                                       4:4
#define GCREG_FRAME_BUFFER_CONFIG_MODE_End                                     4
#define GCREG_FRAME_BUFFER_CONFIG_MODE_Start                                   4
#define   GCREG_FRAME_BUFFER_CONFIG_MODE_LINEAR                              0x0
#define   GCREG_FRAME_BUFFER_CONFIG_MODE_TILE4X4                             0x1

// The format of the frame buffer.  None means there is no
// frame buffer and the display controller will not produce
// any output.
// NOTE: This field is double buffered.
#define GCREG_FRAME_BUFFER_CONFIG_FORMAT                                     2:0
#define GCREG_FRAME_BUFFER_CONFIG_FORMAT_End                                   2
#define GCREG_FRAME_BUFFER_CONFIG_FORMAT_Start                                 0
#define   GCREG_FRAME_BUFFER_CONFIG_FORMAT_NONE                              0x0
#define   GCREG_FRAME_BUFFER_CONFIG_FORMAT_R4G4B4                            0x1
#define   GCREG_FRAME_BUFFER_CONFIG_FORMAT_R5G5B5                            0x2
#define   GCREG_FRAME_BUFFER_CONFIG_FORMAT_R5G6B5                            0x3
#define   GCREG_FRAME_BUFFER_CONFIG_FORMAT_R8G8B8                            0x4

// Register gcregFrameBufferAddress (2 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Starting address of the frame buffer.
// NOTE: This register is double buffered.

#define gcregFrameBufferAddressRegAddrs                                   0x0126
#define GCREG_FRAME_BUFFER_ADDRESS_Address                               0x00498
#define GCREG_FRAME_BUFFER_ADDRESS_MSB                                        15
#define GCREG_FRAME_BUFFER_ADDRESS_LSB                                         1
#define GCREG_FRAME_BUFFER_ADDRESS_Count                                       2
#define GCREG_FRAME_BUFFER_ADDRESS_FieldMask                          0xFFFFFFFF
#define GCREG_FRAME_BUFFER_ADDRESS_ReadMask                           0xFFFFFFFC
#define GCREG_FRAME_BUFFER_ADDRESS_WriteMask                          0xFFFFFFFC
#define GCREG_FRAME_BUFFER_ADDRESS_ResetValue                         0x00000000

#define GCREG_FRAME_BUFFER_ADDRESS_TYPE                                    31:31
#define GCREG_FRAME_BUFFER_ADDRESS_TYPE_End                                   31
#define GCREG_FRAME_BUFFER_ADDRESS_TYPE_Start                                 31
#define   GCREG_FRAME_BUFFER_ADDRESS_TYPE_SYSTEM                             0x0
#define   GCREG_FRAME_BUFFER_ADDRESS_TYPE_VIRTUAL_SYSTEM                     0x1

#define GCREG_FRAME_BUFFER_ADDRESS_ADDRESS                                  30:0
#define GCREG_FRAME_BUFFER_ADDRESS_ADDRESS_End                                30
#define GCREG_FRAME_BUFFER_ADDRESS_ADDRESS_Start                               0

// Register gcregFrameBufferStride (2 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Stride of the frame buffer in bytes.
// NOTE: This register is double buffered.

#define gcregFrameBufferStrideRegAddrs                                    0x0128
#define GCREG_FRAME_BUFFER_STRIDE_Address                                0x004A0
#define GCREG_FRAME_BUFFER_STRIDE_MSB                                         15
#define GCREG_FRAME_BUFFER_STRIDE_LSB                                          1
#define GCREG_FRAME_BUFFER_STRIDE_Count                                        2
#define GCREG_FRAME_BUFFER_STRIDE_FieldMask                           0x00003FFF
#define GCREG_FRAME_BUFFER_STRIDE_ReadMask                            0x00003FFC
#define GCREG_FRAME_BUFFER_STRIDE_WriteMask                           0x00003FFC
#define GCREG_FRAME_BUFFER_STRIDE_ResetValue                          0x00000000

// Number of bytes from start of one line to next line.
#define GCREG_FRAME_BUFFER_STRIDE_STRIDE                                    13:0
#define GCREG_FRAME_BUFFER_STRIDE_STRIDE_End                                  13
#define GCREG_FRAME_BUFFER_STRIDE_STRIDE_Start                                 0

// Register gcregFrameBufferOrigin (2 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Pixel origin inside the frame buffer for the top-left panel
// pixel.
// NOTE: This register is double buffered.

#define gcregFrameBufferOriginRegAddrs                                    0x012A
#define GCREG_FRAME_BUFFER_ORIGIN_Address                                0x004A8
#define GCREG_FRAME_BUFFER_ORIGIN_MSB                                         15
#define GCREG_FRAME_BUFFER_ORIGIN_LSB                                          1
#define GCREG_FRAME_BUFFER_ORIGIN_Count                                        2
#define GCREG_FRAME_BUFFER_ORIGIN_FieldMask                           0x07FF07FF
#define GCREG_FRAME_BUFFER_ORIGIN_ReadMask                            0x07FF07FF
#define GCREG_FRAME_BUFFER_ORIGIN_WriteMask                           0x07FF07FF
#define GCREG_FRAME_BUFFER_ORIGIN_ResetValue                          0x00000000

// X origin of frame buffer for panning.
#define GCREG_FRAME_BUFFER_ORIGIN_X                                         10:0
#define GCREG_FRAME_BUFFER_ORIGIN_X_End                                       10
#define GCREG_FRAME_BUFFER_ORIGIN_X_Start                                      0

// Y origin of frame buffer for panning.
#define GCREG_FRAME_BUFFER_ORIGIN_Y                                        26:16
#define GCREG_FRAME_BUFFER_ORIGIN_Y_End                                       26
#define GCREG_FRAME_BUFFER_ORIGIN_Y_Start                                     16

// Register gcregOverlayConfig (2 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Overlay control.

#define gcregOverlayConfigRegAddrs                                        0x012C
#define GCREG_OVERLAY_CONFIG_Address                                     0x004B0
#define GCREG_OVERLAY_CONFIG_MSB                                              15
#define GCREG_OVERLAY_CONFIG_LSB                                               1
#define GCREG_OVERLAY_CONFIG_Count                                             2
#define GCREG_OVERLAY_CONFIG_FieldMask                                0x0111FF17
#define GCREG_OVERLAY_CONFIG_ReadMask                                 0x0111FF17
#define GCREG_OVERLAY_CONFIG_WriteMask                                0x0001FF17
#define GCREG_OVERLAY_CONFIG_ResetValue                               0x00000000

// When the overlay address gets written to, this bit gets
// set to one.  It will be reset to zero at the start of the
// next VBLANK when the register gets copied into the working
// set.
#define GCREG_OVERLAY_CONFIG_FLIP_IN_PROGRESS                              24:24
#define GCREG_OVERLAY_CONFIG_FLIP_IN_PROGRESS_End                             24
#define GCREG_OVERLAY_CONFIG_FLIP_IN_PROGRESS_Start                           24
#define   GCREG_OVERLAY_CONFIG_FLIP_IN_PROGRESS_NO                           0x0
#define   GCREG_OVERLAY_CONFIG_FLIP_IN_PROGRESS_YES                          0x1

// When the overlay FIFO underflows, this bit gets set to
// one.  Reading this register will reset it back to zero.
#define GCREG_OVERLAY_CONFIG_UNDERFLOW                                     20:20
#define GCREG_OVERLAY_CONFIG_UNDERFLOW_End                                    20
#define GCREG_OVERLAY_CONFIG_UNDERFLOW_Start                                  20
#define   GCREG_OVERLAY_CONFIG_UNDERFLOW_NO                                  0x0
#define   GCREG_OVERLAY_CONFIG_UNDERFLOW_YES                                 0x1

// Mode of the overlay buffer.
// NOTE: This field is double buffered.
#define GCREG_OVERLAY_CONFIG_MODE                                          16:16
#define GCREG_OVERLAY_CONFIG_MODE_End                                         16
#define GCREG_OVERLAY_CONFIG_MODE_Start                                       16
#define   GCREG_OVERLAY_CONFIG_MODE_LINEAR                                   0x0
#define   GCREG_OVERLAY_CONFIG_MODE_TILE4X4                                  0x1

// 8-bit alpha value to be applied for planar blending.
// NOTE: This field is double buffered.
#define GCREG_OVERLAY_CONFIG_ALPHA_VALUE                                    15:8
#define GCREG_OVERLAY_CONFIG_ALPHA_VALUE_End                                  15
#define GCREG_OVERLAY_CONFIG_ALPHA_VALUE_Start                                 8

// Alpha mode for overlay.  PerPixel has per-pixel alpha
// value.  Planar uses a fixed alpha value defined in the
// AlphaValue field for all pixels.
// NOTE: This field is double buffered.
#define GCREG_OVERLAY_CONFIG_ALPHA_MODE                                      4:4
#define GCREG_OVERLAY_CONFIG_ALPHA_MODE_End                                    4
#define GCREG_OVERLAY_CONFIG_ALPHA_MODE_Start                                  4
#define   GCREG_OVERLAY_CONFIG_ALPHA_MODE_PER_PIXEL                          0x0
#define   GCREG_OVERLAY_CONFIG_ALPHA_MODE_PLANAR                             0x1

// The format of the overlay.  None means there is no
// overlay.
// NOTE: This field is double buffered.
#define GCREG_OVERLAY_CONFIG_FORMAT                                          2:0
#define GCREG_OVERLAY_CONFIG_FORMAT_End                                        2
#define GCREG_OVERLAY_CONFIG_FORMAT_Start                                      0
#define   GCREG_OVERLAY_CONFIG_FORMAT_NONE                                   0x0
#define   GCREG_OVERLAY_CONFIG_FORMAT_A4R4G4B4                               0x1
#define   GCREG_OVERLAY_CONFIG_FORMAT_A1R5G5B5                               0x2
#define   GCREG_OVERLAY_CONFIG_FORMAT_R5G6B5                                 0x3
#define   GCREG_OVERLAY_CONFIG_FORMAT_A8R8G8B8                               0x4

// Register gcregOverlayAddress (2 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Starting address of the overlay.
// NOTE: This register is double buffered.

#define gcregOverlayAddressRegAddrs                                       0x012E
#define GCREG_OVERLAY_ADDRESS_Address                                    0x004B8
#define GCREG_OVERLAY_ADDRESS_MSB                                             15
#define GCREG_OVERLAY_ADDRESS_LSB                                              1
#define GCREG_OVERLAY_ADDRESS_Count                                            2
#define GCREG_OVERLAY_ADDRESS_FieldMask                               0xFFFFFFFF
#define GCREG_OVERLAY_ADDRESS_ReadMask                                0xFFFFFFFC
#define GCREG_OVERLAY_ADDRESS_WriteMask                               0xFFFFFFFC
#define GCREG_OVERLAY_ADDRESS_ResetValue                              0x00000000

#define GCREG_OVERLAY_ADDRESS_TYPE                                         31:31
#define GCREG_OVERLAY_ADDRESS_TYPE_End                                        31
#define GCREG_OVERLAY_ADDRESS_TYPE_Start                                      31
#define   GCREG_OVERLAY_ADDRESS_TYPE_SYSTEM                                  0x0
#define   GCREG_OVERLAY_ADDRESS_TYPE_VIRTUAL_SYSTEM                          0x1

#define GCREG_OVERLAY_ADDRESS_ADDRESS                                       30:0
#define GCREG_OVERLAY_ADDRESS_ADDRESS_End                                     30
#define GCREG_OVERLAY_ADDRESS_ADDRESS_Start                                    0

// Register gcregOverlayStride (2 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Stride of the overlay in bytes.
// NOTE: This register is double buffered.

#define gcregOverlayStrideRegAddrs                                        0x0130
#define GCREG_OVERLAY_STRIDE_Address                                     0x004C0
#define GCREG_OVERLAY_STRIDE_MSB                                              15
#define GCREG_OVERLAY_STRIDE_LSB                                               1
#define GCREG_OVERLAY_STRIDE_Count                                             2
#define GCREG_OVERLAY_STRIDE_FieldMask                                0x00003FFF
#define GCREG_OVERLAY_STRIDE_ReadMask                                 0x00003FFC
#define GCREG_OVERLAY_STRIDE_WriteMask                                0x00003FFC
#define GCREG_OVERLAY_STRIDE_ResetValue                               0x00000000

// Number of bytes from start of one line to next line.
#define GCREG_OVERLAY_STRIDE_STRIDE                                         13:0
#define GCREG_OVERLAY_STRIDE_STRIDE_End                                       13
#define GCREG_OVERLAY_STRIDE_STRIDE_Start                                      0

// Register gcregOverlayTL (2 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~

// Top left coordinate of panel pixel where the overlay should
// start.  Be aware there is no panning inside the overlay.
// NOTE: This register is double buffered.

#define gcregOverlayTLRegAddrs                                            0x0132
#define GCREG_OVERLAY_TL_Address                                         0x004C8
#define GCREG_OVERLAY_TL_MSB                                                  15
#define GCREG_OVERLAY_TL_LSB                                                   1
#define GCREG_OVERLAY_TL_Count                                                 2
#define GCREG_OVERLAY_TL_FieldMask                                    0x007F07FF
#define GCREG_OVERLAY_TL_ReadMask                                     0x007F07FF
#define GCREG_OVERLAY_TL_WriteMask                                    0x007F07FF
#define GCREG_OVERLAY_TL_ResetValue                                   0x00000000

// Left boundary of overlay window.
#define GCREG_OVERLAY_TL_X                                                  10:0
#define GCREG_OVERLAY_TL_X_End                                                10
#define GCREG_OVERLAY_TL_X_Start                                               0

// Top boundary of overlay window.
#define GCREG_OVERLAY_TL_Y                                                 22:16
#define GCREG_OVERLAY_TL_Y_End                                                22
#define GCREG_OVERLAY_TL_Y_Start                                              16

// Register gcregOverlayBR (2 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~

// Bottom right coordinate of the panel pixel where the overlay
// should end.  The border is inclusive.
// NOTE: This register is double buffered.

#define gcregOverlayBRRegAddrs                                            0x0134
#define GCREG_OVERLAY_BR_Address                                         0x004D0
#define GCREG_OVERLAY_BR_MSB                                                  15
#define GCREG_OVERLAY_BR_LSB                                                   1
#define GCREG_OVERLAY_BR_Count                                                 2
#define GCREG_OVERLAY_BR_FieldMask                                    0x07FF07FF
#define GCREG_OVERLAY_BR_ReadMask                                     0x07FF07FF
#define GCREG_OVERLAY_BR_WriteMask                                    0x07FF07FF
#define GCREG_OVERLAY_BR_ResetValue                                   0x00000000

// Right boudary of overlay.
#define GCREG_OVERLAY_BR_X                                                  10:0
#define GCREG_OVERLAY_BR_X_End                                                10
#define GCREG_OVERLAY_BR_X_Start                                               0

// Bottom boundary of overlay.
#define GCREG_OVERLAY_BR_Y                                                 26:16
#define GCREG_OVERLAY_BR_Y_End                                                26
#define GCREG_OVERLAY_BR_Y_Start                                              16

// Register gcregDisplayDitherConfig (2 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Configuration register for dithering.

#define gcregDisplayDitherConfigRegAddrs                                  0x0136
#define GCREG_DISPLAY_DITHER_CONFIG_Address                              0x004D8
#define GCREG_DISPLAY_DITHER_CONFIG_MSB                                       15
#define GCREG_DISPLAY_DITHER_CONFIG_LSB                                        1
#define GCREG_DISPLAY_DITHER_CONFIG_Count                                      2
#define GCREG_DISPLAY_DITHER_CONFIG_FieldMask                         0x800F0F0F
#define GCREG_DISPLAY_DITHER_CONFIG_ReadMask                          0x800F0F0F
#define GCREG_DISPLAY_DITHER_CONFIG_WriteMask                         0x800F0F0F
#define GCREG_DISPLAY_DITHER_CONFIG_ResetValue                        0x00000000

// Enabling dithering allows R8G8B8 modes to show better on
// panels with less bits-per-pixel.
// NOTE: This field is double buffered.
#define GCREG_DISPLAY_DITHER_CONFIG_ENABLE                                 31:31
#define GCREG_DISPLAY_DITHER_CONFIG_ENABLE_End                                31
#define GCREG_DISPLAY_DITHER_CONFIG_ENABLE_Start                              31
#define   GCREG_DISPLAY_DITHER_CONFIG_ENABLE_DISABLED                        0x0
#define   GCREG_DISPLAY_DITHER_CONFIG_ENABLE_ENABLED                         0x1

// Number of important bits for the red channel for the
// panel.  Start counting from MSB.
#define GCREG_DISPLAY_DITHER_CONFIG_RED_SIZE                               19:16
#define GCREG_DISPLAY_DITHER_CONFIG_RED_SIZE_End                              19
#define GCREG_DISPLAY_DITHER_CONFIG_RED_SIZE_Start                            16

// Number of important bits for the green channel for the
// panel.  Start counting from MSB.
#define GCREG_DISPLAY_DITHER_CONFIG_GREEN_SIZE                              11:8
#define GCREG_DISPLAY_DITHER_CONFIG_GREEN_SIZE_End                            11
#define GCREG_DISPLAY_DITHER_CONFIG_GREEN_SIZE_Start                           8

// Number of important bits for the blue channel for the
// panel.  Start counting from MSB.
#define GCREG_DISPLAY_DITHER_CONFIG_BLUE_SIZE                                3:0
#define GCREG_DISPLAY_DITHER_CONFIG_BLUE_SIZE_End                              3
#define GCREG_DISPLAY_DITHER_CONFIG_BLUE_SIZE_Start                            0

// Register gcregDisplayDitherTableLow (2 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Dither table.
// NOTE: This register is double buffered.

#define gcregDisplayDitherTableLowRegAddrs                                0x0138
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Address                           0x004E0
#define GCREG_DISPLAY_DITHER_TABLE_LOW_MSB                                    15
#define GCREG_DISPLAY_DITHER_TABLE_LOW_LSB                                     1
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Count                                   2
#define GCREG_DISPLAY_DITHER_TABLE_LOW_FieldMask                      0xFFFFFFFF
#define GCREG_DISPLAY_DITHER_TABLE_LOW_ReadMask                       0xFFFFFFFF
#define GCREG_DISPLAY_DITHER_TABLE_LOW_WriteMask                      0xFFFFFFFF
#define GCREG_DISPLAY_DITHER_TABLE_LOW_ResetValue                     0x00000000

// Dither threshold value for x,y=0,0.
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Y0_X0                                 3:0
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Y0_X0_End                               3
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Y0_X0_Start                             0

// Dither threshold value for x,y=1,0.
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Y0_X1                                 7:4
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Y0_X1_End                               7
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Y0_X1_Start                             4

// Dither threshold value for x,y=2,0.
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Y0_X2                                11:8
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Y0_X2_End                              11
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Y0_X2_Start                             8

// Dither threshold value for x,y=3,0.
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Y0_X3                               15:12
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Y0_X3_End                              15
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Y0_X3_Start                            12

// Dither threshold value for x,y=0,1.
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Y1_X0                               19:16
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Y1_X0_End                              19
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Y1_X0_Start                            16

// Dither threshold value for x,y=1,1.
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Y1_X1                               23:20
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Y1_X1_End                              23
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Y1_X1_Start                            20

// Dither threshold value for x,y=2,1.
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Y1_X2                               27:24
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Y1_X2_End                              27
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Y1_X2_Start                            24

// Dither threshold value for x,y=3,1.
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Y1_X3                               31:28
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Y1_X3_End                              31
#define GCREG_DISPLAY_DITHER_TABLE_LOW_Y1_X3_Start                            28

// Register gcregDisplayDitherTableHigh (2 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define gcregDisplayDitherTableHighRegAddrs                               0x013A
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Address                          0x004E8
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_MSB                                   15
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_LSB                                    1
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Count                                  2
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_FieldMask                     0xFFFFFFFF
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_ReadMask                      0xFFFFFFFF
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_WriteMask                     0xFFFFFFFF
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_ResetValue                    0x00000000

// Dither threshold value for x,y=0,2.
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Y2_X0                                3:0
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Y2_X0_End                              3
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Y2_X0_Start                            0

// Dither threshold value for x,y=1,2.
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Y2_X1                                7:4
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Y2_X1_End                              7
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Y2_X1_Start                            4

// Dither threshold value for x,y=2,2.
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Y2_X2                               11:8
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Y2_X2_End                             11
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Y2_X2_Start                            8

// Dither threshold value for x,y=3,2.
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Y2_X3                              15:12
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Y2_X3_End                             15
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Y2_X3_Start                           12

// Dither threshold value for x,y=0,3.
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Y3_X0                              19:16
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Y3_X0_End                             19
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Y3_X0_Start                           16

// Dither threshold value for x,y=1,3.
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Y3_X1                              23:20
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Y3_X1_End                             23
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Y3_X1_Start                           20

// Dither threshold value for x,y=2,3.
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Y3_X2                              27:24
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Y3_X2_End                             27
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Y3_X2_Start                           24

// Dither threshold value for x,y=3,3.
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Y3_X3                              31:28
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Y3_X3_End                             31
#define GCREG_DISPLAY_DITHER_TABLE_HIGH_Y3_X3_Start                           28

// Register gcregPanelConfig (2 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~~~

// Panel configuration.
// NOTE: This register is only accessible through the register
// interface.

#define gcregPanelConfigRegAddrs                                          0x013C
#define GCREG_PANEL_CONFIG_Address                                       0x004F0
#define GCREG_PANEL_CONFIG_MSB                                                15
#define GCREG_PANEL_CONFIG_LSB                                                 1
#define GCREG_PANEL_CONFIG_Count                                               2
#define GCREG_PANEL_CONFIG_FieldMask                                  0x80033333
#define GCREG_PANEL_CONFIG_ReadMask                                   0x80033333
#define GCREG_PANEL_CONFIG_WriteMask                                  0x80033333
#define GCREG_PANEL_CONFIG_ResetValue                                 0x00000000

// Enable software or hardware panel sequencing.
#define GCREG_PANEL_CONFIG_SEQUENCING                                      31:31
#define GCREG_PANEL_CONFIG_SEQUENCING_End                                     31
#define GCREG_PANEL_CONFIG_SEQUENCING_Start                                   31
#define   GCREG_PANEL_CONFIG_SEQUENCING_HARDWARE                             0x0
#define   GCREG_PANEL_CONFIG_SEQUENCING_SOFTWARE                             0x1

// Backlight polarity.
#define GCREG_PANEL_CONFIG_BACKLIGHT_POLARITY                              17:17
#define GCREG_PANEL_CONFIG_BACKLIGHT_POLARITY_End                             17
#define GCREG_PANEL_CONFIG_BACKLIGHT_POLARITY_Start                           17
#define   GCREG_PANEL_CONFIG_BACKLIGHT_POLARITY_POSITIVE                     0x0
#define   GCREG_PANEL_CONFIG_BACKLIGHT_POLARITY_NEGATIVE                     0x1

// Backlight enabled/disbaled.
#define GCREG_PANEL_CONFIG_BACKLIGHT                                       16:16
#define GCREG_PANEL_CONFIG_BACKLIGHT_End                                      16
#define GCREG_PANEL_CONFIG_BACKLIGHT_Start                                    16
#define   GCREG_PANEL_CONFIG_BACKLIGHT_DISABLED                              0x0
#define   GCREG_PANEL_CONFIG_BACKLIGHT_ENABLED                               0x1

// Power polarity.
#define GCREG_PANEL_CONFIG_POWER_POLARITY                                  13:13
#define GCREG_PANEL_CONFIG_POWER_POLARITY_End                                 13
#define GCREG_PANEL_CONFIG_POWER_POLARITY_Start                               13
#define   GCREG_PANEL_CONFIG_POWER_POLARITY_POSITIVE                         0x0
#define   GCREG_PANEL_CONFIG_POWER_POLARITY_NEGATIVE                         0x1

// Power enabled/disbaled.
#define GCREG_PANEL_CONFIG_POWER                                           12:12
#define GCREG_PANEL_CONFIG_POWER_End                                          12
#define GCREG_PANEL_CONFIG_POWER_Start                                        12
#define   GCREG_PANEL_CONFIG_POWER_DISABLED                                  0x0
#define   GCREG_PANEL_CONFIG_POWER_ENABLED                                   0x1

// Clock polarity.
#define GCREG_PANEL_CONFIG_CLOCK_POLARITY                                    9:9
#define GCREG_PANEL_CONFIG_CLOCK_POLARITY_End                                  9
#define GCREG_PANEL_CONFIG_CLOCK_POLARITY_Start                                9
#define   GCREG_PANEL_CONFIG_CLOCK_POLARITY_POSITIVE                         0x0
#define   GCREG_PANEL_CONFIG_CLOCK_POLARITY_NEGATIVE                         0x1

// Clock enabled/disbaled.
#define GCREG_PANEL_CONFIG_CLOCK                                             8:8
#define GCREG_PANEL_CONFIG_CLOCK_End                                           8
#define GCREG_PANEL_CONFIG_CLOCK_Start                                         8
#define   GCREG_PANEL_CONFIG_CLOCK_DISABLED                                  0x0
#define   GCREG_PANEL_CONFIG_CLOCK_ENABLED                                   0x1

// Data polarity.
#define GCREG_PANEL_CONFIG_DATA_POLARITY                                     5:5
#define GCREG_PANEL_CONFIG_DATA_POLARITY_End                                   5
#define GCREG_PANEL_CONFIG_DATA_POLARITY_Start                                 5
#define   GCREG_PANEL_CONFIG_DATA_POLARITY_POSITIVE                          0x0
#define   GCREG_PANEL_CONFIG_DATA_POLARITY_NEGATIVE                          0x1

// Data enabled/disbaled.
#define GCREG_PANEL_CONFIG_DATA_ENABLE                                       4:4
#define GCREG_PANEL_CONFIG_DATA_ENABLE_End                                     4
#define GCREG_PANEL_CONFIG_DATA_ENABLE_Start                                   4
#define   GCREG_PANEL_CONFIG_DATA_ENABLE_DISABLED                            0x0
#define   GCREG_PANEL_CONFIG_DATA_ENABLE_ENABLED                             0x1

// Data Enable polarity.
#define GCREG_PANEL_CONFIG_DE_POLARITY                                       1:1
#define GCREG_PANEL_CONFIG_DE_POLARITY_End                                     1
#define GCREG_PANEL_CONFIG_DE_POLARITY_Start                                   1
#define   GCREG_PANEL_CONFIG_DE_POLARITY_POSITIVE                            0x0
#define   GCREG_PANEL_CONFIG_DE_POLARITY_NEGATIVE                            0x1

// Data Enable enabled/disbaled.
#define GCREG_PANEL_CONFIG_DE                                                0:0
#define GCREG_PANEL_CONFIG_DE_End                                              0
#define GCREG_PANEL_CONFIG_DE_Start                                            0
#define   GCREG_PANEL_CONFIG_DE_DISABLED                                     0x0
#define   GCREG_PANEL_CONFIG_DE_ENABLED                                      0x1

// Register gcregPanelTiming (2 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~~~

// Timing for hardware panel sequencing.
// NOTE: This register is only accessible through the register
// interface.

#define gcregPanelTimingRegAddrs                                          0x013E
#define GCREG_PANEL_TIMING_Address                                       0x004F8
#define GCREG_PANEL_TIMING_MSB                                                15
#define GCREG_PANEL_TIMING_LSB                                                 1
#define GCREG_PANEL_TIMING_Count                                               2
#define GCREG_PANEL_TIMING_FieldMask                                  0xFFFFFFFF
#define GCREG_PANEL_TIMING_ReadMask                                   0xFFFFFFFF
#define GCREG_PANEL_TIMING_WriteMask                                  0xFFFFFFFF
#define GCREG_PANEL_TIMING_ResetValue                                 0x00000000

// Number of VSYNCs to wait after power has been disabled.
#define GCREG_PANEL_TIMING_POWER_DISABLE                                   31:28
#define GCREG_PANEL_TIMING_POWER_DISABLE_End                                  31
#define GCREG_PANEL_TIMING_POWER_DISABLE_Start                                28

// Number of VSYNCs to wait after backlight has been
// disabled.
#define GCREG_PANEL_TIMING_BACKLIGHT_DISABLE                               27:24
#define GCREG_PANEL_TIMING_BACKLIGHT_DISABLE_End                              27
#define GCREG_PANEL_TIMING_BACKLIGHT_DISABLE_Start                            24

// Number of VSYNCs to wait after clock has been disabled.
#define GCREG_PANEL_TIMING_CLOCK_DISABLE                                   23:20
#define GCREG_PANEL_TIMING_CLOCK_DISABLE_End                                  23
#define GCREG_PANEL_TIMING_CLOCK_DISABLE_Start                                20

// Number of VSYNCs to wait after data has been disabled.
#define GCREG_PANEL_TIMING_DATA_DISABLE                                    19:16
#define GCREG_PANEL_TIMING_DATA_DISABLE_End                                   19
#define GCREG_PANEL_TIMING_DATA_DISABLE_Start                                 16

// Number of VSYNCs to wait after data has been enabled.
#define GCREG_PANEL_TIMING_DATA_ENABLE                                     15:12
#define GCREG_PANEL_TIMING_DATA_ENABLE_End                                    15
#define GCREG_PANEL_TIMING_DATA_ENABLE_Start                                  12

// Number of VSYNCs to wait after clock has been enabled.
#define GCREG_PANEL_TIMING_CLOCK_ENABLE                                     11:8
#define GCREG_PANEL_TIMING_CLOCK_ENABLE_End                                   11
#define GCREG_PANEL_TIMING_CLOCK_ENABLE_Start                                  8

// Number of VSYNCs to wait after backlight has been enabled.
#define GCREG_PANEL_TIMING_BACKLIGHT_ENABLE                                  7:4
#define GCREG_PANEL_TIMING_BACKLIGHT_ENABLE_End                                7
#define GCREG_PANEL_TIMING_BACKLIGHT_ENABLE_Start                              4

// Number of VSYNCsto wait after power has been enabled.
#define GCREG_PANEL_TIMING_POWER_ENABLE                                      3:0
#define GCREG_PANEL_TIMING_POWER_ENABLE_End                                    3
#define GCREG_PANEL_TIMING_POWER_ENABLE_Start                                  0

// Register gcregHDisplay (2 in total).
// ~~~~~~~~~~~~~~~~~~~~~~

// Horizontal Total and Display End counters.
// NOTE: This register is only accessible through the register
// interface.

#define gcregHDisplayRegAddrs                                             0x0140
#define GCREG_HDISPLAY_Address                                           0x00500
#define GCREG_HDISPLAY_MSB                                                    15
#define GCREG_HDISPLAY_LSB                                                     1
#define GCREG_HDISPLAY_Count                                                   2
#define GCREG_HDISPLAY_FieldMask                                      0x0FFF0FFF
#define GCREG_HDISPLAY_ReadMask                                       0x0FFF0FFF
#define GCREG_HDISPLAY_WriteMask                                      0x0FFF0FFF
#define GCREG_HDISPLAY_ResetValue                                     0x00000000

// Total number of horizontal pixels.
#define GCREG_HDISPLAY_TOTAL                                               27:16
#define GCREG_HDISPLAY_TOTAL_End                                              27
#define GCREG_HDISPLAY_TOTAL_Start                                            16

// Visible number of horizontal pixels.
#define GCREG_HDISPLAY_DISPLAY_END                                          11:0
#define GCREG_HDISPLAY_DISPLAY_END_End                                        11
#define GCREG_HDISPLAY_DISPLAY_END_Start                                       0

// Register gcregHSync (2 in total).
// ~~~~~~~~~~~~~~~~~~~

// Horizontal Sync counters.
// NOTE: This register is only accessible through the register
// interface.

#define gcregHSyncRegAddrs                                                0x0142
#define GCREG_HSYNC_Address                                              0x00508
#define GCREG_HSYNC_MSB                                                       15
#define GCREG_HSYNC_LSB                                                        1
#define GCREG_HSYNC_Count                                                      2
#define GCREG_HSYNC_FieldMask                                         0xCFFF0FFF
#define GCREG_HSYNC_ReadMask                                          0xCFFF0FFF
#define GCREG_HSYNC_WriteMask                                         0xCFFF0FFF
#define GCREG_HSYNC_ResetValue                                        0x00000000

// Polarity of the horizontal sync pulse.
#define GCREG_HSYNC_POLARITY                                               31:31
#define GCREG_HSYNC_POLARITY_End                                              31
#define GCREG_HSYNC_POLARITY_Start                                            31
#define   GCREG_HSYNC_POLARITY_POSITIVE                                      0x0
#define   GCREG_HSYNC_POLARITY_NEGATIVE                                      0x1

// Horizontal sync pulse control.
#define GCREG_HSYNC_PULSE                                                  30:30
#define GCREG_HSYNC_PULSE_End                                                 30
#define GCREG_HSYNC_PULSE_Start                                               30
#define   GCREG_HSYNC_PULSE_DISABLED                                         0x0
#define   GCREG_HSYNC_PULSE_ENABLED                                          0x1

// End of horizontal sync pulse.
#define GCREG_HSYNC_END                                                    27:16
#define GCREG_HSYNC_END_End                                                   27
#define GCREG_HSYNC_END_Start                                                 16

// Start of horizontal sync pulse.
#define GCREG_HSYNC_START                                                   11:0
#define GCREG_HSYNC_START_End                                                 11
#define GCREG_HSYNC_START_Start                                                0

// Register gcregHCounter1 (2 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~

// Horizontal Programmable Counter 1.
// NOTE: This register is only accessible through the register
// interface.

#define gcregHCounter1RegAddrs                                            0x0144
#define GCREG_HCOUNTER1_Address                                          0x00510
#define GCREG_HCOUNTER1_MSB                                                   15
#define GCREG_HCOUNTER1_LSB                                                    1
#define GCREG_HCOUNTER1_Count                                                  2
#define GCREG_HCOUNTER1_FieldMask                                     0xCFFF0FFF
#define GCREG_HCOUNTER1_ReadMask                                      0xCFFF0FFF
#define GCREG_HCOUNTER1_WriteMask                                     0xCFFF0FFF
#define GCREG_HCOUNTER1_ResetValue                                    0x00000000

// Polarity of the pulse.
#define GCREG_HCOUNTER1_POLARITY                                           31:31
#define GCREG_HCOUNTER1_POLARITY_End                                          31
#define GCREG_HCOUNTER1_POLARITY_Start                                        31
#define   GCREG_HCOUNTER1_POLARITY_POSITIVE                                  0x0
#define   GCREG_HCOUNTER1_POLARITY_NEGATIVE                                  0x1

// Horizontal counter 1 control.
#define GCREG_HCOUNTER1_PULSE                                              30:30
#define GCREG_HCOUNTER1_PULSE_End                                             30
#define GCREG_HCOUNTER1_PULSE_Start                                           30
#define   GCREG_HCOUNTER1_PULSE_DISABLED                                     0x0
#define   GCREG_HCOUNTER1_PULSE_ENABLED                                      0x1

// End of horizontal counter 1.
#define GCREG_HCOUNTER1_END                                                27:16
#define GCREG_HCOUNTER1_END_End                                               27
#define GCREG_HCOUNTER1_END_Start                                             16

// Start of horizontal counter 1.
#define GCREG_HCOUNTER1_START                                               11:0
#define GCREG_HCOUNTER1_START_End                                             11
#define GCREG_HCOUNTER1_START_Start                                            0

// Register gcregHCounter2 (2 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~

// Horizontal Programmable Counter 2.
// NOTE: This register is only accessible through the register
// interface.

#define gcregHCounter2RegAddrs                                            0x0146
#define GCREG_HCOUNTER2_Address                                          0x00518
#define GCREG_HCOUNTER2_MSB                                                   15
#define GCREG_HCOUNTER2_LSB                                                    1
#define GCREG_HCOUNTER2_Count                                                  2
#define GCREG_HCOUNTER2_FieldMask                                     0xCFFF0FFF
#define GCREG_HCOUNTER2_ReadMask                                      0xCFFF0FFF
#define GCREG_HCOUNTER2_WriteMask                                     0xCFFF0FFF
#define GCREG_HCOUNTER2_ResetValue                                    0x00000000

// Polarity of the pulse.
#define GCREG_HCOUNTER2_POLARITY                                           31:31
#define GCREG_HCOUNTER2_POLARITY_End                                          31
#define GCREG_HCOUNTER2_POLARITY_Start                                        31
#define   GCREG_HCOUNTER2_POLARITY_POSITIVE                                  0x0
#define   GCREG_HCOUNTER2_POLARITY_NEGATIVE                                  0x1

// Horizontal counter 2 control.
#define GCREG_HCOUNTER2_PULSE                                              30:30
#define GCREG_HCOUNTER2_PULSE_End                                             30
#define GCREG_HCOUNTER2_PULSE_Start                                           30
#define   GCREG_HCOUNTER2_PULSE_DISABLED                                     0x0
#define   GCREG_HCOUNTER2_PULSE_ENABLED                                      0x1

// End of horizontal counter 2.
#define GCREG_HCOUNTER2_END                                                27:16
#define GCREG_HCOUNTER2_END_End                                               27
#define GCREG_HCOUNTER2_END_Start                                             16

// Start of horizontal counter 2.
#define GCREG_HCOUNTER2_START                                               11:0
#define GCREG_HCOUNTER2_START_End                                             11
#define GCREG_HCOUNTER2_START_Start                                            0

// Register gcregVDisplay (2 in total).
// ~~~~~~~~~~~~~~~~~~~~~~

// Vertical Total and Display End counters.
// NOTE: This register is only accessible through the register
// interface.

#define gcregVDisplayRegAddrs                                             0x0148
#define GCREG_VDISPLAY_Address                                           0x00520
#define GCREG_VDISPLAY_MSB                                                    15
#define GCREG_VDISPLAY_LSB                                                     1
#define GCREG_VDISPLAY_Count                                                   2
#define GCREG_VDISPLAY_FieldMask                                      0x07FF07FF
#define GCREG_VDISPLAY_ReadMask                                       0x07FF07FF
#define GCREG_VDISPLAY_WriteMask                                      0x07FF07FF
#define GCREG_VDISPLAY_ResetValue                                     0x00000000

// Total number of vertical lines.
#define GCREG_VDISPLAY_TOTAL                                               26:16
#define GCREG_VDISPLAY_TOTAL_End                                              26
#define GCREG_VDISPLAY_TOTAL_Start                                            16

// Visible number of vertical lines.
#define GCREG_VDISPLAY_DISPLAY_END                                          10:0
#define GCREG_VDISPLAY_DISPLAY_END_End                                        10
#define GCREG_VDISPLAY_DISPLAY_END_Start                                       0

// Register gcregVSync (2 in total).
// ~~~~~~~~~~~~~~~~~~~

// Vertical Sync counters.
// NOTE: This register is only accessible through the register
// interface.

#define gcregVSyncRegAddrs                                                0x014A
#define GCREG_VSYNC_Address                                              0x00528
#define GCREG_VSYNC_MSB                                                       15
#define GCREG_VSYNC_LSB                                                        1
#define GCREG_VSYNC_Count                                                      2
#define GCREG_VSYNC_FieldMask                                         0xCFFF0FFF
#define GCREG_VSYNC_ReadMask                                          0xCFFF0FFF
#define GCREG_VSYNC_WriteMask                                         0xCFFF0FFF
#define GCREG_VSYNC_ResetValue                                        0x00000000

// Polarity of the vertical sync pulse.
#define GCREG_VSYNC_POLARITY                                               31:31
#define GCREG_VSYNC_POLARITY_End                                              31
#define GCREG_VSYNC_POLARITY_Start                                            31
#define   GCREG_VSYNC_POLARITY_POSITIVE                                      0x0
#define   GCREG_VSYNC_POLARITY_NEGATIVE                                      0x1

// Vertical sync pulse control.
#define GCREG_VSYNC_PULSE                                                  30:30
#define GCREG_VSYNC_PULSE_End                                                 30
#define GCREG_VSYNC_PULSE_Start                                               30
#define   GCREG_VSYNC_PULSE_DISABLED                                         0x0
#define   GCREG_VSYNC_PULSE_ENABLED                                          0x1

// End of the vertical sync pulse.
#define GCREG_VSYNC_END                                                    27:16
#define GCREG_VSYNC_END_End                                                   27
#define GCREG_VSYNC_END_Start                                                 16

// Start of the vertical sync pulse.
#define GCREG_VSYNC_START                                                   11:0
#define GCREG_VSYNC_START_End                                                 11
#define GCREG_VSYNC_START_Start                                                0

// Register gcregDisplayCurrentLocation (2 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Current x,y location of display controller.
// NOTE: This register is only accessible through the register
// interface.

#define gcregDisplayCurrentLocationRegAddrs                               0x014C
#define GCREG_DISPLAY_CURRENT_LOCATION_Address                           0x00530
#define GCREG_DISPLAY_CURRENT_LOCATION_MSB                                    15
#define GCREG_DISPLAY_CURRENT_LOCATION_LSB                                     1
#define GCREG_DISPLAY_CURRENT_LOCATION_Count                                   2
#define GCREG_DISPLAY_CURRENT_LOCATION_FieldMask                      0x07FF07FF
#define GCREG_DISPLAY_CURRENT_LOCATION_ReadMask                       0x07FF07FF
#define GCREG_DISPLAY_CURRENT_LOCATION_WriteMask                      0x00000000
#define GCREG_DISPLAY_CURRENT_LOCATION_ResetValue                     0x00000000

// Current X location.
#define GCREG_DISPLAY_CURRENT_LOCATION_X                                    10:0
#define GCREG_DISPLAY_CURRENT_LOCATION_X_End                                  10
#define GCREG_DISPLAY_CURRENT_LOCATION_X_Start                                 0

// Current Y location.
#define GCREG_DISPLAY_CURRENT_LOCATION_Y                                   26:16
#define GCREG_DISPLAY_CURRENT_LOCATION_Y_End                                  26
#define GCREG_DISPLAY_CURRENT_LOCATION_Y_Start                                16

// Register gcregGammaIndex (2 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~~

// Index into gamma table.  See gcregGammaData for more
// information.
// NOTE: This register is accessible only through the register
// interface.

#define gcregGammaIndexRegAddrs                                           0x014E
#define GCREG_GAMMA_INDEX_Address                                        0x00538
#define GCREG_GAMMA_INDEX_MSB                                                 15
#define GCREG_GAMMA_INDEX_LSB                                                  1
#define GCREG_GAMMA_INDEX_Count                                                2
#define GCREG_GAMMA_INDEX_FieldMask                                   0x000000FF
#define GCREG_GAMMA_INDEX_ReadMask                                    0x000000FF
#define GCREG_GAMMA_INDEX_WriteMask                                   0x000000FF
#define GCREG_GAMMA_INDEX_ResetValue                                  0x00000000

// Index into gamma table.
#define GCREG_GAMMA_INDEX_INDEX                                              7:0
#define GCREG_GAMMA_INDEX_INDEX_End                                            7
#define GCREG_GAMMA_INDEX_INDEX_Start                                          0

// Register gcregGammaData (2 in total).
// ~~~~~~~~~~~~~~~~~~~~~~~

// Translation values for the gamma table.  When this register
// gets written, the data gets stored in the gamma table at the
// index specified by the gcregGammaIndex register.  After the
// register is written, the index gets incremented.
// NOTE: This register is accessible only through the register
// interface.

#define gcregGammaDataRegAddrs                                            0x0150
#define GCREG_GAMMA_DATA_Address                                         0x00540
#define GCREG_GAMMA_DATA_MSB                                                  15
#define GCREG_GAMMA_DATA_LSB                                                   1
#define GCREG_GAMMA_DATA_Count                                                 2
#define GCREG_GAMMA_DATA_FieldMask                                    0x00FFFFFF
#define GCREG_GAMMA_DATA_ReadMask                                     0x00FFFFFF
#define GCREG_GAMMA_DATA_WriteMask                                    0x00FFFFFF
#define GCREG_GAMMA_DATA_ResetValue                                   0x00000000

// Red translation value.
#define GCREG_GAMMA_DATA_RED                                               23:16
#define GCREG_GAMMA_DATA_RED_End                                              23
#define GCREG_GAMMA_DATA_RED_Start                                            16

// Green translation value.
#define GCREG_GAMMA_DATA_GREEN                                              15:8
#define GCREG_GAMMA_DATA_GREEN_End                                            15
#define GCREG_GAMMA_DATA_GREEN_Start                                           8

// Blue translation value.
#define GCREG_GAMMA_DATA_BLUE                                                7:0
#define GCREG_GAMMA_DATA_BLUE_End                                              7
#define GCREG_GAMMA_DATA_BLUE_Start                                            0

// Register gcregCursorConfig.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~

// Configuration register for the cursor.
// NOTE: This register is accessible only through the register
// interface.

#define gcregCursorConfigRegAddrs                                         0x0152
#define GCREG_CURSOR_CONFIG_Address                                      0x00548
#define GCREG_CURSOR_CONFIG_MSB                                               15
#define GCREG_CURSOR_CONFIG_LSB                                                0
#define GCREG_CURSOR_CONFIG_Count                                              1
#define GCREG_CURSOR_CONFIG_FieldMask                                 0x801F1F13
#define GCREG_CURSOR_CONFIG_ReadMask                                  0x801F1F13
#define GCREG_CURSOR_CONFIG_WriteMask                                 0x001F1F13
#define GCREG_CURSOR_CONFIG_ResetValue                                0x00000000

// When the cursor address gets written to, this bit gets set
// to one.  It will be reset to zero at the start of the next
// VBLANK of the owning display when the register gets copied
// into the working set.
#define GCREG_CURSOR_CONFIG_FLIP_IN_PROGRESS                               31:31
#define GCREG_CURSOR_CONFIG_FLIP_IN_PROGRESS_End                              31
#define GCREG_CURSOR_CONFIG_FLIP_IN_PROGRESS_Start                            31
#define   GCREG_CURSOR_CONFIG_FLIP_IN_PROGRESS_NO                            0x0
#define   GCREG_CURSOR_CONFIG_FLIP_IN_PROGRESS_YES                           0x1

// Horizontal offset to cursor hotspot.
// NOTE: This field is double buffered.
#define GCREG_CURSOR_CONFIG_HOT_SPOT_X                                     20:16
#define GCREG_CURSOR_CONFIG_HOT_SPOT_X_End                                    20
#define GCREG_CURSOR_CONFIG_HOT_SPOT_X_Start                                  16

// Vertical offset to cursor hotspot.
// NOTE: This field is double buffered.
#define GCREG_CURSOR_CONFIG_HOT_SPOT_Y                                      12:8
#define GCREG_CURSOR_CONFIG_HOT_SPOT_Y_End                                    12
#define GCREG_CURSOR_CONFIG_HOT_SPOT_Y_Start                                   8

// Display Controller owning the cursor.
#define GCREG_CURSOR_CONFIG_DISPLAY                                          4:4
#define GCREG_CURSOR_CONFIG_DISPLAY_End                                        4
#define GCREG_CURSOR_CONFIG_DISPLAY_Start                                      4
#define   GCREG_CURSOR_CONFIG_DISPLAY_DISPLAY0                               0x0
#define   GCREG_CURSOR_CONFIG_DISPLAY_DISPLAY1                               0x1

// Format of the cursor.
// NOTE: This field is double buffered.
#define GCREG_CURSOR_CONFIG_FORMAT                                           1:0
#define GCREG_CURSOR_CONFIG_FORMAT_End                                         1
#define GCREG_CURSOR_CONFIG_FORMAT_Start                                       0
#define   GCREG_CURSOR_CONFIG_FORMAT_DISABLED                                0x0
#define   GCREG_CURSOR_CONFIG_FORMAT_MASKED                                  0x1
#define   GCREG_CURSOR_CONFIG_FORMAT_A8R8G8B8                                0x2

// Register gcregCursorAddress.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Address of the cursor shape.
// NOTE: This register is double buffered and is accessible only
// through the register interface.

#define gcregCursorAddressRegAddrs                                        0x0153
#define GCREG_CURSOR_ADDRESS_Address                                     0x0054C
#define GCREG_CURSOR_ADDRESS_MSB                                              15
#define GCREG_CURSOR_ADDRESS_LSB                                               0
#define GCREG_CURSOR_ADDRESS_Count                                             1
#define GCREG_CURSOR_ADDRESS_FieldMask                                0xFFFFFFFF
#define GCREG_CURSOR_ADDRESS_ReadMask                                 0xFFFFFFFC
#define GCREG_CURSOR_ADDRESS_WriteMask                                0xFFFFFFFC
#define GCREG_CURSOR_ADDRESS_ResetValue                               0x00000000

#define GCREG_CURSOR_ADDRESS_TYPE                                          31:31
#define GCREG_CURSOR_ADDRESS_TYPE_End                                         31
#define GCREG_CURSOR_ADDRESS_TYPE_Start                                       31
#define   GCREG_CURSOR_ADDRESS_TYPE_SYSTEM                                   0x0
#define   GCREG_CURSOR_ADDRESS_TYPE_VIRTUAL_SYSTEM                           0x1

#define GCREG_CURSOR_ADDRESS_ADDRESS                                        30:0
#define GCREG_CURSOR_ADDRESS_ADDRESS_End                                      30
#define GCREG_CURSOR_ADDRESS_ADDRESS_Start                                     0

// Register gcregCursorLocation.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Location of the cursor on the owning display.
// NOTE: This register is double buffered and is accessible only
// through the register interface.

#define gcregCursorLocationRegAddrs                                       0x0154
#define GCREG_CURSOR_LOCATION_Address                                    0x00550
#define GCREG_CURSOR_LOCATION_MSB                                             15
#define GCREG_CURSOR_LOCATION_LSB                                              0
#define GCREG_CURSOR_LOCATION_Count                                            1
#define GCREG_CURSOR_LOCATION_FieldMask                               0x07FF07FF
#define GCREG_CURSOR_LOCATION_ReadMask                                0x07FF07FF
#define GCREG_CURSOR_LOCATION_WriteMask                               0x07FF07FF
#define GCREG_CURSOR_LOCATION_ResetValue                              0x00000000

// X location of cursor's hotspot.
#define GCREG_CURSOR_LOCATION_X                                             10:0
#define GCREG_CURSOR_LOCATION_X_End                                           10
#define GCREG_CURSOR_LOCATION_X_Start                                          0

// Y location of cursor's hotspot.
#define GCREG_CURSOR_LOCATION_Y                                            26:16
#define GCREG_CURSOR_LOCATION_Y_End                                           26
#define GCREG_CURSOR_LOCATION_Y_Start                                         16

// Register gcregCursorBackground.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// The background color for Masked cursors.
// NOTE: This register is double buffered and is accessible only
// through the register interface.

#define gcregCursorBackgroundRegAddrs                                     0x0155
#define GCREG_CURSOR_BACKGROUND_Address                                  0x00554
#define GCREG_CURSOR_BACKGROUND_MSB                                           15
#define GCREG_CURSOR_BACKGROUND_LSB                                            0
#define GCREG_CURSOR_BACKGROUND_Count                                          1
#define GCREG_CURSOR_BACKGROUND_FieldMask                             0x00FFFFFF
#define GCREG_CURSOR_BACKGROUND_ReadMask                              0x00FFFFFF
#define GCREG_CURSOR_BACKGROUND_WriteMask                             0x00FFFFFF
#define GCREG_CURSOR_BACKGROUND_ResetValue                            0x00000000

// Red value.
#define GCREG_CURSOR_BACKGROUND_RED                                        23:16
#define GCREG_CURSOR_BACKGROUND_RED_End                                       23
#define GCREG_CURSOR_BACKGROUND_RED_Start                                     16

// Green value.
#define GCREG_CURSOR_BACKGROUND_GREEN                                       15:8
#define GCREG_CURSOR_BACKGROUND_GREEN_End                                     15
#define GCREG_CURSOR_BACKGROUND_GREEN_Start                                    8

// Blue value.
#define GCREG_CURSOR_BACKGROUND_BLUE                                         7:0
#define GCREG_CURSOR_BACKGROUND_BLUE_End                                       7
#define GCREG_CURSOR_BACKGROUND_BLUE_Start                                     0

// Register gcregCursorForeground.
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// The foreground color for Masked cursors.
// NOTE: This register is double buffered and is accessible only
// through the register interface.

#define gcregCursorForegroundRegAddrs                                     0x0156
#define GCREG_CURSOR_FOREGROUND_Address                                  0x00558
#define GCREG_CURSOR_FOREGROUND_MSB                                           15
#define GCREG_CURSOR_FOREGROUND_LSB                                            0
#define GCREG_CURSOR_FOREGROUND_Count                                          1
#define GCREG_CURSOR_FOREGROUND_FieldMask                             0x00FFFFFF
#define GCREG_CURSOR_FOREGROUND_ReadMask                              0x00FFFFFF
#define GCREG_CURSOR_FOREGROUND_WriteMask                             0x00FFFFFF
#define GCREG_CURSOR_FOREGROUND_ResetValue                            0x00000000

// Red value.
#define GCREG_CURSOR_FOREGROUND_RED                                        23:16
#define GCREG_CURSOR_FOREGROUND_RED_End                                       23
#define GCREG_CURSOR_FOREGROUND_RED_Start                                     16

// Green value.
#define GCREG_CURSOR_FOREGROUND_GREEN                                       15:8
#define GCREG_CURSOR_FOREGROUND_GREEN_End                                     15
#define GCREG_CURSOR_FOREGROUND_GREEN_Start                                    8

// Blue value.
#define GCREG_CURSOR_FOREGROUND_BLUE                                         7:0
#define GCREG_CURSOR_FOREGROUND_BLUE_End                                       7
#define GCREG_CURSOR_FOREGROUND_BLUE_Start                                     0

