/* dummy.c: a dummy net driver

	The purpose of this driver is to provide a device to point a
	route through, but not to actually transmit packets.

	Why?  If you have a machine whose only connection is an occasional
	PPP/SLIP/PLIP link, you can only connect to your own hostname
	when the link is up.  Otherwise you have to use localhost.
	This isn't very consistent.

	One solution is to set up a dummy link using PPP/SLIP/PLIP,
	but this seems (to me) too much overhead for too little gain.
	This driver provides a small alternative. Thus you can do
	
	[when not running slip]
		ifconfig dummy slip.addr.ess.here up
	[to go to slip]
		ifconfig dummy down
		dip whatever

	This was written by looking at Donald Becker's skeleton driver
	and the loopback driver.  I then threw away anything that didn't
	apply!	Thanks to Alan Cox for the key clue on what to do with
	misguided packets.

			Nick Holloway, 27th May 1994
	[I tweaked this explanation a little but that's all]
			Alan Cox, 30th May 1994
*/

/* To have statistics (just packets sent) define this */

#include <linux/config.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/netdevice.h>
#include <linux/init.h>
#include <asm/uaccess.h>
#include <asm/ioctls.h>
int errno=0;
#define  __KERNEL_SYSCALLS__
#include <asm/unistd.h>
#include "pci.c"

#define PCHAR(x) *(volatile unsigned char *)(x)
#define PSHORT(x) *(volatile unsigned short *)(x)
#define PLONG(x) *(volatile unsigned long *)(x)

static void delay(int j)
{
	volatile int k = 0;
	volatile int q;
	for(k=0;k<=j;k++)
	{
		q = k*k;
	}
}

#define BASE 0xb4000378
#define ADDRPORT BASE
#define DATAPORT BASE+1
#define CTRLPORT BASE+2
#define EPPADDRPORT BASE+3
#define EPPDATAPORT BASE+4
#define MODESELPORT BASE+0xc
static unsigned int a=0xb4000000;
static unsigned int d=0;
static char *f=0;
static int __init dummy_init_module(void)
{
unsigned int data;
//sysPciCfgWrite(0,1,4,0x68,0x87013000);
switch(f[0])
{
	case('r'):
{
  switch(f[1])
  {
	case 'b':printk("%08x:%02x\n",a,*(volatile unsigned char *)a);break;
	case 'h':printk("%08x:%04x\n",a,*(volatile unsigned short *)a);break;
	case 'w':*(unsigned int *)a=d;printk("%08x:%08x\n",a,*(volatile unsigned int *)a);break;
	default:printk("error\n");return -1;
  }
}; break;

case('w'):{
  switch(f[1])
  {
	case 'b':*(volatile unsigned char *)a=d;printk("%08x:%02x\n",a,*(volatile unsigned char *)a);break;
	case 'h':*(volatile unsigned short *)a=d;printk("%08x:%04x\n",a,*(volatile unsigned short *)a);break;
	case 'w':*(volatile unsigned long *)a=d;*(unsigned int *)a=d;printk("%08x:%08x\n",a,*(volatile unsigned long *)a);break;
	default:printk("error\n");return -1;
  }
	
};break;
default:return -1;
}
return -1;

printk("%08x:%08x\n",a,d);
sysPciCfgRead(0,1,4,0x4,32,&data);
printk("<0>%08x\n",data);
sysPciCfgRead(0,1,4,0x68,32,&data);
printk("<0>%08x\n",data);
	PCHAR(MODESELPORT)=3;
	PCHAR(CTRLPORT)=0xc4;
	//PCHAR(0xb4013002)=0xc0;//0xc4;
printk("<0>0c:%02x,01:%02x,02:%02x\n",PCHAR(MODESELPORT),PCHAR(ADDRPORT),PCHAR(DATAPORT));
	return -1;
}


static void __exit dummy_cleanup_module(void)
{

}

module_init(dummy_init_module);
module_exit(dummy_cleanup_module);
MODULE_LICENSE("GPL");
MODULE_PARM(a,"i");
MODULE_PARM(d,"i");
MODULE_PARM(f,"s");

