#define	SST_CMDOFFS	0x5555
#define SST_CMDOFFS1 0x5555
#define SST_CMDOFFS2 0x2aaa
#define FL_ERASE	0x80
#define FL_ERASE_CHIP	0x10
#define FL_PROGRAM 0xa0
#define FL_AUTOSEL 	0x90	/* Device identification */
#define FL_SECT		0x30
#define FL_BLOCK		0x50

int off[]={0,0x5555,0x2aaa};
int base=0xbfc08000;
int sectorsize=0x1000;
int common_op(char *c,int size)
{
int i;
for(i=0;i<size;i+=2)
{
*(volatile char *)(base+off[c[i]]) = c[i+1];
}
return 0;
}

int reset()
{
unsigned char c[]={0,0xf0};
common_op(c,sizeof(c));
return 0;
}

int identify()
{
unsigned char c[]={1,0xaa,2,0x55,1,FL_AUTOSEL};
common_op(c,sizeof(c));
printf("id=%x,mfc=%x\n",((volatile unsigned char *)base)[0],((volatile unsigned char *)base)[1]);
return 0;
}

int erase_chip()
{
char c[]={1,0xaa,2,0x55,1,FL_ERASE,1,0xaa,2,0x55,1,FL_ERASE_CHIP};
int i;
printf("erase chip\n");
common_op(c,sizeof(c));
return 0;
}


int erase_sect(int soff,int eoff,int sectorsize)
{
char c[]={1,0xaa,2,0x55,1,FL_ERASE,1,0xaa,2,0x55,0,FL_SECT};
int i;
int old;
printf("erase sect\n");
for(i=soff;i<eoff;i+=sectorsize)
{
off[0] = i;
common_op(c,sizeof(c));
}
return 0;
}

int program(char *buf,int soff,int eoff)
{
char c[]={1,0xaa,2,0x55,1,FL_PROGRAM};
int i;
for(i=soff;i<eoff;i++)
{
	common_op(c,sizeof(c));
	*(volatile char *)(base+i) = buf[i-soff];
	while( *(volatile char *)(base+i)!= *(volatile char *)(base+i));
}
return 0;
}

int mymain(char *cmd,int flashbase,...)
{
void **arg;
void *ap;
__builtin_va_start(ap,flashbase);
arg=ap;

base = flashbase;
if(cmd[0]=='i')
identify();
else if(!strcmp(cmd,"erasesect"))
erase_sect(*arg++,*arg++,*arg++);
else if(!strcmp(cmd,"erasechip"))
erase_chip();
else if(cmd[0]=='p')
program(*arg++,*arg++,*arg++);
else if(cmd[0]=='r')
reset();

return 0;
}
